/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.api.IStructureBuilder;
import net.shadowmage.ancientwarfare.structure.block.BlockProtectionFlag;
import net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules.TemplateRuleBlockTile;

public class TemplateRuleFlag
extends TemplateRuleBlockTile {
    public static final String PLUGIN_NAME = "flag";

    public TemplateRuleFlag(World world, BlockPos pos, IBlockState state, int turns) {
        super(world, pos, TemplateRuleFlag.rotate(state, turns), turns);
    }

    public TemplateRuleFlag() {
    }

    @Override
    public void handlePlacement(World world, int turns, BlockPos pos, IStructureBuilder builder) {
        builder.placeBlock(pos, this.getState(turns), this.buildPass);
        WorldTools.getTile((IBlockAccess)world, pos).ifPresent(t -> {
            this.tag.func_74768_a("x", pos.func_177958_n());
            this.tag.func_74768_a("y", pos.func_177956_o());
            this.tag.func_74768_a("z", pos.func_177952_p());
            t.func_145839_a(this.tag);
        });
    }

    @Override
    public IBlockState getState(int turns) {
        return TemplateRuleFlag.rotate(this.state, turns);
    }

    private static IBlockState rotate(IBlockState state, int turns) {
        return state.func_177226_a((IProperty)BlockProtectionFlag.ROTATION, (Comparable)Integer.valueOf(((Integer)state.func_177229_b((IProperty)BlockProtectionFlag.ROTATION) + 4 * turns) % 16));
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }
}

