/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.shadowmage.ancientwarfare.structure.tile.TileColored;

public class TileAltarCandle
extends TileColored {
    private static final String FLAME_COLOR_TAG = "flameColor";
    private static final String FLAME_SMOKE_TAG = "flameSmoke";
    private int flameColor = -1;
    private boolean flameSmoke = false;

    public int getFlameColor() {
        return this.flameColor;
    }

    public boolean isFlameSmoke() {
        return this.flameSmoke;
    }

    @Override
    public void setFromStack(ItemStack stack) {
        super.setFromStack(stack);
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag.func_74764_b(FLAME_COLOR_TAG)) {
                this.flameColor = tag.func_74762_e(FLAME_COLOR_TAG);
            }
            if (tag.func_74764_b(FLAME_SMOKE_TAG)) {
                this.flameSmoke = tag.func_74767_n(FLAME_SMOKE_TAG);
            }
        }
    }

    @Override
    protected void readNBT(NBTTagCompound compound) {
        super.readNBT(compound);
        if (compound.func_74764_b(FLAME_COLOR_TAG)) {
            this.flameColor = compound.func_74762_e(FLAME_COLOR_TAG);
        }
        this.flameSmoke = compound.func_74767_n(FLAME_SMOKE_TAG);
    }

    @Override
    protected void writeNBT(NBTTagCompound compound) {
        super.writeNBT(compound);
        if (this.flameColor != -1) {
            compound.func_74768_a(FLAME_COLOR_TAG, this.flameColor);
        }
        if (this.flameSmoke) {
            compound.func_74757_a(FLAME_SMOKE_TAG, true);
        }
    }

    @Override
    public ItemStack getPickBlock() {
        ItemStack stack = super.getPickBlock();
        if (this.flameColor != -1) {
            stack.func_77983_a(FLAME_COLOR_TAG, (NBTBase)new NBTTagInt(this.flameColor));
        }
        if (this.flameSmoke) {
            stack.func_77983_a(FLAME_SMOKE_TAG, (NBTBase)new NBTTagByte(1));
        }
        return stack;
    }
}

