/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.block.BlockCoffin;
import net.shadowmage.ancientwarfare.structure.init.AWStructureSounds;
import net.shadowmage.ancientwarfare.structure.tile.ISpecialLootContainer;
import net.shadowmage.ancientwarfare.structure.tile.LootSettings;
import net.shadowmage.ancientwarfare.structure.tile.TileMulti;
import net.shadowmage.ancientwarfare.structure.util.LootHelper;

public class TileCoffin
extends TileMulti
implements ITickable,
ISpecialLootContainer {
    private boolean upright = false;
    private BlockCoffin.CoffinDirection direction = BlockCoffin.CoffinDirection.NORTH;
    private boolean opening = false;
    private boolean open = false;
    private float prevLidAngle = 0.0f;
    private float lidAngle = 0.0f;
    private int openTime = 0;
    private LootSettings lootSettings = new LootSettings();
    private static final float OPEN_ANGLE = 15.0f;
    private static final int TOTAL_OPEN_TIME = 20;
    private int variant = 1;

    public int getVariant() {
        return this.variant;
    }

    public void setVariant(int variant) {
        this.variant = variant;
    }

    @Override
    public Set<BlockPos> getAdditionalPositions(IBlockState state) {
        return this.upright ? ImmutableSet.of((Object)this.field_174879_c.func_177984_a(), (Object)this.field_174879_c.func_177984_a().func_177984_a()) : ImmutableSet.of((Object)this.field_174879_c.func_177972_a(this.direction.getFacing()), (Object)this.field_174879_c.func_177972_a(this.direction.getFacing()).func_177972_a(this.direction.getFacing()));
    }

    @Override
    public void setPlacementDirection(World world, BlockPos pos, IBlockState state, EnumFacing horizontalFacing, float rotationYaw) {
        this.setDirection(this.upright ? BlockCoffin.CoffinDirection.fromYaw(rotationYaw) : BlockCoffin.CoffinDirection.fromFacing(horizontalFacing));
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readNBT(compound);
    }

    private void readNBT(NBTTagCompound compound) {
        this.upright = compound.func_74767_n("upright");
        this.direction = BlockCoffin.CoffinDirection.fromName(compound.func_74779_i("direction"));
        this.variant = compound.func_74762_e("variant");
        this.opening = compound.func_74767_n("opening");
        this.open = compound.func_74767_n("open");
        if (this.open) {
            this.prevLidAngle = 15.0f;
            this.lidAngle = 15.0f;
        }
        this.lootSettings = LootSettings.deserializeNBT(compound.func_74775_l("lootSettings"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        this.writeNBT(compound);
        return compound;
    }

    private void writeNBT(NBTTagCompound compound) {
        compound.func_74757_a("upright", this.upright);
        compound.func_74778_a("direction", this.direction.func_176610_l());
        compound.func_74768_a("variant", this.variant);
        compound.func_74757_a("opening", this.opening);
        compound.func_74757_a("open", this.open);
        compound.func_74782_a("lootSettings", (NBTBase)this.lootSettings.serializeNBT());
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        this.writeNBT(tag);
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        this.readNBT(tag);
    }

    public void setUpright(boolean upright) {
        this.upright = upright;
    }

    public void setDirection(BlockCoffin.CoffinDirection direction) {
        this.direction = direction;
    }

    public BlockCoffin.CoffinDirection getDirection() {
        return this.direction;
    }

    public boolean getUpright() {
        return this.upright;
    }

    public void open(EntityPlayer player) {
        Optional<BlockPos> mainPos = this.getMainBlockPos();
        if (!mainPos.isPresent() || mainPos.get().equals((Object)this.field_174879_c)) {
            if (!this.open && !this.opening) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, AWStructureSounds.COFFIN_OPENS, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.opening = true;
            }
            this.dropLoot(player);
            return;
        }
        WorldTools.getTile((IBlockAccess)this.field_145850_b, mainPos.get(), TileCoffin.class).ifPresent(te -> te.open(player));
    }

    private void dropLoot(EntityPlayer player) {
        if (this.open) {
            return;
        }
        Optional<BlockPos> mainPos = this.getMainBlockPos();
        if (!mainPos.isPresent() || mainPos.get().equals((Object)this.field_174879_c)) {
            if (!this.field_145850_b.field_72995_K) {
                LootHelper.dropLoot(this, player);
            }
            return;
        }
        WorldTools.getTile((IBlockAccess)this.field_145850_b, mainPos.get(), TileCoffin.class).ifPresent(te -> te.dropLoot(player));
    }

    @Override
    public void onBlockBroken(IBlockState state) {
        this.dropLoot(EntityTools.findClosestPlayer(this.field_145850_b, this.field_174879_c, 100));
        super.onBlockBroken(state);
    }

    public void func_73660_a() {
        if (this.opening && !this.open) {
            this.prevLidAngle = this.lidAngle;
            ++this.openTime;
            float halfAngle = 7.5f;
            float halfTime = 10.0f;
            if ((float)this.openTime > halfTime) {
                float ratio = (float)(20 - this.openTime) / halfTime;
                this.lidAngle = 15.0f - halfAngle * ratio * ratio;
            } else {
                float ratio = (float)this.openTime / halfTime;
                this.lidAngle = halfAngle * ratio * ratio;
            }
            if (this.lidAngle >= 15.0f) {
                this.prevLidAngle = this.lidAngle;
                this.open = true;
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.upright) {
            return new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(2, 3, 2));
        }
        Vec3i vec = this.direction.getFacing().func_176730_m();
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(2, 1, 2)).func_72321_a((double)vec.func_177958_n(), (double)vec.func_177956_o(), (double)vec.func_177952_p());
    }

    public float getPrevLidAngle() {
        return this.prevLidAngle;
    }

    public float getLidAngle() {
        return this.lidAngle;
    }

    @Override
    public void setLootSettings(LootSettings settings) {
        this.lootSettings = settings;
    }

    @Override
    public LootSettings getLootSettings() {
        return this.lootSettings;
    }
}

