/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.shadowmage.ancientwarfare.core.tile.IBlockBreakHandler;
import net.shadowmage.ancientwarfare.core.tile.TileUpdatable;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.structure.init.AWStructureItems;
import net.shadowmage.ancientwarfare.structure.item.ItemStructureScanner;
import net.shadowmage.ancientwarfare.structure.item.ItemStructureSettings;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBuilder;
import net.shadowmage.ancientwarfare.structure.template.scan.TemplateScanner;
import net.shadowmage.ancientwarfare.structure.tile.ScannerTracker;

public class TileStructureScanner
extends TileUpdatable
implements IBlockBreakHandler {
    private static final String SCANNER_INVENTORY_TAG = "scannerInventory";
    private static final String BOUNDS_ACTIVE_TAG = "boundsActive";
    private static final String FACING_TAG = "facing";
    private ItemStackHandler scannerInventory = new ItemStackHandler(1){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack.func_77973_b() == AWStructureItems.STRUCTURE_SCANNER ? super.insertItem(slot, stack, simulate) : stack;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (!((TileStructureScanner)TileStructureScanner.this).field_145850_b.field_72995_K) {
                BlockTools.notifyBlockUpdate(TileStructureScanner.this);
            }
        }
    };
    private boolean boundsActive = true;
    private EnumFacing facing = EnumFacing.NORTH;
    private EnumFacing renderFacing = EnumFacing.NORTH;

    public ItemStackHandler getScannerInventory() {
        return this.scannerInventory;
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        tag.func_74782_a(SCANNER_INVENTORY_TAG, (NBTBase)this.scannerInventory.serializeNBT());
        tag.func_74757_a(BOUNDS_ACTIVE_TAG, this.boundsActive);
        tag.func_74774_a(FACING_TAG, (byte)this.facing.ordinal());
    }

    private void updateRenderFacing() {
        EnumFacing newRenderFacing;
        ItemStack scanner = this.getScannerInventory().getStackInSlot(0);
        EnumFacing enumFacing = newRenderFacing = scanner.func_77973_b() == AWStructureItems.STRUCTURE_SCANNER && ItemStructureScanner.readyToExport(scanner) ? EnumFacing.UP : this.facing;
        if (newRenderFacing != this.renderFacing) {
            this.renderFacing = newRenderFacing;
            BlockTools.notifyBlockUpdate(this);
        }
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        this.scannerInventory.deserializeNBT(tag.func_74775_l(SCANNER_INVENTORY_TAG));
        this.boundsActive = tag.func_74767_n(BOUNDS_ACTIVE_TAG);
        this.facing = EnumFacing.field_82609_l[tag.func_74771_c(FACING_TAG)];
        this.updateRenderFacing();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tag = super.func_189515_b(compound);
        tag.func_74782_a(SCANNER_INVENTORY_TAG, (NBTBase)this.scannerInventory.serializeNBT());
        tag.func_74757_a(BOUNDS_ACTIVE_TAG, this.boundsActive);
        tag.func_74774_a(FACING_TAG, (byte)this.facing.ordinal());
        return tag;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.scannerInventory.deserializeNBT(compound.func_74775_l(SCANNER_INVENTORY_TAG));
        this.boundsActive = compound.func_74767_n(BOUNDS_ACTIVE_TAG);
        this.facing = EnumFacing.field_82609_l[compound.func_74771_c(FACING_TAG)];
    }

    public boolean getBoundsActive() {
        return this.boundsActive;
    }

    public void setBoundsActive(boolean boundsActive) {
        this.boundsActive = boundsActive;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        ItemStack scanner = this.scannerInventory.getStackInSlot(0);
        if (scanner.func_77973_b() != AWStructureItems.STRUCTURE_SCANNER) {
            return super.getRenderBoundingBox();
        }
        ItemStructureSettings settings = ItemStructureSettings.getSettingsFor(scanner);
        if (!settings.hasPos1() || !settings.hasPos2()) {
            return super.getRenderBoundingBox();
        }
        return settings.getBoundingBox().func_72314_b(1.0, 0.0, 1.0);
    }

    public EnumFacing getRenderFacing() {
        return this.renderFacing;
    }

    public void restoreTemplate(String name) {
        ItemStack scanner = this.scannerInventory.getStackInSlot(0);
        if (scanner.func_77973_b() != AWStructureItems.STRUCTURE_SCANNER) {
            return;
        }
        StructureTemplateManager.getTemplate(name).ifPresent(template -> {
            ItemStructureSettings settings = ItemStructureSettings.getSettingsFor(scanner);
            if (ItemStructureScanner.readyToExport(scanner)) {
                int turns = (6 - settings.face().func_176736_b()) % 4;
                StructureTemplate dummyTemplate = TemplateScanner.scan(this.field_145850_b, Collections.emptySet(), settings.getMin(), settings.getMax(), settings.buildKey(), turns, "dummy");
                if (this.isSameTemplateSizeAndOffset((StructureTemplate)template, dummyTemplate)) {
                    this.setMainTemplateSettings(name, scanner, (StructureTemplate)template);
                    this.restoreTemplate((StructureTemplate)template, settings.getBoundingBox(), settings.buildKey().func_177967_a(EnumFacing.UP, 1), settings.face());
                    return;
                }
            }
            this.saveToScannerItemAndRestoreTemplate(name, scanner, (StructureTemplate)template, settings);
        });
    }

    private void setMainTemplateSettings(String name, ItemStack scanner, StructureTemplate template) {
        ItemStructureScanner.setStructureName(scanner, name);
        ItemStructureScanner.setValidator(scanner, template.getValidationSettings());
        ItemStructureScanner.setModDependencies(scanner, template.modDependencies);
    }

    private void saveToScannerItemAndRestoreTemplate(String name, ItemStack scanner, StructureTemplate template, ItemStructureSettings settings) {
        EnumFacing placementFacing = this.facing.func_176734_d();
        BlockPos key = this.field_174879_c.func_177967_a(placementFacing, template.getSize().func_177952_p() - template.getOffset().func_177952_p());
        StructureBB bb = new StructureBB(key, placementFacing, template);
        settings.setBuildKey(key.func_177977_b(), placementFacing);
        settings.setName(name);
        settings.setPos1(bb.min);
        settings.setPos2(bb.max);
        this.setMainTemplateSettings(name, scanner, template);
        ItemStructureSettings.setSettingsFor(scanner, settings);
        this.restoreTemplate(template, settings.getBoundingBox(), key, placementFacing);
    }

    private void restoreTemplate(StructureTemplate template, AxisAlignedBB boundingBox, BlockPos buildPos, EnumFacing face) {
        this.clearBoundingBox(boundingBox);
        this.buildTemplate(template, buildPos, face);
        this.clearItemsOnGround(boundingBox);
    }

    private void clearItemsOnGround(AxisAlignedBB boundingBox) {
        this.field_145850_b.func_72872_a(EntityItem.class, boundingBox).forEach(Entity::func_70106_y);
    }

    private void buildTemplate(StructureTemplate template, BlockPos buildPos, EnumFacing face) {
        StructureBuilder builder = new StructureBuilder(this.field_145850_b, template, face, buildPos);
        builder.instantConstruction();
    }

    private void clearBoundingBox(AxisAlignedBB boundingBox) {
        this.clearEntities(boundingBox);
        this.clearBlocks(boundingBox);
    }

    private void clearBlocks(AxisAlignedBB boundingBox) {
        BlockPos.func_191532_a((int)((int)boundingBox.field_72340_a), (int)((int)boundingBox.field_72338_b), (int)((int)boundingBox.field_72339_c), (int)((int)boundingBox.field_72336_d), (int)((int)boundingBox.field_72337_e), (int)((int)boundingBox.field_72334_f)).forEach(arg_0 -> ((World)this.field_145850_b).func_175698_g(arg_0));
    }

    private void clearEntities(AxisAlignedBB boundingBox) {
        AxisAlignedBB expandedBoundingBox = new AxisAlignedBB(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c, boundingBox.field_72336_d + 1.0, boundingBox.field_72337_e + 1.0, boundingBox.field_72334_f + 1.0);
        this.field_145850_b.func_72872_a(Entity.class, expandedBoundingBox).forEach(Entity::func_70106_y);
    }

    private boolean isSameTemplateSizeAndOffset(StructureTemplate template, StructureTemplate dummyTemplate) {
        return this.dimensionsAreSame(template, dummyTemplate) && this.offsetIsSame(template, dummyTemplate);
    }

    private boolean offsetIsSame(StructureTemplate template, StructureTemplate dummyTemplate) {
        return template.getOffset().equals((Object)dummyTemplate.getOffset());
    }

    private boolean dimensionsAreSame(StructureTemplate template, StructureTemplate dummyTemplate) {
        return template.getSize().equals((Object)dummyTemplate.getSize());
    }

    @Override
    public void onBlockBroken(IBlockState state) {
        InventoryTools.dropItemsInWorld(this.field_145850_b, (IItemHandler)this.scannerInventory, this.field_174879_c);
    }

    public void func_145829_t() {
        super.func_145829_t();
        ScannerTracker.registerScanner(this);
    }

    public void export() {
        this.getScanner().ifPresent(scanner -> ItemStructureScanner.scanStructure(this.field_145850_b, scanner));
    }

    void reloadMainSettings() {
        this.getScanner().ifPresent(scanner -> {
            String name = ItemStructureScanner.getStructureName(scanner);
            StructureTemplateManager.getTemplate(name).ifPresent(template -> this.setMainTemplateSettings(name, (ItemStack)scanner, (StructureTemplate)template));
            this.func_70296_d();
        });
    }

    Optional<ItemStack> getScanner() {
        ItemStack scanner = this.scannerInventory.getStackInSlot(0);
        if (scanner.func_77973_b() != AWStructureItems.STRUCTURE_SCANNER) {
            return Optional.empty();
        }
        return Optional.of(scanner);
    }
}

