/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.town;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.shadowmage.ancientwarfare.core.util.CompatUtils;
import net.shadowmage.ancientwarfare.core.util.StringTools;
import net.shadowmage.ancientwarfare.structure.town.TownTemplate;
import org.apache.commons.lang3.math.NumberUtils;

public class TownTemplateParser {
    public static TownTemplate parseTemplate(List<String> lines) {
        String line;
        TownTemplate template = new TownTemplate();
        Iterator<String> it = lines.iterator();
        while (it.hasNext() && (line = it.next()) != null) {
            if ((line = line.toLowerCase(Locale.ENGLISH)).startsWith("header:")) {
                TownTemplateParser.parseHeader(it, template);
                continue;
            }
            if (line.startsWith("walls:")) {
                TownTemplateParser.parseWalls(it, template);
                continue;
            }
            if (line.startsWith("wallpatterns:")) {
                TownTemplateParser.parseWallPatterns(it, template);
                continue;
            }
            if (line.startsWith("uniquestructures:")) {
                TownTemplateParser.parseUniqueStructures(it, template);
                continue;
            }
            if (line.startsWith("mainstructures:")) {
                TownTemplateParser.parseMainStructures(it, template);
                continue;
            }
            if (line.startsWith("housestructures:")) {
                TownTemplateParser.parseHouseStructures(it, template);
                continue;
            }
            if (line.startsWith("cosmeticstructures:")) {
                TownTemplateParser.parseCosmetics(it, template);
                continue;
            }
            if (!line.startsWith("exteriorstructures:")) continue;
            TownTemplateParser.parseExteriorStructures(it, template);
        }
        if (template.isValid()) {
            return template;
        }
        return null;
    }

    private static void parseHeader(Iterator<String> it, TownTemplate template) {
        String lower;
        String line;
        while (it.hasNext() && (line = it.next()) != null && !(lower = line.toLowerCase(Locale.ENGLISH)).startsWith(":endheader")) {
            if (lower.startsWith("name")) {
                template.setTownTypeName(StringTools.safeParseString("=", line));
                continue;
            }
            if (line.startsWith("mods=")) {
                if (CompatUtils.areModsLoaded(StringTools.safeParseString("=", line).split(","))) continue;
                return;
            }
            if (lower.startsWith("minsize")) {
                template.setMinSize(StringTools.safeParseInt("=", line));
                continue;
            }
            if (lower.startsWith("maxsize")) {
                template.setMaxSize(StringTools.safeParseInt("=", line));
                continue;
            }
            if (lower.startsWith("buildingexpansion")) {
                template.setTownBuildingWidthExpansion(StringTools.safeParseInt("=", line));
                continue;
            }
            if (lower.startsWith("selectionweight")) {
                template.setSelectionWeight(StringTools.safeParseInt("=", line));
                continue;
            }
            if (lower.startsWith("clustervalue")) {
                template.setClusterValue(StringTools.safeParseInt("=", line));
                continue;
            }
            if (lower.startsWith("townblocksize")) {
                template.setTownBlockSize(StringTools.safeParseInt("=", line));
                continue;
            }
            if (lower.startsWith("townplotsize")) {
                template.setTownPlotSize(StringTools.safeParseInt("=", line));
                continue;
            }
            if (lower.startsWith("wallstyle")) {
                template.setWallStyle(StringTools.safeParseInt("=", line));
                continue;
            }
            if (lower.startsWith("wallsize")) {
                template.setWallSize(StringTools.safeParseInt("=", line));
                continue;
            }
            if (lower.startsWith("exteriorsize")) {
                template.setExteriorSize(StringTools.safeParseInt("=", line));
                continue;
            }
            if (lower.startsWith("exteriorplotsize")) {
                template.setExteriorPlotSize(StringTools.safeParseInt("=", line));
                continue;
            }
            if (lower.startsWith("interioremptyplotchance")) {
                template.setInteriorEmtpyPlotChance(StringTools.safeParseInt("=", line));
                continue;
            }
            if (lower.startsWith("randomvillagersperchunk")) {
                template.setRandomVillagersPerChunk(StringTools.safeParseFloat("=", line));
                continue;
            }
            if (lower.startsWith("roadblock")) {
                template.setRoadFillBlock(Block.func_149684_b((String)StringTools.safeParseString("=", line)));
                continue;
            }
            if (lower.startsWith("roadmeta")) {
                template.setRoadFillMeta(StringTools.safeParseInt("=", line));
                continue;
            }
            if (lower.startsWith("biomewhitelist")) {
                template.setBiomeWhiteList(StringTools.safeParseBoolean("=", line));
                continue;
            }
            if (lower.startsWith("biomelist")) {
                template.setBiomeList(TownTemplateParser.parseBiomeList(StringTools.safeParseString("=", line)));
                continue;
            }
            if (lower.startsWith("dimensionwhitelist")) {
                template.setDimensionWhiteList(StringTools.safeParseBoolean("=", line));
                continue;
            }
            if (lower.startsWith("dimensionlist")) {
                template.setDimensionList(TownTemplateParser.parseDimensionList(StringTools.safeParseString("=", line)));
                continue;
            }
            if (!lower.startsWith("lamp")) continue;
            template.setLamp(new TownTemplate.TownStructureEntry(StringTools.safeParseString("=", line), 1));
        }
    }

    private static void parseUniqueStructures(Iterator<String> it, TownTemplate template) {
        String line;
        while (it.hasNext() && (line = it.next()) != null && !line.toLowerCase(Locale.ENGLISH).startsWith(":enduniquestructures")) {
            TownTemplate.TownStructureEntry e = TownTemplateParser.parseStructureName(line);
            if (e == null) continue;
            template.getUniqueStructureEntries().add(e);
        }
    }

    private static void parseMainStructures(Iterator<String> it, TownTemplate template) {
        String line;
        while (it.hasNext() && (line = it.next()) != null && !line.toLowerCase(Locale.ENGLISH).startsWith(":endmainstructures")) {
            TownTemplate.TownStructureEntry e = TownTemplateParser.parseStructureName(line);
            if (e == null) continue;
            template.getMainStructureEntries().add(e);
        }
    }

    private static void parseHouseStructures(Iterator<String> it, TownTemplate template) {
        String line;
        while (it.hasNext() && (line = it.next()) != null && !line.toLowerCase(Locale.ENGLISH).startsWith(":endhousestructures")) {
            TownTemplate.TownStructureEntry e = TownTemplateParser.parseStructureWeight(line);
            if (e == null) continue;
            template.getHouseStructureEntries().add(e);
        }
    }

    private static void parseCosmetics(Iterator<String> it, TownTemplate template) {
        String line;
        while (it.hasNext() && (line = it.next()) != null && !line.toLowerCase(Locale.ENGLISH).startsWith(":endcosmeticstructures")) {
            TownTemplate.TownStructureEntry e = TownTemplateParser.parseStructureWeight(line);
            if (e == null) continue;
            template.getCosmeticEntries().add(e);
        }
    }

    private static void parseExteriorStructures(Iterator<String> it, TownTemplate template) {
        String line;
        while (it.hasNext() && (line = it.next()) != null && !line.toLowerCase(Locale.ENGLISH).startsWith(":endexteriorstructures")) {
            TownTemplate.TownStructureEntry e = TownTemplateParser.parseStructureWeight(line);
            if (e == null) continue;
            template.getExteriorStructureEntries().add(e);
        }
    }

    private static void parseWalls(Iterator<String> it, TownTemplate template) {
        String line;
        while (it.hasNext() && (line = it.next()) != null && !line.toLowerCase(Locale.ENGLISH).startsWith(":endwalls")) {
            TownTemplate.TownWallEntry e = TownTemplateParser.parseWall(line);
            if (e == null) continue;
            template.addWall(e);
        }
    }

    private static void parseWallPatterns(Iterator<String> it, TownTemplate template) {
        String line;
        while (it.hasNext() && (line = it.next()) != null && !line.toLowerCase(Locale.ENGLISH).startsWith(":endwallpaterns")) {
            String[] bits = line.split(":", -1);
            int size = NumberUtils.toInt((String)bits[0]);
            int[] pattern = TownTemplateParser.parseWallPattern(bits[1]);
            template.addWallPattern(size, pattern);
        }
    }

    private static List<String> parseBiomeList(String line) {
        String[] bits = line.split(",", -1);
        if (bits == null || bits.length <= 0) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        for (String bit : bits) {
            names.add(bit.toLowerCase(Locale.ENGLISH));
        }
        return names;
    }

    private static List<Integer> parseDimensionList(String line) {
        String[] bits = line.split(",", -1);
        if (bits == null || bits.length <= 0) {
            return Collections.emptyList();
        }
        ArrayList<Integer> dims = new ArrayList<Integer>();
        for (String bit : bits) {
            dims.add(NumberUtils.toInt((String)bit.toLowerCase(Locale.ENGLISH)));
        }
        return dims;
    }

    private static TownTemplate.TownStructureEntry parseStructureName(String line) {
        String[] bits = line.split(":", -1);
        return new TownTemplate.TownStructureEntry(bits[0], 0);
    }

    private static TownTemplate.TownStructureEntry parseStructureWeight(String line) {
        String[] bits = line.split(":", -1);
        return new TownTemplate.TownStructureEntry(bits[0], NumberUtils.toInt((String)bits[1]));
    }

    private static TownTemplate.TownWallEntry parseWall(String line) {
        String[] bits = line.split(":", -1);
        return new TownTemplate.TownWallEntry(bits[0], bits[1], NumberUtils.toInt((String)bits[2]), NumberUtils.toInt((String)bits[3]));
    }

    private static int[] parseWallPattern(String line) {
        String[] bits = line.split("-", -1);
        int[] pattern = new int[bits.length];
        for (int i = 0; i < bits.length; ++i) {
            pattern[i] = NumberUtils.toInt((String)bits[i]);
        }
        return pattern;
    }
}

