/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.util;

import java.util.Locale;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.structure.block.WoodVariant;
import net.shadowmage.ancientwarfare.structure.item.WoodItemBlock;
import net.shadowmage.ancientwarfare.structure.util.BlockStateProperties;

public class WoodVariantHelper {
    private static final String VARIANT_TAG = "variant";

    private WoodVariantHelper() {
    }

    public static void getSubBlocks(Block block, NonNullList<ItemStack> items) {
        for (WoodVariant variant : WoodVariant.values()) {
            ItemStack stack = new ItemStack(block);
            WoodVariantHelper.setStackVariant(variant, stack);
            items.add((Object)stack);
        }
    }

    private static void setStackVariant(WoodVariant variant, ItemStack stack) {
        stack.func_77983_a(VARIANT_TAG, (NBTBase)new NBTTagString(variant.func_176610_l()));
    }

    public static WoodVariant getVariant(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(VARIANT_TAG) ? WoodVariant.byName(stack.func_77978_p().func_74779_i(VARIANT_TAG)) : WoodVariant.OAK;
    }

    public static ItemStack getPickBlock(Block block, IBlockState state) {
        ItemStack stack = new ItemStack(block);
        WoodVariantHelper.setStackVariant((WoodVariant)((Object)state.func_177229_b(BlockStateProperties.VARIANT)), stack);
        return stack;
    }

    public static void getDrops(Block block, NonNullList<ItemStack> drops, IBlockState state) {
        ItemStack drop = new ItemStack(block);
        WoodVariantHelper.setStackVariant((WoodVariant)((Object)state.func_177229_b(BlockStateProperties.VARIANT)), drop);
        drops.add((Object)drop);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerClient(Block block) {
        WoodVariantHelper.registerClient(block, propString -> propString);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerClient(Block block, UnaryOperator<String> updatePropertyString) {
        final ResourceLocation baseLocation = new ResourceLocation("ancientwarfare", "structure/" + block.getRegistryName().func_110623_a());
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMapperBase(){

            @SideOnly(value=Side.CLIENT)
            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation(baseLocation, this.func_178131_a((Map)state.func_177228_b()));
            }
        });
        String modelPropString = (String)updatePropertyString.apply("variant=%s");
        ModelLoader.setCustomMeshDefinition((Item)WoodItemBlock.func_150898_a((Block)block), stack -> {
            if (!stack.func_77942_o()) {
                return new ModelResourceLocation(baseLocation, String.format(modelPropString, WoodVariant.OAK.func_176610_l().toLowerCase(Locale.ENGLISH)));
            }
            WoodVariant variant = WoodVariantHelper.getVariant(stack);
            return new ModelResourceLocation(baseLocation, String.format(modelPropString, variant.func_176610_l().toLowerCase(Locale.ENGLISH)));
        });
        for (WoodVariant variant : WoodVariant.values()) {
            ModelLoader.registerItemVariants((Item)WoodItemBlock.func_150898_a((Block)block), (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(baseLocation, String.format(modelPropString, variant.func_176610_l().toLowerCase(Locale.ENGLISH)))});
        }
    }
}

