/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.entity.types;

import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.shadowmage.ancientwarfare.core.util.Trig;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.entity.materials.VehicleMaterial;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleType;
import net.shadowmage.ancientwarfare.vehicle.helpers.VehicleFiringVarsHelper;
import net.shadowmage.ancientwarfare.vehicle.registry.AmmoRegistry;
import net.shadowmage.ancientwarfare.vehicle.registry.ArmorRegistry;
import net.shadowmage.ancientwarfare.vehicle.registry.UpgradeRegistry;

public class VehicleTypeHwacha
extends VehicleType {
    public VehicleTypeHwacha(int typeNum) {
        super(typeNum);
        this.configName = "hwacha";
        this.vehicleMaterial = VehicleMaterial.materialWood;
        this.materialCount = 4;
        this.width = 1.5f;
        this.height = 1.8f;
        this.maxMissileWeight = 1.0f;
        this.validAmmoTypes.add(AmmoRegistry.ammoRocket);
        this.validAmmoTypes.add(AmmoRegistry.ammoHwachaRocketFlame);
        this.validAmmoTypes.add(AmmoRegistry.ammoHwachaRocketExplosive);
        this.validAmmoTypes.add(AmmoRegistry.ammoHwachaRocketAirburst);
        this.ammoBySoldierRank.put(0, AmmoRegistry.ammoRocket);
        this.ammoBySoldierRank.put(1, AmmoRegistry.ammoRocket);
        this.ammoBySoldierRank.put(2, AmmoRegistry.ammoRocket);
        this.validArmors.add(ArmorRegistry.armorStone);
        this.validArmors.add(ArmorRegistry.armorIron);
        this.validArmors.add(ArmorRegistry.armorObsidian);
        this.validUpgrades.add(UpgradeRegistry.aimUpgrade);
        this.validUpgrades.add(UpgradeRegistry.pitchDownUpgrade);
        this.validUpgrades.add(UpgradeRegistry.pitchUpUpgrade);
        this.validUpgrades.add(UpgradeRegistry.powerUpgrade);
        this.validUpgrades.add(UpgradeRegistry.reloadUpgrade);
        this.validUpgrades.add(UpgradeRegistry.speedUpgrade);
        this.mountable = true;
        this.drivable = true;
        this.riderSits = false;
        this.riderMovesWithTurret = false;
        this.combatEngine = true;
        this.powerAdjustable = true;
        this.pitchAdjustable = false;
        this.yawAdjustable = false;
        this.accuracy = 0.75f;
        this.baseStrafeSpeed = 1.0f;
        this.baseForwardSpeed = 0.175f;
        this.basePitchMax = 39.0f;
        this.basePitchMin = 39.0f;
        this.turretRotationMax = 0.0f;
        this.width = 2.0f;
        this.height = 2.0f;
        this.baseMissileVelocityMax = 42.0f;
        this.turretVerticalOffset = 0.5f;
        this.missileForwardsOffset = -1.0f;
        this.riderForwardsOffset = -1.4f;
        this.riderVerticalOffset = 0.35f;
        this.displayName = "item.vehicleSpawner.12";
        this.displayTooltip.add("item.vehicleSpawner.tooltip.gunpowder");
        this.displayTooltip.add("item.vehicleSpawner.tooltip.mobile");
        this.displayTooltip.add("item.vehicleSpawner.tooltip.noturret");
        this.displayTooltip.add("item.vehicleSpawner.tooltip.barrage");
        this.storageBaySize = 0;
        this.armorBaySize = 3;
        this.ammoBaySize = 6;
        this.upgradeBaySize = 3;
    }

    @Override
    public ResourceLocation getTextureForMaterialLevel(int level) {
        switch (level) {
            case 0: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/hwacha_1.png");
            }
            case 1: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/hwacha_2.png");
            }
            case 2: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/hwacha_3.png");
            }
            case 3: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/hwacha_4.png");
            }
            case 4: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/hwacha_5.png");
            }
        }
        return new ResourceLocation("ancientwarfare", "textures/model/vehicle/hwacha_1.png");
    }

    @Override
    public VehicleFiringVarsHelper getFiringVarsHelper(VehicleBase veh) {
        return new HwachaFiringVarsHelper(veh);
    }

    public class HwachaFiringVarsHelper
    extends VehicleFiringVarsHelper {
        private int missileFired;
        private int delayTick;
        private float missileOffsetX;
        private float missileOffsetY;
        private float missileOffsetZ;

        private HwachaFiringVarsHelper(VehicleBase vehicle) {
            super(vehicle);
            this.missileFired = 0;
            this.delayTick = 0;
        }

        public NBTTagCompound serializeNBT() {
            return new NBTTagCompound();
        }

        public void deserializeNBT(NBTTagCompound tag) {
        }

        @Override
        public void onFiringUpdate() {
            this.vehicle.firingHelper.startLaunching();
        }

        @Override
        public void onReloadUpdate() {
        }

        @Override
        public void onLaunchingUpdate() {
            ++this.delayTick;
            if (this.delayTick >= 5) {
                this.delayTick = 0;
                this.calcMissileOffset(this.missileFired);
                if (!this.vehicle.field_70170_p.field_72995_K && this.vehicle.ammoHelper.getCurrentAmmoCount() > 0) {
                    this.vehicle.func_184185_a(SoundEvents.field_187631_bo, 1.0f, 0.5f);
                }
                this.vehicle.firingHelper.spawnMissile(this.missileOffsetX, this.missileOffsetY, this.missileOffsetZ);
                ++this.missileFired;
                if (this.missileFired >= 36) {
                    this.vehicle.firingHelper.setFinishedLaunching();
                }
            }
        }

        private void calcMissileOffset(int missileNum) {
            int currentRow = missileNum / 9;
            int currentCol = missileNum % 9;
            float targetX = (float)currentCol * 0.0625f * 2.0f;
            float targetY = (float)currentRow * 0.0625f * 2.0f;
            float targetZ = 0.0f;
            float targetAngle = 0.0f + this.vehicle.field_70177_z;
            float len = MathHelper.func_76129_c((float)((targetX -= 0.5f) * targetX + targetZ * targetZ));
            this.missileOffsetX = Trig.cosDegrees(targetAngle) * len;
            if (targetX < 0.0f) {
                this.missileOffsetX *= -1.0f;
            }
            this.missileOffsetZ = -Trig.sinDegrees(targetAngle) * len;
            this.missileOffsetY = Trig.cosDegrees(this.vehicle.localTurretPitch) * targetY;
            this.missileOffsetZ += Trig.sinDegrees(this.vehicle.localTurretPitch) * targetY;
        }

        @Override
        public void onReloadingFinished() {
            this.missileFired = 0;
            this.delayTick = 0;
        }

        @Override
        public float getVar1() {
            return 0.0f;
        }

        @Override
        public float getVar2() {
            return 0.0f;
        }

        @Override
        public float getVar3() {
            return 0.0f;
        }

        @Override
        public float getVar4() {
            return 0.0f;
        }

        @Override
        public float getVar5() {
            return 0.0f;
        }

        @Override
        public float getVar6() {
            return 0.0f;
        }

        @Override
        public float getVar7() {
            return 0.0f;
        }

        @Override
        public float getVar8() {
            return 0.0f;
        }
    }
}

