/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.missiles;

import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.vehicle.missiles.Ammo;
import net.shadowmage.ancientwarfare.vehicle.missiles.DamageType;
import net.shadowmage.ancientwarfare.vehicle.missiles.MissileBase;

public class AmmoIronShot
extends Ammo {
    public AmmoIronShot(int weight, int damage) {
        super("ammo_iron_shot_" + weight + "_" + damage);
        this.ammoWeight = weight;
        this.entityDamage = damage;
        this.vehicleDamage = damage;
        float scaleFactor = (float)weight + 45.0f;
        this.renderScale = (float)weight / scaleFactor * 2.0f;
        this.configName = "iron_shot_" + weight;
        this.modelTexture = new ResourceLocation("ancientwarfare", "textures/model/vehicle/ammo/ammo_stone_shot.png");
    }

    @Override
    public void onImpactWorld(World world, float x, float y, float z, MissileBase missile, RayTraceResult hit) {
        if (world.field_72995_K) {
            return;
        }
        BlockPos origin = new BlockPos((double)x, (double)y, (double)z);
        float maxHardness = 5.0f + (this.ammoWeight * 0.2f + this.ammoWeight * 0.8f * world.field_73012_v.nextFloat());
        this.breakAroundOnLevel(world, origin, origin, maxHardness);
        this.breakAroundOnLevel(world, origin, origin.func_177984_a(), maxHardness);
        this.breakAroundOnLevel(world, origin, origin.func_177977_b(), maxHardness);
    }

    @Override
    public void onImpactEntity(World world, Entity ent, float x, float y, float z, MissileBase missile) {
        if (!world.field_72995_K) {
            ent.func_70097_a(DamageType.causeEntityMissileDamage(missile.shooterLiving, false, false), (float)this.getEntityDamage());
        }
    }
}

