/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.missiles;

import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.vehicle.missiles.Ammo;
import net.shadowmage.ancientwarfare.vehicle.missiles.DamageType;
import net.shadowmage.ancientwarfare.vehicle.missiles.MissileBase;

public class AmmoNapalmShot
extends Ammo {
    public AmmoNapalmShot(int weight) {
        super("ammo_napalm_shot_" + weight);
        this.ammoWeight = weight;
        this.entityDamage = weight;
        this.vehicleDamage = weight;
        float scaleFactor = (float)weight + 45.0f;
        this.renderScale = (float)weight / scaleFactor * 2.0f;
        this.configName = "napalm_shot_" + weight;
        this.modelTexture = new ResourceLocation("ancientwarfare", "textures/model/vehicle/ammo/ammo_stone_shot.png");
        this.isFlaming = true;
    }

    @Override
    public void onImpactWorld(World world, float x, float y, float z, MissileBase missile, RayTraceResult hit) {
        int bx = MathHelper.func_76141_d((float)x);
        int by = MathHelper.func_76141_d((float)y);
        int bz = MathHelper.func_76141_d((float)z);
        this.setBlockToLava(world, bx, by, bz, 5);
        double dx = missile.field_70159_w;
        double dz = missile.field_70179_y;
        if (Math.abs(dx) > Math.abs(dz)) {
            dz = 0.0;
        } else {
            dx = 0.0;
        }
        double d = dx < 0.0 ? -1.0 : (dx = dx > 0.0 ? 1.0 : dx);
        double d2 = dz < 0.0 ? -1.0 : (dz = dz > 0.0 ? 1.0 : dz);
        if (this.ammoWeight >= 15.0f) {
            this.setBlockToLava(world, bx + (int)dx, by, bz + (int)dz, 5);
        }
        if (this.ammoWeight >= 30.0f) {
            this.setBlockToLava(world, bx - (int)dx, by, bz - (int)dz, 5);
        }
        if (this.ammoWeight >= 45.0f) {
            if (dx == 0.0) {
                this.setBlockToLava(world, bx + 1, by, bz, 5);
                this.setBlockToLava(world, bx - 1, by, bz, 5);
            } else {
                this.setBlockToLava(world, bx, by, bz + 1, 5);
                this.setBlockToLava(world, bx, by, bz - 1, 5);
            }
        }
    }

    @Override
    public void onImpactEntity(World world, Entity ent, float x, float y, float z, MissileBase missile) {
        if (!world.field_72995_K) {
            ent.func_70097_a(DamageType.causeEntityMissileDamage(missile.shooterLiving, true, false), (float)this.getEntityDamage());
            ent.func_70015_d(3);
            this.onImpactWorld(world, x, (float)ent.field_70163_u, z, missile, null);
        }
    }
}

