/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.render;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.shadowmage.ancientwarfare.core.util.Trig;
import net.shadowmage.ancientwarfare.vehicle.config.AWVehicleStatics;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleMovementType;
import net.shadowmage.ancientwarfare.vehicle.missiles.IAmmo;
import net.shadowmage.ancientwarfare.vehicle.registry.AmmoRegistry;

public class RenderOverlay
extends Gui {
    private void renderVehicleOverlay() {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fontRenderer = mc.field_71466_p;
        VehicleBase vehicle = (VehicleBase)mc.field_71439_g.func_184187_bx();
        int white = Color.WHITE.getRGB();
        int red = Color.RED.getRGB();
        if (vehicle.vehicleType.getMovementType() == VehicleMovementType.AIR1 || vehicle.vehicleType.getMovementType() == VehicleMovementType.AIR2) {
            this.func_73731_b(fontRenderer, "Throttle: " + vehicle.moveHelper.throttle, 10, 10, white);
            this.func_73731_b(fontRenderer, "Pitch: " + vehicle.field_70125_A, 10, 20, white);
            this.func_73731_b(fontRenderer, "Climb Rate: " + vehicle.field_70181_x * 20.0, 10, 30, white);
            this.func_73731_b(fontRenderer, "Elevation: " + vehicle.field_70163_u, 10, 40, white);
        } else {
            this.func_73731_b(fontRenderer, "Range: " + vehicle.firingHelper.clientHitRange, 10, 10, white);
            this.func_73731_b(fontRenderer, "Pitch: " + vehicle.firingHelper.clientTurretPitch, 10, 20, white);
            this.func_73731_b(fontRenderer, "Yaw: " + vehicle.firingHelper.clientTurretYaw, 10, 30, white);
            this.func_73731_b(fontRenderer, "Velocity: " + vehicle.firingHelper.clientLaunchSpeed, 10, 40, white);
        }
        IAmmo ammo = vehicle.ammoHelper.getCurrentAmmoType();
        if (ammo != null) {
            int count = vehicle.ammoHelper.getCurrentAmmoCount();
            this.func_73731_b(fontRenderer, "Ammo: " + I18n.func_135052_a((String)(AmmoRegistry.getItemForAmmo(ammo).func_77658_a() + ".name"), (Object[])new Object[0]), 10, 50, count > 0 ? white : red);
            this.func_73731_b(fontRenderer, "Count: " + count, 10, 60, count > 0 ? white : red);
        } else {
            this.func_73731_b(fontRenderer, "No Ammo Selected", 10, 50, red);
        }
        if (AWVehicleStatics.renderAdvOverlay) {
            float velocity = Trig.getVelocity(vehicle.field_70159_w, 0.0, vehicle.field_70179_y);
            this.func_73731_b(fontRenderer, "Velocity: " + velocity * 20.0f + "m/s  max: " + vehicle.currentForwardSpeedMax * 20.0f, 10, 70, white);
            this.func_73731_b(fontRenderer, "Yaw Rate: " + vehicle.moveHelper.getRotationSpeed() * 20.0f, 10, 80, white);
        }
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.RenderTickEvent event) {
        if (!AWVehicleStatics.renderOverlay) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.END && mc.field_71462_r == null && mc.field_71439_g != null && mc.field_71439_g.func_184187_bx() instanceof VehicleBase) {
            this.renderVehicleOverlay();
        }
    }
}

