/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.potioncore;

import com.tmtravlr.potioncore.PotionCore;
import com.tmtravlr.potioncore.PotionCoreAttributes;
import com.tmtravlr.potioncore.PotionCoreHelper;
import com.tmtravlr.potioncore.network.CToSMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketHeldItemChange;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PotionCorePlayerController
extends PlayerControllerMP {
    private final Minecraft mc;
    public NetHandlerPlayClient netHandlerVisible;

    public PotionCorePlayerController(Minecraft mcIn, NetHandlerPlayClient netHandler) {
        super(mcIn, netHandler);
        this.mc = mcIn;
        this.netHandlerVisible = netHandler;
    }

    public void func_78764_a(EntityPlayer playerIn, Entity targetEntity) {
        if (!PotionCoreHelper.hasServer) {
            super.func_78764_a(playerIn, targetEntity);
            return;
        }
        this.syncCurrentPlayItem();
        this.attackEntityCustom(playerIn, targetEntity);
        if (this.func_178889_l() != GameType.SPECTATOR) {
            playerIn.func_71059_n(targetEntity);
        }
    }

    public EnumActionResult func_187097_a(EntityPlayer player, Entity target, EnumHand hand) {
        if (!PotionCoreHelper.hasServer) {
            return super.func_187097_a(player, target, hand);
        }
        this.syncCurrentPlayItem();
        this.interactEntityCustom(player, target, hand);
        return this.func_178889_l() == GameType.SPECTATOR ? EnumActionResult.PASS : player.func_190775_a(target, hand);
    }

    public EnumActionResult func_187102_a(EntityPlayer player, Entity target, RayTraceResult raytrace, EnumHand hand) {
        if (!PotionCoreHelper.hasServer) {
            return super.func_187102_a(player, target, raytrace, hand);
        }
        this.syncCurrentPlayItem();
        Vec3d vec3d = new Vec3d(raytrace.field_72307_f.field_72450_a - target.field_70165_t, raytrace.field_72307_f.field_72448_b - target.field_70163_u, raytrace.field_72307_f.field_72449_c - target.field_70161_v);
        this.interactAtEntityCustom(player, target, hand, vec3d);
        if (this.func_178889_l() == GameType.SPECTATOR) {
            return EnumActionResult.PASS;
        }
        EnumActionResult cancelResult = ForgeHooks.onInteractEntityAt((EntityPlayer)player, (Entity)target, (RayTraceResult)raytrace, (EnumHand)hand);
        if (cancelResult != null) {
            return cancelResult;
        }
        return this.func_178889_l() == GameType.SPECTATOR ? EnumActionResult.PASS : target.func_184199_a(player, vec3d, hand);
    }

    public float func_78757_d() {
        return (float)PotionCoreAttributes.getPlayerReachDistance((EntityPlayer)this.mc.field_71439_g);
    }

    private void syncCurrentPlayItem() {
        int i = this.mc.field_71439_g.field_71071_by.field_70461_c;
        if (i != (Integer)ObfuscationReflectionHelper.getPrivateValue(PlayerControllerMP.class, (Object)((Object)this), (String[])new String[]{"currentPlayerItem", "field_78777_l"})) {
            ObfuscationReflectionHelper.setPrivateValue(PlayerControllerMP.class, (Object)((Object)this), (Object)i, (String[])new String[]{"currentPlayerItem", "field_78777_l"});
            this.netHandlerVisible.func_147297_a((Packet)new CPacketHeldItemChange(i));
        }
    }

    private void attackEntityCustom(EntityPlayer player, Entity victim) {
        PacketBuffer out = new PacketBuffer(Unpooled.buffer());
        out.writeInt(2);
        out.writeLong(player.func_110124_au().getMostSignificantBits());
        out.writeLong(player.func_110124_au().getLeastSignificantBits());
        out.writeInt(victim.func_145782_y());
        out.writeInt(3);
        CToSMessage packet = new CToSMessage((ByteBuf)out);
        PotionCore.networkWrapper.sendToServer((IMessage)packet);
    }

    private void interactEntityCustom(EntityPlayer player, Entity target, EnumHand hand) {
        PacketBuffer out = new PacketBuffer(Unpooled.buffer());
        out.writeInt(2);
        out.writeLong(player.func_110124_au().getMostSignificantBits());
        out.writeLong(player.func_110124_au().getLeastSignificantBits());
        out.writeInt(target.func_145782_y());
        out.writeInt(4);
        out.func_179249_a((Enum)hand);
        CToSMessage packet = new CToSMessage((ByteBuf)out);
        PotionCore.networkWrapper.sendToServer((IMessage)packet);
    }

    private void interactAtEntityCustom(EntityPlayer player, Entity target, EnumHand hand, Vec3d position) {
        PacketBuffer out = new PacketBuffer(Unpooled.buffer());
        out.writeInt(2);
        out.writeLong(player.func_110124_au().getMostSignificantBits());
        out.writeLong(player.func_110124_au().getLeastSignificantBits());
        out.writeInt(target.func_145782_y());
        out.writeInt(5);
        out.func_179249_a((Enum)hand);
        out.writeDouble(position.field_72450_a);
        out.writeDouble(position.field_72448_b);
        out.writeDouble(position.field_72449_c);
        CToSMessage packet = new CToSMessage((ByteBuf)out);
        PotionCore.networkWrapper.sendToServer((IMessage)packet);
    }
}

