/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.client;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.CapabilityExtendedHealthSystem;
import ichttt.mods.firstaid.api.damagesystem.AbstractPartHealer;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.client.ClientProxy;
import ichttt.mods.firstaid.client.HUDHandler;
import ichttt.mods.firstaid.client.gui.GuiHealthScreen;
import ichttt.mods.firstaid.client.tutorial.GuiTutorial;
import ichttt.mods.firstaid.client.util.EventCalendar;
import ichttt.mods.firstaid.client.util.PlayerModelRenderer;
import ichttt.mods.firstaid.common.CapProvider;
import ichttt.mods.firstaid.common.apiimpl.FirstAidRegistryImpl;
import ichttt.mods.firstaid.common.apiimpl.RegistryManager;
import ichttt.mods.firstaid.common.config.ConfigEntry;
import ichttt.mods.firstaid.common.config.ExtraConfig;
import ichttt.mods.firstaid.common.items.FirstAidItems;
import ichttt.mods.firstaid.common.util.ArmorUtils;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientEventHandler {
    private static final DecimalFormat FORMAT = new DecimalFormat("#.##");
    private static int id;

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)FirstAidItems.BANDAGE, (int)0, (ModelResourceLocation)new ModelResourceLocation("firstaid:bandage"));
        ModelLoader.setCustomModelResourceLocation((Item)FirstAidItems.PLASTER, (int)0, (ModelResourceLocation)new ModelResourceLocation("firstaid:plaster"));
        ModelLoader.setCustomModelResourceLocation((Item)FirstAidItems.MORPHINE, (int)0, (ModelResourceLocation)new ModelResourceLocation("firstaid:morphine"));
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null || mc.field_71439_g.field_71174_a == null || mc.func_147113_T()) {
            return;
        }
        if (EventCalendar.isGuiFun()) {
            GuiHealthScreen.BED_ITEMSTACK.func_77964_b(id);
            if (mc.field_71441_e != null && mc.field_71441_e.func_72820_D() % 3L == 0L) {
                ++id;
            }
            if (id > 15) {
                id = 0;
            }
            PlayerModelRenderer.tickFun();
        }
        if (!RegistryManager.debuffConfigErrors.isEmpty() && mc.field_71441_e.field_72995_K) {
            mc.field_71439_g.func_146105_b((ITextComponent)new TextComponentString("[FirstAid] FirstAid has detected invalid debuff config entries."), false);
            for (String s : RegistryManager.debuffConfigErrors) {
                mc.field_71439_g.func_146105_b((ITextComponent)new TextComponentString("[FirstAid] " + s), false);
            }
            RegistryManager.debuffConfigErrors.clear();
        }
        if (HUDHandler.INSTANCE.ticker > 0) {
            --HUDHandler.INSTANCE.ticker;
        }
    }

    @SubscribeEvent
    public static void onKeyPress(InputEvent.KeyInputEvent event) {
        if (ClientProxy.showWounds.func_151468_f()) {
            Minecraft mc = Minecraft.func_71410_x();
            AbstractPlayerDamageModel damageModel = (AbstractPlayerDamageModel)Objects.requireNonNull(mc.field_71439_g.getCapability(CapabilityExtendedHealthSystem.INSTANCE, null));
            if (!damageModel.hasTutorial) {
                damageModel.hasTutorial = true;
                CapProvider.tutorialDone.add(mc.field_71439_g.func_70005_c_());
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiTutorial());
            } else {
                mc.func_147108_a((GuiScreen)new GuiHealthScreen(damageModel));
            }
        }
    }

    @SubscribeEvent
    public static void preRender(RenderGameOverlayEvent.Pre event) {
        RenderGameOverlayEvent.ElementType type = event.getType();
        if (type == RenderGameOverlayEvent.ElementType.HEALTH && !FirstAidConfig.overlay.showVanillaHealthBar) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderOverlay(RenderGameOverlayEvent.Post event) {
        RenderGameOverlayEvent.ElementType type = event.getType();
        if (type == RenderGameOverlayEvent.ElementType.ALL || type == RenderGameOverlayEvent.ElementType.TEXT && FirstAidConfig.overlay.overlayMode != FirstAidConfig.Overlay.OverlayMode.OFF && FirstAidConfig.overlay.pos == FirstAidConfig.Overlay.Position.BOTTOM_LEFT) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.field_71424_I.func_76320_a("FirstAidOverlay");
            GuiIngameForge.renderHealth = FirstAidConfig.overlay.showVanillaHealthBar;
            HUDHandler.INSTANCE.renderOverlay(event.getResolution(), event.getPartialTicks());
            mc.field_71424_I.func_76319_b();
            mc.field_71424_I.func_76319_b();
        }
    }

    private static String makeArmorMsg(double value) {
        return TextFormatting.BLUE + I18n.func_135052_a((String)"firstaid.specificarmor", (Object[])new Object[]{FORMAT.format(value)}) + TextFormatting.RESET;
    }

    private static String makeToughnessMsg(double value) {
        return TextFormatting.BLUE + I18n.func_135052_a((String)"firstaid.specifictoughness", (Object[])new Object[]{FORMAT.format(value)}) + TextFormatting.RESET;
    }

    private static <T> void replaceOrAppend(List<T> list, T search, T replace) {
        int index = list.indexOf(search);
        if (FirstAidConfig.overlay.armorTooltipMode == FirstAidConfig.Overlay.TooltipMode.REPLACE && index >= 0) {
            list.set(index, replace);
        } else {
            list.add(replace);
        }
    }

    @SubscribeEvent
    public static void tooltipItems(ItemTooltipEvent event) {
        AbstractPartHealer healer;
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (item == FirstAidItems.MORPHINE) {
            event.getToolTip().add(I18n.func_135052_a((String)"firstaid.tooltip.morphine", (Object[])new Object[]{"3:30-4:30"}));
            return;
        }
        if (FirstAidConfig.overlay.armorTooltipMode != FirstAidConfig.Overlay.TooltipMode.NONE) {
            String original;
            double totalArmor;
            ISpecialArmor armor;
            boolean set = false;
            if (item instanceof ISpecialArmor) {
                armor = (ISpecialArmor)item;
                EntityPlayer player = event.getEntityPlayer();
                if (player != null) {
                    int displayArmor;
                    int slot = player.field_71071_by.field_70460_b.indexOf((Object)stack);
                    if (slot == -1 && item instanceof ItemArmor) {
                        slot = ((ItemArmor)item).field_77881_a.func_188454_b();
                    }
                    if (slot >= 0 && slot <= 3 && (displayArmor = armor.getArmorDisplay(event.getEntityPlayer(), stack, slot)) != 0) {
                        set = true;
                        totalArmor = ArmorUtils.applyArmorModifier(CommonUtils.ARMOR_SLOTS[slot], displayArmor);
                        original = TextFormatting.BLUE + " " + net.minecraft.util.text.translation.I18n.func_74837_a((String)"attribute.modifier.plus.0", (Object[])new Object[]{FORMAT.format(displayArmor), net.minecraft.util.text.translation.I18n.func_74838_a((String)"attribute.name.generic.armor")});
                        ClientEventHandler.replaceOrAppend(event.getToolTip(), original, ClientEventHandler.makeArmorMsg(totalArmor));
                    }
                }
            }
            if (item instanceof ItemArmor && !set) {
                double normalToughness;
                double totalToughness;
                armor = (ItemArmor)item;
                List tooltip = event.getToolTip();
                double normalArmor = ArmorUtils.getArmor(stack, armor.func_185083_B_());
                totalArmor = ArmorUtils.applyArmorModifier(armor.field_77881_a, normalArmor);
                if (totalArmor > 0.0) {
                    original = TextFormatting.BLUE + " " + net.minecraft.util.text.translation.I18n.func_74837_a((String)"attribute.modifier.plus.0", (Object[])new Object[]{FORMAT.format(normalArmor), net.minecraft.util.text.translation.I18n.func_74838_a((String)"attribute.name.generic.armor")});
                    ClientEventHandler.replaceOrAppend(tooltip, original, ClientEventHandler.makeArmorMsg(totalArmor));
                }
                if ((totalToughness = ArmorUtils.applyToughnessModifier(armor.field_77881_a, normalToughness = ArmorUtils.getArmorThoughness(stack, armor.func_185083_B_()))) > 0.0) {
                    String original2 = TextFormatting.BLUE + " " + net.minecraft.util.text.translation.I18n.func_74837_a((String)"attribute.modifier.plus.0", (Object[])new Object[]{FORMAT.format(normalToughness), net.minecraft.util.text.translation.I18n.func_74838_a((String)"attribute.name.generic.armorToughness")});
                    ClientEventHandler.replaceOrAppend(tooltip, original2, ClientEventHandler.makeToughnessMsg(totalToughness));
                }
            }
        }
        if ((healer = FirstAidRegistryImpl.INSTANCE.getPartHealer(stack)) != null) {
            event.getToolTip().add(I18n.func_135052_a((String)"firstaid.tooltip.healer", (Object[])new Object[]{healer.maxHeal / 2, StringUtils.func_76337_a((int)healer.ticksPerHeal)}));
        }
    }

    @SubscribeEvent
    public static void onDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        FirstAid.isSynced = false;
        for (ConfigEntry<ExtraConfig.Sync> option : FirstAid.syncedConfigOptions) {
            if (!option.hasRemoteData()) continue;
            option.revert();
        }
        HUDHandler.INSTANCE.ticker = -1;
    }
}

