/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.spawnercontrol.config;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import ladysnake.spawnercontrol.config.CustomSpawnersConfig;
import ladysnake.spawnercontrol.config.SpawnerConfig;
import ladysnake.spawnercontrol.config.SpawnerConfigHolder;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="spawnercontrol", name="spawnercontrol/spawnercontrol")
@Mod.EventBusSubscriber(modid="spawnercontrol")
public class MSCConfig {
    @Config.Ignore
    public static final String MAIN_CONFIG_FILE = "spawnercontrol/spawnercontrol";
    @Config.Ignore
    public static final String VANILLA_CONFIG_CATEGORY = "general.vanillaSpawnerConfig";
    @Config.RequiresWorldRestart
    @Config.Comment(value={"If set to false, vanilla spawners won't be affected by the mod. This mod's own spawners will be the only ones affected by this config"})
    public static boolean alterVanillaSpawner = true;
    @Config.Comment(value={"The spawner configuration for vanilla or vanilla-derived spawners"})
    public static SpawnerConfig vanillaSpawnerConfig = new SpawnerConfig();
    @Config.RequiresMcRestart
    @Config.RequiresWorldRestart
    @Config.Comment(value={"A list of ids used to generate custom spawner objects", "Each custom spawner uses a separate configuration file, accessible in the 'custom spawners config' category"})
    public static String[] customSpawners = new String[0];
    @Config.RequiresMcRestart
    @Config.Comment(value={"If set to true, the mod will generate its own creative tab to put custom spawners in"})
    public static boolean makeCreativeTab = false;

    public static void portConfig() {
        File oldConfigFile = new File(CustomSpawnersConfig.configDir, "spawnercontrol.cfg");
        if (!oldConfigFile.exists()) {
            return;
        }
        Configuration oldConfig = new Configuration(oldConfigFile, "1.0");
        Configuration newConfig = CustomSpawnersConfig.getMainConfiguration();
        if (oldConfig.getLoadedConfigVersion() == null) {
            ConfigCategory general = oldConfig.getCategory("general");
            ConfigCategory vanillaSpawner = newConfig.getCategory(VANILLA_CONFIG_CATEGORY);
            MSCConfig.copyConfigCategory(general, vanillaSpawner);
            if (general.getChildren().size() > 0) {
                ConfigCategory oldSpawnConditions = (ConfigCategory)general.getChildren().iterator().next();
                vanillaSpawner.getChildren().stream().filter(child -> child.getName().equals(oldSpawnConditions.getName())).findAny().ifPresent(spawnConditions -> MSCConfig.copyConfigCategory(oldSpawnConditions, spawnConditions));
            }
            newConfig.save();
            try {
                Files.move((File)oldConfigFile, (File)new File(CustomSpawnersConfig.configDir, "spawnercontrol_old.cfg"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void copyConfigCategory(ConfigCategory oldConf, ConfigCategory newConf) {
        for (Map.Entry entry : newConf.getValues().entrySet()) {
            if (!oldConf.containsKey((String)entry.getKey())) continue;
            newConf.put((String)entry.getKey(), oldConf.get((String)entry.getKey()));
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("spawnercontrol")) {
            ConfigManager.sync((String)"spawnercontrol", (Config.Type)Config.Type.INSTANCE);
            CustomSpawnersConfig.getCustomSpawnerConfigs().forEach(SpawnerConfigHolder::sync);
        }
    }
}

