/*
 * Decompiled with CFR 0.152.
 */
package scavenge.api.utils;

import com.google.common.base.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BlockEntry {
    Block block;
    int meta;

    public BlockEntry(IBlockState state) {
        this(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
    }

    public BlockEntry(Block block, int meta) {
        this.block = block;
        this.meta = meta;
    }

    public boolean matches(IBlockState state) {
        if (this.block != state.func_177230_c()) {
            return false;
        }
        if (this.meta == Short.MAX_VALUE) {
            return true;
        }
        return this.meta == this.block.func_176201_c(state);
    }

    public Block getBlock() {
        return this.block;
    }

    public int getMeta() {
        return this.meta;
    }

    public boolean hasItemBlock() {
        return Item.func_150898_a((Block)this.block) != Items.field_190931_a;
    }

    public ItemStack toStack() {
        return new ItemStack(this.block, 1, this.meta);
    }

    public String getName() {
        return this.hasItemBlock() ? this.toStack().func_82833_r() : this.block.func_149732_F();
    }

    public boolean isBlank() {
        return this.meta == Short.MAX_VALUE;
    }

    public IBlockState getBlockState() {
        if (this.isBlank()) {
            return this.block.func_176223_P();
        }
        return this.block.func_176203_a(this.meta);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.block, this.meta});
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlockEntry) {
            BlockEntry other = (BlockEntry)obj;
            return other.block == this.block && other.meta == this.meta;
        }
        return false;
    }
}

