/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.loaders;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.List;
import net.minecraftforge.fml.common.FMLLog;
import scavenge.api.IScavengeFactory;
import scavenge.api.ScavengeAPI;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.loot.ILootFactory;
import scavenge.api.loot.ILootProperty;
import scavenge.core.loaders.IncompatLoader;

public class DocumentationExporter {
    public void export(ScavengeAPI api, File file, IncompatLoader loader, boolean printCurse) {
        try {
            this.writeBlockData(new File(file, "IResourceProperty.txt"), api.getResourceFactory(), loader, printCurse);
            this.writeLootData(new File(file, "ILootProperty.txt"), api.getLootFactories(), loader, printCurse);
            this.writeData(new File(file, "IMathOperation.txt"), api.getMathRegistry().getOperations(), loader, printCurse);
            this.writeData(new File(file, "IMathModifier.txt"), api.getMathRegistry().getModifiers(), loader, printCurse);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeBlockData(File file, List<IResourceFactory> loot, IncompatLoader loader, boolean printCurse) throws Exception {
        if (loot.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Loaded " + loot.size() + " Block Properties [");
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        for (IResourceFactory factory : loot) {
            MapElement el = factory.getDocumentation();
            if (el == null) continue;
            builder.append(factory.getID() + ", ");
            if (printCurse) {
                writer.write("<li>");
                el.setDocumentationState(true);
                writer.write("<strong>" + factory.getID() + "</strong>:");
                writer.write("<br />");
                writer.newLine();
                el.writeToBuffer(writer, false, -1, printCurse);
                writer.write("<strong>Incompatible With</strong>: " + loader.getIncompat(IResourceProperty.class, factory.getID()));
                writer.write("<br />");
                writer.newLine();
                writer.write("<strong>Type: " + factory.getType().getDisplayName() + "</strong>");
                writer.write("<br />");
                writer.newLine();
                writer.write("<br />");
                writer.newLine();
                writer.write("</li>");
                continue;
            }
            el.setDocumentationState(true);
            writer.write("- " + factory.getID() + ":");
            writer.newLine();
            el.writeToBuffer(writer, false, -1, printCurse);
            writer.write("Incompatible With: " + loader.getIncompat(IResourceProperty.class, factory.getID()));
            writer.newLine();
            writer.write("Type: " + factory.getType().getDisplayName());
            writer.newLine();
            writer.newLine();
        }
        builder.setCharAt(builder.length() - 2, ']');
        FMLLog.getLogger().info(builder.toString());
        writer.close();
    }

    public void writeLootData(File file, List<ILootFactory> loot, IncompatLoader loader, boolean printCurse) throws Exception {
        if (loot.isEmpty()) {
            return;
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        for (ILootFactory factory : loot) {
            MapElement el = factory.getDocumentation();
            if (el == null) continue;
            if (printCurse) {
                el.setDocumentationState(true);
                writer.write("<li>");
                writer.write("<strong>" + factory.getID() + "</strong>:");
                writer.write("<br />");
                writer.newLine();
                el.writeToBuffer(writer, false, -1, printCurse);
                writer.write("<strong>Incompatible With</strong>: " + loader.getIncompat(ILootProperty.class, factory.getID()));
                writer.write("<br />");
                writer.newLine();
                writer.write("<strong>Type</strong>: " + (factory.isActiveProperty() ? "Active" : "Passive"));
                writer.write("<br />");
                writer.newLine();
                writer.write("<br />");
                writer.newLine();
                writer.write("</li>");
                continue;
            }
            el.setDocumentationState(true);
            writer.write("- " + factory.getID() + ":");
            writer.newLine();
            el.writeToBuffer(writer, false, -1, printCurse);
            writer.write("Incompatible With: " + loader.getIncompat(ILootProperty.class, factory.getID()));
            writer.newLine();
            writer.write("Type: " + (factory.isActiveProperty() ? "Active" : "Passive"));
            writer.newLine();
            writer.newLine();
        }
        writer.newLine();
        writer.close();
    }

    public void writeData(File file, List<? extends IScavengeFactory> list, IncompatLoader loader, boolean printCurse) throws Exception {
        if (list.isEmpty()) {
            return;
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        for (IScavengeFactory iScavengeFactory : list) {
            MapElement el = iScavengeFactory.getDocumentation();
            if (el == null) continue;
            if (printCurse) {
                el.setDocumentationState(true);
                writer.write("<li>");
                writer.write("<strong>" + iScavengeFactory.getID() + "</strong>:");
                writer.write("<br />");
                writer.newLine();
                el.writeToBuffer(writer, false, -1, printCurse);
                writer.write("<br />");
                writer.newLine();
                writer.write("</li>");
                continue;
            }
            el.setDocumentationState(true);
            writer.write("- " + iScavengeFactory.getID() + ":");
            writer.newLine();
            el.writeToBuffer(writer, false, -1, printCurse);
            writer.newLine();
        }
        writer.close();
    }
}

