/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.loaders;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import scavenge.api.ScavengeAPI;

public class NBTLoader {
    List<String> errors = new ArrayList<String>();

    public void loadNBTFiles(File file) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            int index = -1;
            while (true) {
                int firstNBT;
                ++index;
                String data = reader.readLine();
                if (data == null) break;
                if (data.startsWith("//") || data.isEmpty()) continue;
                if (!data.contains("=")) {
                    this.errors.add("Line [" + index + "] is not valid. It is missing a = for registry");
                    continue;
                }
                int firstIndex = data.indexOf("=");
                if (firstIndex > (firstNBT = data.indexOf("{"))) {
                    this.errors.add("Line [" + index + "] the NBTCompound Indicator is infront of the ID=NBT '=' symbol. There has to be a '=' between the ID and NBTData");
                    continue;
                }
                String key = data.substring(0, firstIndex);
                if (key.contains(" ")) {
                    this.errors.add("Line [" + index + "] NBTKeys are not allowed to have Spaces!");
                    continue;
                }
                if (ScavengeAPI.INSTANCE.hasCompound(key)) {
                    this.errors.add("Line [" + index + "] uses a duplicated NBT Key so it will not be loaded!");
                    continue;
                }
                try {
                    NBTTagCompound nbt = JsonToNBT.func_180713_a((String)data.substring(firstIndex + 1));
                    ScavengeAPI.INSTANCE.storeNBT(key, nbt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.errors.add("Line [" + index + "] had an Error when creating the NBTData " + e.getMessage());
                }
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public List<String> getErrors() {
        ArrayList<String> list = new ArrayList<String>(this.errors);
        this.errors.clear();
        return list;
    }
}

