/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.loot;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import scavenge.api.loot.ILootProperty;
import scavenge.api.utils.LootUtil;
import scavenge.core.loot.ILoot;

public class BasicLoot
implements ILoot {
    List<ILootProperty> properties = new ArrayList<ILootProperty>();
    ItemStack stack;
    boolean weight;
    float value;
    int maxRolls;
    boolean shouldShow;

    public BasicLoot(ItemStack item, boolean isWeight, float theValue, int rolls, List<ILootProperty> loot, boolean shouldShow) {
        this.stack = item;
        this.weight = isWeight;
        this.value = theValue;
        this.maxRolls = rolls;
        this.properties.addAll(loot);
        this.shouldShow = shouldShow;
    }

    @Override
    public List<ItemStack> getDrops(Random rand, NBTTagCompound nbt) {
        ItemStack copy = this.stack.func_77946_l();
        for (ILootProperty prop : this.properties) {
            copy = prop.applyActiveEffect(copy, nbt);
            if (!LootUtil.isStackEmpty(copy)) continue;
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int count = LootUtil.getStackSize(copy);
        while (count > 0) {
            list.add(copy.func_77979_a(Math.min(count, copy.func_77976_d())));
            count = LootUtil.getStackSize(copy);
        }
        return list;
    }

    @Override
    public boolean usesWeight() {
        return this.weight;
    }

    @Override
    public int getWeight() {
        return (int)this.value;
    }

    @Override
    public float getChance() {
        return this.value;
    }

    @Override
    public int getMaxRools() {
        return this.maxRolls;
    }

    @Override
    public boolean shouldShow() {
        return this.shouldShow;
    }

    @Override
    public List<ItemStack> generateAllDrops() {
        ArrayList<ILootProperty> multiDropOnes = new ArrayList<ILootProperty>();
        ItemStack base = this.stack.func_77946_l();
        for (ILootProperty entry : this.properties) {
            if (entry.hasMultiResults()) {
                multiDropOnes.add(entry);
                continue;
            }
            base = entry.applyInfoEffect(base);
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        result.add(base);
        for (ILootProperty prop : multiDropOnes) {
            ArrayList<ItemStack> newList = new ArrayList<ItemStack>(result);
            result.clear();
            for (ItemStack entry : newList) {
                result.addAll(prop.applyMultiInfoEffect(entry.func_77946_l()));
            }
        }
        return result;
    }
}

