/*
 * Decompiled with CFR 0.152.
 */
package scavenge.loot.effects;

import com.google.gson.JsonObject;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.loot.ILootProperty;
import scavenge.api.loot.impl.BaseLootFactory;
import scavenge.api.loot.impl.BasePassiveLootProperty;
import scavenge.api.utils.JsonUtil;

public class PropAddEnchantment
extends BasePassiveLootProperty {
    EnchantmentData data;

    public PropAddEnchantment(JsonObject obj) {
        super("add_enchantment");
        Enchantment ench = (Enchantment)Enchantment.field_185264_b.func_82594_a((Object)new ResourceLocation(obj.get("name").getAsString()));
        if (ench == null) {
            throw new RuntimeException("Null Enchantment is not allowed");
        }
        this.data = new EnchantmentData(ench, JsonUtil.getOrDefault(obj, "meta", 1));
    }

    @Override
    public ItemStack applyPassiveEffect(ItemStack stack) {
        stack.func_77966_a(this.data.field_76302_b, this.data.field_76303_c);
        return stack;
    }

    @Override
    public ItemStack applyInfoEffect(ItemStack stack) {
        stack.func_77966_a(this.data.field_76302_b, this.data.field_76303_c);
        return stack;
    }

    public static class AddEnchantmentFactory
    extends BaseLootFactory {
        public AddEnchantmentFactory() {
            super("add_enchantment", false);
        }

        @Override
        public ILootProperty createObject(JsonObject obj) {
            return new PropAddEnchantment(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = new MapElement("");
            map.setDescription("Adds an Enchantment to the loot");
            map.addElement(new TextElement("name", "").setDescription("The Enchantment name of the Enchantment that should be addeed"));
            map.addElement(new IntElement("level", 0).setDescription("The Level of the Enchantment"));
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("name", "minecraft:unbreaking");
            obj.addProperty("name", (Number)2);
        }
    }
}

