/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockEffects;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.DoubleElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.OptionalArrayElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;

public class PropAddPotion
extends BaseResourceProperty
implements IResourceEffect {
    List<PotionEffect> effects = new ArrayList<PotionEffect>();
    double chance;

    public PropAddPotion(JsonObject obj) {
        super(obj, "add_Potions");
        this.chance = JsonUtil.getOrDefault(obj, "chance", 100.0);
        JsonUtil.convertToObject(obj.get("potions"), new Consumer<JsonObject>(){

            @Override
            public void accept(JsonObject t) {
                PotionEffect effect = JsonUtil.createPotionEffect(t);
                if (effect == null) {
                    FMLLog.getLogger().info("Potion From Object [" + t + "] is null that is not allowed");
                    return;
                }
                PropAddPotion.this.effects.add(effect);
            }
        });
    }

    @Override
    public void addJEIData(IResourceProperty.IJEIBlockHandler collector) {
        collector.addExtraLayer("Adds Potions");
        collector.addInfo("Adds These Potion Effects with a [" + this.chance + "%] to the Player");
        for (PotionEffect effect : this.effects) {
            StringBuilder builder = new StringBuilder();
            builder.append(I18n.func_74838_a((String)effect.func_76453_d()));
            if (effect.func_76458_c() > 0) {
                builder.append(" [Level: ");
                builder.append(effect.func_76458_c());
                builder.append("]");
            }
            builder.append(" (Duration: ");
            builder.append(effect.func_76459_b());
            builder.append(" Ticks]");
            collector.addInfo(builder.toString());
        }
        collector.finishLayer();
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        if (this.chance >= world.field_73012_v.nextDouble() * 100.0) {
            for (PotionEffect potion : this.effects) {
                player.func_70690_d(new PotionEffect(potion));
            }
            return true;
        }
        return false;
    }

    public static class AddPotionFactory
    extends BaseResourceFactory {
        public AddPotionFactory() {
            super("add_Potions", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropAddPotion(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("chance", (Number)100.0);
            JsonArray array = new JsonArray();
            obj.add("potions", (JsonElement)array);
            JsonObject object = new JsonObject();
            array.add((JsonElement)object);
            object.addProperty("name", "minecraft:speed");
            object.addProperty("duration", (Number)1000);
            object.addProperty("amplifier", (Number)1);
            object.addProperty("particals", Boolean.valueOf(false));
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to apply a Potion Effect to a Player");
            map.addElement(new DoubleElement("chance", 100.0, "how likely it is that these Potions get applied"));
            MapElement potion = new MapElement("");
            potion.addElement(new TextElement("name", "").setDescription("Potion Registry name of the Potion that you want to apply"));
            potion.addElement(new IntElement("duration", 0).setDescription("The Duration of the Potion Effect in game ticks"));
            potion.addElement(new IntElement("amplifier", 0, "How Strong the Potion should be"));
            potion.addElement(new BooleanElement("particals", true, "If the Potion Effect should show Particals"));
            map.addElement(new OptionalArrayElement("potions", potion).setDescription("The Potion Effects that should be applied"));
            return map;
        }
    }
}

