/*
 * Decompiled with CFR 0.152.
 */
package scavenge.score.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.ChoiceElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.math.IMathOperation;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;
import scavenge.core.math.operation.BiggerOperation;
import scavenge.core.math.operation.SmallerOperation;

public class PropHasStat
extends BaseResourceProperty
implements IResourceCondition {
    StatBase base;
    IMathOperation operation;

    public PropHasStat(JsonObject obj) {
        super(obj, "require_stat");
        this.base = StatList.func_151177_a((String)obj.get("name").getAsString());
        if (this.base == null) {
            throw new RuntimeException("Stat [" + obj.get("name").getAsString() + "] is null that is not allowed");
        }
        if (obj.has("operations")) {
            this.operation = JsonUtil.getMathOperation("operations", obj);
            this.setJEIInfo(JsonUtil.getOrDefault(obj, "jeiDesc", ""));
        } else {
            int value = JsonUtil.getOrDefault(obj, "amount", 0);
            if (JsonUtil.getOrDefault(obj, "bigger", true)) {
                this.operation = new BiggerOperation(value);
                this.setJEIInfo("Player has to have " + value + " Points for [" + this.base.func_150951_e().func_150254_d() + "] Stat");
            } else {
                this.operation = new SmallerOperation(value);
                this.setJEIInfo("Player has to be bewlo " + value + " Points for [" + this.base.func_150951_e().func_150254_d() + "] Stat");
            }
        }
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        StatisticsManager manager = this.getStats(player);
        return this.operation.matches(manager == null ? 0L : (long)manager.func_77444_a(this.base));
    }

    public static class HasStatFactory
    extends BaseResourceFactory {
        public HasStatFactory() {
            super("require_stat", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.PARTCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropHasStat(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("name", "stat.animalsBred");
            obj.addProperty("bigger", Boolean.valueOf(true));
            obj.addProperty("value", (Number)100);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new TextElement("name", "").setDescription("The StatID that should be compared with"));
            ChoiceElement choice = new ChoiceElement("", 2);
            choice.addElement(0, new BooleanElement("bigger", true, "If the Stat should be bigger or smaller then the requested value"));
            choice.addElement(0, new IntElement("value", 0, "how big or small the score should be"));
            this.addDefaultOperationText(choice, 1);
            map.addElement(choice);
            map.setDescription("Allows to check the if the player has a certain Stat");
            return map;
        }
    }
}

