/*
 * Decompiled with CFR 0.152.
 */
package scavenge.utils.blockEffects;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;

public class PropIfElseEffect
extends BaseResourceProperty
implements IResourceEffect {
    IResourceCondition condition;
    IResourceEffect trueEffect;
    IResourceEffect falseEffect;

    public PropIfElseEffect(JsonObject obj) {
        super(obj, "if_else_effect");
        this.condition = this.createCondition(obj.getAsJsonObject("check"));
        this.trueEffect = this.createEffect(obj.getAsJsonObject("true_effect"));
        this.falseEffect = this.createEffect(obj.getAsJsonObject("false_effect"));
    }

    @Override
    public void addJEIData(IResourceProperty.IJEIBlockHandler collector) {
        collector.addExtraLayer("Condition Effect");
        collector.addInfo("If Condition is true: ");
        this.condition.addJEIData(collector);
        collector.addInfo("Then This Effect is applied:");
        this.trueEffect.addJEIData(collector);
        collector.addExtraLayer("Else this Effect is applied:");
        this.falseEffect.addJEIData(collector);
        collector.finishLayer();
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        if (this.condition.canInteract(state, world, pos, player, left, side, resourceID, false)) {
            return this.trueEffect.applyEffects(state, world, pos, player, left, side, resourceID, container);
        }
        return this.falseEffect.applyEffects(state, world, pos, player, left, side, resourceID, container);
    }

    public static class IfElseEffectFactory
    extends BaseResourceFactory {
        public IfElseEffectFactory() {
            super("if_else_effect", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropIfElseEffect(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonObject data = new JsonObject();
            data.addProperty("type", "condtionID");
            obj.add("check", (JsonElement)data);
            obj.add("true_effect", (JsonElement)data);
            obj.add("false_effect", (JsonElement)data);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new MapElement("check").setDescription("The Condition that decides which effect should be applied"));
            map.addElement(new MapElement("trueValue").setDescription("The Effect that is applied when the condition is true"));
            map.addElement(new MapElement("falseValue").setDescription("The Effect that is applied when the condition is false"));
            map.setDescription("Allows to apply a effect based of if a condition is true or false");
            return map;
        }
    }
}

