/*
 * Decompiled with CFR 0.152.
 */
package scavenge.world.blockConditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.ArrayElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;

public class PropSideClicked
extends BaseResourceProperty
implements IResourceCondition {
    Set<EnumFacing> sides = EnumSet.noneOf(EnumFacing.class);

    public PropSideClicked(JsonObject obj) {
        super(obj, "require_side");
        this.addSelfIncompat();
        JsonUtil.convertToPrimitive(obj.get("sides"), new Consumer<JsonPrimitive>(){

            @Override
            public void accept(JsonPrimitive t) {
                EnumFacing side = EnumFacing.func_176739_a((String)t.getAsString());
                if (side == null) {
                    return;
                }
                PropSideClicked.this.sides.add(side);
            }
        });
        this.setJEIInfo("Block has to be clicked on these sides :" + this.sides);
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return this.sides.contains(side);
    }

    public static class SideClickedFactory
    extends BaseResourceFactory {
        public SideClickedFactory() {
            super("require_side", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.INCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropSideClicked(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonArray array = new JsonArray();
            obj.add("sides", (JsonElement)array);
            array.add((JsonElement)new JsonPrimitive("north"));
            array.add((JsonElement)new JsonPrimitive("east"));
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to check which side the Player is clicking on");
            map.addElement(new ArrayElement("sides", new TextElement("", "")).setDescription("Which sides can be clicked on"));
            return map;
        }
    }
}

