/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2;

import com.someguyssoftware.dungeons2.block.DungeonsBlocks;
import com.someguyssoftware.dungeons2.command.BuildCommand;
import com.someguyssoftware.dungeons2.command.BuildEntranceCommand;
import com.someguyssoftware.dungeons2.command.ChestCommand;
import com.someguyssoftware.dungeons2.config.ModConfig;
import com.someguyssoftware.dungeons2.eventhandler.WorldEventHandler;
import com.someguyssoftware.dungeons2.items.DungeonsItems;
import com.someguyssoftware.dungeons2.loot.DungeonLootTableMaster;
import com.someguyssoftware.dungeons2.spawner.SpawnSheetLoader;
import com.someguyssoftware.dungeons2.style.StyleSheetLoader;
import com.someguyssoftware.dungeons2.worldgen.DungeonsWorldGen;
import com.someguyssoftware.dungeonsengine.config.DungeonConfigManager;
import com.someguyssoftware.gottschcore.GottschCore;
import com.someguyssoftware.gottschcore.annotation.Credits;
import com.someguyssoftware.gottschcore.command.ShowVersionCommand;
import com.someguyssoftware.gottschcore.config.IConfig;
import com.someguyssoftware.gottschcore.config.ILoggerConfig;
import com.someguyssoftware.gottschcore.mod.AbstractMod;
import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.gottschcore.proxy.IProxy;
import com.someguyssoftware.gottschcore.version.BuildVersion;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;

@Mod(modid="dungeons2", name="Dungeons2!", version="1.7.1", dependencies="required-after:forge@[14.23.5.2768,);required-after:gottschcore@[1.7.0,)", acceptedMinecraftVersions="[1.12.2]", updateJSON="https://raw.githubusercontent.com/gottsch/gottsch-minecraft-Dungeons2/master/Dungeons2-1.12.2/update.json")
@Credits(values={"Dungeons2! was first developed by Mark Gottschling on July 1, 2016."})
public class Dungeons2
extends AbstractMod {
    private static final String VERSION_URL = "";
    private static final BuildVersion MINECRAFT_VERSION = new BuildVersion(1, 12, 2);
    public static final String MODID = "dungeons2";
    public static final String NAME = "Dungeons2!";
    public static final String VERSION = "1.7.1";
    public static final String UPDATE_JSON_URL = "https://raw.githubusercontent.com/gottsch/gottsch-minecraft-Dungeons2/master/Dungeons2-1.12.2/update.json";
    public static BuildVersion latestVersion;
    public static final String LOGGER_NAME = "Dungeons2";
    public static Logger log;
    @Mod.Instance(value="dungeons2")
    public static Dungeons2 instance;
    @SidedProxy(clientSide="com.someguyssoftware.dungeons2.proxy.ClientProxy", serverSide="com.someguyssoftware.dungeons2.proxy.ServerProxy")
    public static IProxy proxy;
    public static SimpleNetworkWrapper network;
    public static DungeonsWorldGen dungeonsWorldGen;
    private static final String DUNGEONS_CONFIG_DIR = "dungeons2";
    private static ModConfig config;
    public static DungeonConfigManager CONFIG_MANAGER;
    public static DungeonLootTableMaster LOOT_TABLES;
    public static CreativeTabs DUNGEONS_TAB;

    @Mod.EventHandler
    public void preInt(FMLPreInitializationEvent event) {
        super.preInt(event);
        MinecraftForge.EVENT_BUS.register((Object)new WorldEventHandler(this.getInstance()));
        config = new ModConfig((IMod)this, event.getModConfigurationDirectory(), "dungeons2", "general.cfg");
        Appender appender = this.createRollingFileAppender("Dungeons2Appender", (ILoggerConfig)config);
        this.addAppenderToLogger(appender, LOGGER_NAME, (ILoggerConfig)config);
        this.addAppenderToLogger(appender, GottschCore.instance.getName(), (ILoggerConfig)config);
        network = NetworkRegistry.INSTANCE.newSimpleChannel("dungeons2");
        StyleSheetLoader.exposeStyleSheet(ModConfig.styleSheetFile);
        SpawnSheetLoader.exposeSpawnSheet(ModConfig.spawnSheetFile);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        log.debug("Setting up generator map");
        if (ModConfig.enableDungeons.booleanValue()) {
            proxy.registerRenderers(this.getConfig());
            dungeonsWorldGen = new DungeonsWorldGen();
            GameRegistry.registerWorldGenerator((IWorldGenerator)dungeonsWorldGen, (int)100);
            CONFIG_MANAGER = new DungeonConfigManager();
            LOOT_TABLES = new DungeonLootTableMaster((IMod)instance, VERSION_URL, "loot_tables");
        }
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new ShowVersionCommand((IMod)this));
        event.registerServerCommand((ICommand)new BuildCommand());
        event.registerServerCommand((ICommand)new ChestCommand());
        event.registerServerCommand((ICommand)new BuildEntranceCommand());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (!this.getConfig().isModEnabled()) {
            return;
        }
        super.postInit(event);
        OreDictionary.registerOre((String)"gravel", (Block)DungeonsBlocks.SANDSTONE_GRAVEL);
    }

    public IConfig getConfig() {
        return config;
    }

    public String getId() {
        return "dungeons2";
    }

    public String getName() {
        return NAME;
    }

    public IMod getInstance() {
        return instance;
    }

    public BuildVersion getModLatestVersion() {
        return latestVersion;
    }

    public void setModLatestVersion(BuildVersion version) {
        latestVersion = version;
    }

    public BuildVersion getMinecraftVersion() {
        return MINECRAFT_VERSION;
    }

    public String getVerisionURL() {
        return VERSION_URL;
    }

    public String getVersion() {
        return VERSION;
    }

    public String getUpdateURL() {
        return UPDATE_JSON_URL;
    }

    static {
        log = LogManager.getLogger((String)LOGGER_NAME);
        instance = new Dungeons2();
        network = null;
        DUNGEONS_TAB = new CreativeTabs(CreativeTabs.getNextID(), "dungeons2:dungeons_tab"){

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack(DungeonsItems.DUNGEONS_TAB, 1);
            }
        };
    }
}

