/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.builder;

import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeons2.builder.IDungeonBuilder;
import com.someguyssoftware.dungeons2.builder.LevelBuilder;
import com.someguyssoftware.dungeons2.model.Dungeon;
import com.someguyssoftware.dungeons2.model.Level;
import com.someguyssoftware.dungeons2.model.Room;
import com.someguyssoftware.dungeons2.model.Shaft;
import com.someguyssoftware.dungeonsengine.config.DungeonConfigManager;
import com.someguyssoftware.dungeonsengine.config.IDungeonConfig;
import com.someguyssoftware.dungeonsengine.config.ILevelConfig;
import com.someguyssoftware.gottschcore.enums.Direction;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DungeonBuilderTopDown
implements IDungeonBuilder {
    private static final Logger logger = LogManager.getLogger((String)"Dungeons2");
    private static final int MIN_ENTRANCE_XZ = 5;
    private static final int MAX_ENTRANCE_XZ = 9;
    private static final int MIN_ENTRANCE_Y = 7;
    private static final int MAX_ENTRANCE_Y = 13;
    private static final int TOP_LEVEL = 0;
    private LevelBuilder levelBuilder;
    private transient AxisAlignedBB boundary;
    private transient ICoords startPoint;
    private transient IDungeonConfig config;

    public DungeonBuilderTopDown() {
        this.levelBuilder = new LevelBuilder();
    }

    public DungeonBuilderTopDown(LevelBuilder builder) {
        this.levelBuilder = builder;
    }

    @Override
    public DungeonBuilderTopDown withBoundary(AxisAlignedBB boundary) {
        this.boundary = boundary;
        return this;
    }

    public DungeonBuilderTopDown withStartPoint(ICoords startPoint) {
        this.startPoint = startPoint;
        return this;
    }

    public DungeonBuilderTopDown withConfig(IDungeonConfig config) {
        this.config = config;
        return this;
    }

    @Override
    public Dungeon build(World world, Random rand, ICoords spawnCoords, IDungeonConfig config) {
        Dungeon dungeon = new Dungeon();
        ArrayList<Room> plannedRooms = new ArrayList<Room>();
        ILevelConfig defaultLevelConfig = config.getLevelConfigs()[0].apply(DungeonConfigManager.DEFAULT_CONFIG.getLevelConfigs()[0]);
        this.config = config;
        AxisAlignedBB dungeonBoundary = null;
        ICoords closestCoords = null;
        if (this.getBoundary() == null) {
            closestCoords = WorldInfo.getClosestPlayerCoords((World)world, (ICoords)spawnCoords);
            if (closestCoords == null) {
                Dungeons2.log.warn("Unable to locate closest player - using World spawn point");
                closestCoords = new Coords(world.func_175694_M());
            }
            if ((dungeonBoundary = this.getDungeonBoundary(spawnCoords, closestCoords)) == null) {
                Dungeons2.log.warn("Unable to calculate dungeon boundary from spawn pos-> {}, and player pos -> {}", (Object)spawnCoords.toShortString(), (Object)closestCoords.toShortString());
                return EMPTY_DUNGEON;
            }
            this.boundary = dungeonBoundary;
        } else {
            dungeonBoundary = this.getBoundary();
        }
        Dungeons2.log.debug("Dungeon boundary -> {}", (Object)dungeonBoundary);
        Dungeons2.log.debug("Dungeon boundary factor -> {}", (Object)config.getBoundaryFactor());
        if (config.getBoundaryFactor() > 0.0 && config.getBoundaryFactor() < 1.0) {
            int xAmount = (int)((dungeonBoundary.field_72336_d - dungeonBoundary.field_72340_a) * (1.0 - config.getBoundaryFactor()) / 2.0);
            int zAmount = (int)((dungeonBoundary.field_72334_f - dungeonBoundary.field_72339_c) * (1.0 - config.getBoundaryFactor()) / 2.0);
            dungeonBoundary = dungeonBoundary.func_72314_b((double)(-xAmount), 0.0, (double)(-zAmount));
            Dungeons2.log.debug("Dungeon shrunk by factor -> {} [{} {}], to new size -> {}", (Object)config.getBoundaryFactor(), (Object)xAmount, (Object)zAmount, (Object)dungeonBoundary);
            this.boundary = dungeonBoundary;
        }
        AxisAlignedBB lb = this.getLevelBuilder().resizeBoundary(dungeonBoundary, defaultLevelConfig.getBoundaryFactor());
        Dungeons2.log.debug("init level boundary -> {}, factor -> {}", (Object)lb, (Object)defaultLevelConfig.getBoundaryFactor());
        AxisAlignedBB roomBoundary = this.getLevelBuilder().resizeBoundary(lb, defaultLevelConfig.getSpawnBoundaryFactor());
        Dungeons2.log.debug("init spawn boundary -> {}, factor -> {}", (Object)roomBoundary, (Object)defaultLevelConfig.getSpawnBoundaryFactor());
        ICoords startPoint = null;
        if (this.startPoint == null) {
            startPoint = this.getLevelBuilder().randomizeCoords(rand, roomBoundary);
            ChunkPos startChunk = startPoint.toChunkPos();
            if (!world.func_190526_b(startChunk.field_77276_a, startChunk.field_77275_b)) {
                Dungeons2.log.debug("startPoint is not in a loaded chunk -> {}", (Object)startChunk);
                return EMPTY_DUNGEON;
            }
            startPoint = startPoint.resetY(WorldInfo.getHeightValue((World)world, (ICoords)startPoint));
        } else {
            startPoint = this.startPoint;
        }
        if (this.levelBuilder.getBoundary() == null) {
            this.levelBuilder.setBoundary(dungeonBoundary);
        }
        if (this.levelBuilder.getRoomBoundary() == null) {
            this.levelBuilder.setRoomBoundary(roomBoundary);
        }
        this.levelBuilder.setDungeonBuilder(this);
        if (config.isMinecraftConstraints() && !WorldInfo.isValidY((ICoords)startPoint)) {
            Dungeons2.log.debug(String.format("[%d] is not a valid y value.", startPoint.getY()));
            return EMPTY_DUNGEON;
        }
        ICoords surfaceCoords = null;
        if (config.isMinecraftConstraints()) {
            surfaceCoords = WorldInfo.getDryLandSurfaceCoords((World)world, (ICoords)startPoint);
            if (surfaceCoords == null || surfaceCoords == WorldInfo.EMPTY_COORDS) {
                Dungeons2.log.debug(String.format("Not a valid dry land surface @ %s", startPoint.toShortString()));
                return EMPTY_DUNGEON;
            }
        } else {
            surfaceCoords = startPoint;
        }
        if (surfaceCoords.getY() < config.getBottomLimit() || surfaceCoords.getY() > config.getTopLimit()) {
            Dungeons2.log.debug(String.format("Start position is outside Y constraints: Start %s, yBottom: %d, yTop: %d", surfaceCoords.toShortString(), config.getBottomLimit(), config.getTopLimit()));
            return EMPTY_DUNGEON;
        }
        if (config.isMinecraftConstraints() && (double)(surfaceCoords.getY() - config.getSurfaceBuffer()) - defaultLevelConfig.getHeight().getMax() < (double)config.getBottomLimit()) {
            Dungeons2.log.debug(String.format("Start position is not deep enough to generate a dungeon @ %s", surfaceCoords.toShortString()));
            return EMPTY_DUNGEON;
        }
        Room entranceRoom = this.buildEntranceRoom(world, rand, surfaceCoords);
        Dungeons2.log.debug("Exit Room:" + entranceRoom);
        if (!this.levelBuilder.isRoomInLoadedChunks(world, entranceRoom)) {
            Dungeons2.log.debug("entrance room is NOT in valid chunks -> {} {}", (Object)surfaceCoords, (Object)surfaceCoords.toChunkPos());
            return EMPTY_DUNGEON;
        }
        if (config.isMinecraftConstraints() && !WorldInfo.isValidAboveGroundBase((World)world, (ICoords)entranceRoom.getCoords().resetY(surfaceCoords.getY()), (int)entranceRoom.getWidth(), (int)entranceRoom.getDepth(), (double)50.0, (double)20.0, (double)50.0)) {
            if (Dungeons2.log.isDebugEnabled()) {
                Dungeons2.log.debug(String.format("Surface area does not meet ground/air criteria @ %s", surfaceCoords));
            }
            return EMPTY_DUNGEON;
        }
        dungeon.setEntrance(entranceRoom);
        startPoint = surfaceCoords.add(0, -(config.getSurfaceBuffer() + defaultLevelConfig.getHeight().getMaxInt()), 0);
        Room startRoom = null;
        Room endRoom = null;
        boolean isBottomLevel = false;
        int numberOfLevels = RandomHelper.randomInt((Random)rand, (int)((int)config.getNumLevels().getMin()), (int)((int)config.getNumLevels().getMax()));
        Dungeons2.log.debug("number of levels:" + numberOfLevels);
        ILevelConfig prevLevelConfig = DungeonConfigManager.DEFAULT_CONFIG.getLevelConfigs()[0];
        ILevelConfig levelConfig = null;
        for (int levelIndex = 0; levelIndex < numberOfLevels; ++levelIndex) {
            logger.debug("Building level -> {}", (Object)levelIndex);
            prevLevelConfig = levelConfig;
            if (levelIndex <= config.getLevelConfigs().length - 1) {
                levelConfig = config.getLevelConfigs()[levelIndex];
                if (prevLevelConfig != null) {
                    levelConfig.apply(prevLevelConfig);
                }
            } else {
                levelConfig = prevLevelConfig;
            }
            Dungeons2.log.debug("using config -> {}", (Object)levelConfig);
            if (levelConfig != prevLevelConfig) {
                AxisAlignedBB levelBoundary = this.getLevelBuilder().resizeBoundary(dungeonBoundary, levelConfig.getBoundaryFactor());
                this.getLevelBuilder().setBoundary(levelBoundary);
                Dungeons2.log.debug("new level boundary ->{} (factor -> {}", (Object)levelBoundary, (Object)levelConfig.getBoundaryFactor());
                roomBoundary = this.getLevelBuilder().resizeBoundary(levelBoundary, levelConfig.getSpawnBoundaryFactor());
                this.getLevelBuilder().setRoomBoundary(roomBoundary);
                Dungeons2.log.debug("new spawn boundary ->{} (factor -> {}", (Object)roomBoundary, (Object)levelConfig.getSpawnBoundaryFactor());
            }
            if ((double)startPoint.getY() - levelConfig.getHeight().getMax() < (double)config.getBottomLimit()) {
                isBottomLevel = true;
            }
            if (levelIndex == 0) {
                Dungeons2.log.debug("TOP LEVEL");
                startRoom = this.levelBuilder.buildStartRoom(world, rand, roomBoundary, startPoint, levelConfig);
                if (startRoom == LevelBuilder.EMPTY_ROOM) {
                    Dungeons2.log.warn("Unable to generate Top level Start Room.");
                    return EMPTY_DUNGEON;
                }
                startRoom.setDirection(entranceRoom.getDirection());
                Dungeons2.log.debug("Top Level Start Room:" + startRoom);
                plannedRooms.add(startRoom);
                endRoom = this.levelBuilder.buildEndRoom(world, rand, roomBoundary, startPoint, plannedRooms, levelConfig);
                if (endRoom == LevelBuilder.EMPTY_ROOM) {
                    logger.warn("Unable to generate Top level End Room.");
                    return EMPTY_DUNGEON;
                }
                plannedRooms.add(endRoom);
            } else if (levelIndex == numberOfLevels - 1 || isBottomLevel) {
                Dungeons2.log.debug("BOTTOM LEVEL");
                startRoom = new Room(dungeon.getLevels().get(levelIndex - 1).getEndRoom());
                if (startRoom == LevelBuilder.EMPTY_ROOM) {
                    logger.warn("Unable to generate Bottom level Start Room");
                    return EMPTY_DUNGEON;
                }
                Dungeons2.log.debug("StartPoint (Bottom Level): " + startPoint);
                startRoom.setCoords(startRoom.getCoords().resetY(startPoint.getY()));
                startRoom.setDistance(startRoom.getCenter().getDistance(startPoint));
                startRoom.setAnchor(true).setStart(true).setEnd(false);
                plannedRooms.add(startRoom);
                endRoom = this.levelBuilder.buildBossRoom(world, rand, roomBoundary, startPoint, plannedRooms, levelConfig);
                if (endRoom == LevelBuilder.EMPTY_ROOM) {
                    logger.warn("Unable to generate Bottom level End Room.");
                    return EMPTY_DUNGEON;
                }
                Dungeons2.log.debug("Boss Room (Bottom Level): " + endRoom);
                Dungeons2.log.debug("BossPoint (Bottom Level): " + endRoom.getCoords().toShortString());
                plannedRooms.add(endRoom);
            } else {
                Dungeons2.log.debug("Building Start Room for Level: " + levelIndex);
                startRoom = new Room(dungeon.getLevels().get(levelIndex - 1).getEndRoom());
                if (startRoom == LevelBuilder.EMPTY_ROOM) {
                    logger.warn("Unable to generate level Start Room: " + levelIndex);
                    return EMPTY_DUNGEON;
                }
                startRoom.setCoords(startRoom.getCoords().resetY(startPoint.getY()));
                startRoom.setDistance(startRoom.getCenter().getDistance(startPoint));
                startRoom.setAnchor(true).setStart(true).setEnd(false);
                plannedRooms.add(startRoom);
                Dungeons2.log.debug("Level Start Room:" + startRoom);
                endRoom = this.levelBuilder.buildPlannedRoom(world, rand, roomBoundary, startPoint, plannedRooms, levelConfig);
                if (endRoom == LevelBuilder.EMPTY_ROOM) {
                    logger.warn("Unable to generate level End Room: " + levelIndex);
                    return EMPTY_DUNGEON;
                }
                endRoom.setDistance(endRoom.getCenter().getDistance(startPoint));
                endRoom.setAnchor(true).setStart(false).setEnd(true).setType(Room.Type.LADDER);
                plannedRooms.add(endRoom);
            }
            Level level = this.levelBuilder.build(world, rand, startPoint, plannedRooms, levelConfig);
            level.setConfig(levelConfig);
            if (level != LevelBuilder.EMPTY_LEVEL) {
                if (dungeon.getMinX() == null || level.getMinX() < dungeon.getMinX()) {
                    dungeon.setMinX(level.getMinX());
                }
                if (dungeon.getMaxX() == null || level.getMaxX() > dungeon.getMaxX()) {
                    dungeon.setMaxX(level.getMaxX());
                }
                if (dungeon.getMinY() == null || level.getMinY() < dungeon.getMinY()) {
                    dungeon.setMinY(level.getMinY());
                }
                if (dungeon.getMaxY() == null || level.getMaxY() > dungeon.getMaxY()) {
                    dungeon.setMaxY(level.getMaxY());
                }
                if (dungeon.getMinZ() == null || level.getMinZ() < dungeon.getMinZ()) {
                    dungeon.setMinZ(level.getMinZ());
                }
                if (dungeon.getMaxZ() == null || level.getMaxZ() > dungeon.getMaxZ()) {
                    dungeon.setMaxZ(level.getMaxZ());
                }
                dungeon.getLevels().add(level);
                if (levelIndex > 0) {
                    Dungeons2.log.debug("Joing levels " + (levelIndex - 1) + " to " + levelIndex);
                    if (this.levelBuilder.join(level, dungeon.getLevels().get(levelIndex - 1)) == LevelBuilder.EMPTY_SHAFT) {
                        Dungeons2.log.warn("Levels don't require joining " + levelIndex + " to " + (levelIndex - 1));
                    }
                }
            } else {
                logger.warn("Unable to generate Level: " + levelIndex);
                return EMPTY_DUNGEON;
            }
            plannedRooms.clear();
            if (isBottomLevel) {
                Dungeons2.log.debug("At bottom level... break...");
                break;
            }
            startPoint = endRoom.getCenter();
            startPoint = startPoint.resetY(dungeon.getMinY() - (int)levelConfig.getHeight().getMax());
            this.getLevelBuilder().setRoomLossToDistanceBuffering(0);
            this.getLevelBuilder().setRoomLossToValidation(0);
        }
        Dungeons2.log.debug("Testing for empty dungeon...");
        if (dungeon == EMPTY_DUNGEON || dungeon.getLevels().size() == 0) {
            logger.warn("Unable to build dungeon. 0 levels were built.");
            return EMPTY_DUNGEON;
        }
        Dungeons2.log.debug("Joining shaft from entrance to start room...");
        Dungeons2.log.debug("Start Room:" + dungeon.getLevels().get(0).getStartRoom());
        Dungeons2.log.debug("Exit Room:" + entranceRoom);
        Shaft shaft = this.levelBuilder.join(dungeon.getLevels().get(0).getStartRoom(), entranceRoom);
        if (shaft == LevelBuilder.EMPTY_SHAFT) {
            Dungeons2.log.debug("Didn't join start room to entrance room");
        }
        Dungeons2.log.debug("Adding shaft to shaft list...");
        Dungeons2.log.debug("Dungeon level[0]:" + dungeon.getLevels().get(0));
        dungeon.getLevels().get(0).getShafts().add(shaft);
        return dungeon;
    }

    private AxisAlignedBB getRoomBoundary(AxisAlignedBB boundary) {
        Vec3d center = new Vec3d(boundary.field_72340_a + (boundary.field_72336_d - boundary.field_72340_a) * 0.5, boundary.field_72338_b + (boundary.field_72337_e - boundary.field_72338_b) * 0.5, boundary.field_72339_c + (boundary.field_72334_f - boundary.field_72339_c) * 0.5);
        AxisAlignedBB roomBoundary = new AxisAlignedBB(new BlockPos(center)).func_186662_g(30.0);
        return roomBoundary;
    }

    private AxisAlignedBB getDungeonBoundary(ICoords spawnCoords, ICoords closestCoords) {
        AxisAlignedBB dungeonBoundary = null;
        ICoords deltaCoords = spawnCoords.delta(closestCoords);
        Dungeons2.log.debug("spawnCoords -> {}", (Object)spawnCoords);
        Dungeons2.log.debug("deltaCoords -> {}", (Object)deltaCoords.toShortString());
        int dist = Math.max(Math.min(Math.max(Math.abs(deltaCoords.getX()), Math.abs(deltaCoords.getZ())), 256), 25);
        Dungeons2.log.debug("dist from player to spawn -> {}", (Object)dist);
        dungeonBoundary = new AxisAlignedBB(closestCoords.toPos());
        EnumFacing fieldFacing = null;
        if (Math.abs(deltaCoords.getX()) >= Math.abs(deltaCoords.getZ())) {
            Dungeons2.log.debug("deltaX -> {} >= deltaZ -> {}", (Object)Math.abs(deltaCoords.getX()), (Object)Math.abs(deltaCoords.getZ()));
            if (deltaCoords.getX() < 0) {
                Dungeons2.log.debug("field facing west");
                fieldFacing = EnumFacing.WEST;
                dungeonBoundary = dungeonBoundary.func_72321_a((double)(-dist), 0.0, 0.0).func_72314_b(0.0, 0.0, (double)dist);
            } else {
                Dungeons2.log.debug("field facing east");
                fieldFacing = EnumFacing.EAST;
                dungeonBoundary = dungeonBoundary.func_72321_a((double)dist, 0.0, 0.0).func_72314_b(0.0, 0.0, (double)dist);
            }
        } else {
            Dungeons2.log.debug("deltaX -> {} < deltaZ -> {}", (Object)Math.abs(deltaCoords.getX()), (Object)Math.abs(deltaCoords.getZ()));
            if (deltaCoords.getZ() < 0) {
                Dungeons2.log.debug("field facing north");
                fieldFacing = EnumFacing.NORTH;
                dungeonBoundary = dungeonBoundary.func_72321_a(0.0, 0.0, (double)(-dist)).func_72314_b((double)dist, 0.0, 0.0);
            } else {
                Dungeons2.log.debug("field facing south");
                fieldFacing = EnumFacing.SOUTH;
                dungeonBoundary = dungeonBoundary.func_72321_a(0.0, 0.0, (double)dist).func_72314_b((double)dist, 0.0, 0.0);
            }
        }
        return dungeonBoundary;
    }

    @Override
    public Room buildEntranceRoom(World world, Random rand, ICoords startPoint) {
        Room room = new Room().setStart(true).setAnchor(true).setType(Room.Type.ENTRANCE);
        int xz = RandomHelper.randomInt((Random)rand, (int)5, (int)9);
        if (xz % 2 == 0) {
            ++xz;
        }
        room.setWidth(xz);
        room.setDepth(xz);
        room.setHeight(RandomHelper.randomInt((Random)rand, (int)7, (int)13));
        room.setCoords((ICoords)new Coords(startPoint.getX() - (room.getWidth() - 1) / 2, startPoint.getY(), startPoint.getZ() - (room.getDepth() - 1) / 2));
        room.setDistance(0.0);
        room.setDirection(Direction.getByCode((Integer)RandomHelper.randomInt((int)2, (int)5)));
        return room;
    }

    @Override
    public LevelBuilder getLevelBuilder() {
        return this.levelBuilder;
    }

    @Override
    public void setLevelBuilder(LevelBuilder levelBuilder) {
        this.levelBuilder = levelBuilder;
    }

    @Override
    public AxisAlignedBB getBoundary() {
        return this.boundary;
    }

    protected void setBoundary(AxisAlignedBB boundary) {
        this.boundary = boundary;
    }

    @Override
    public IDungeonConfig getConfig() {
        return this.config;
    }
}

