/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.builder;

import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeons2.builder.IDungeonBuilder;
import com.someguyssoftware.dungeons2.graph.Wayline;
import com.someguyssoftware.dungeons2.graph.Waypoint;
import com.someguyssoftware.dungeons2.graph.mst.Edge;
import com.someguyssoftware.dungeons2.graph.mst.EdgeWeightedGraph;
import com.someguyssoftware.dungeons2.graph.mst.LazyPrimMST;
import com.someguyssoftware.dungeons2.model.Door;
import com.someguyssoftware.dungeons2.model.Hallway;
import com.someguyssoftware.dungeons2.model.Level;
import com.someguyssoftware.dungeons2.model.LevelConfig;
import com.someguyssoftware.dungeons2.model.Room;
import com.someguyssoftware.dungeons2.model.Shaft;
import com.someguyssoftware.dungeons2.triangulation.jdiemke.triangulation.DelaunayTriangulator;
import com.someguyssoftware.dungeons2.triangulation.jdiemke.triangulation.NotEnoughPointsException;
import com.someguyssoftware.dungeons2.triangulation.jdiemke.triangulation.Triangle2D;
import com.someguyssoftware.dungeons2.triangulation.jdiemke.triangulation.Vector2D;
import com.someguyssoftware.dungeonsengine.config.ILevelConfig;
import com.someguyssoftware.gottschcore.enums.Alignment;
import com.someguyssoftware.gottschcore.enums.Direction;
import com.someguyssoftware.gottschcore.enums.Rotate;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.positional.Intersect;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Random;
import java.util.Stack;
import java.util.Vector;
import java.util.stream.Collectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class LevelBuilder {
    private static final double DEFAULT_FORCE_MODIFIER = 0.85;
    public static final int MIN_HORIZONTAL_DIMENSION = 3;
    public static final int MIN_VERTICAL_DIMENSION = 2;
    public static final int MIN_NUMBER_OF_ROOMS = 5;
    private static final ICoords FORCE_SOURCE_COORDS = new Coords(0, 0, 0);
    public static final Room EMPTY_ROOM = new Room();
    public static final Level EMPTY_LEVEL = new Level();
    public static final List<Room> EMPTY_ROOMS = new ArrayList<Room>();
    public static final List<Wayline> EMPTY_WAYLINES = new ArrayList<Wayline>();
    public static final Shaft EMPTY_SHAFT = new Shaft();
    private static final int MIN_START_ROOM_SIZE = 7;
    private static final double MIN_BOUNDARY_SIZE = 25.0;
    private IDungeonBuilder dungeonBuilder;
    @Deprecated
    private LevelConfig config;
    private AxisAlignedBB field;
    private AxisAlignedBB roomBoundary;
    int roomLossToDistanceBuffering = 0;
    int roomLossToValidation = 0;

    public LevelBuilder() {
    }

    public LevelBuilder(LevelConfig config) {
        this.config = config;
    }

    public AxisAlignedBB resizeBoundary(AxisAlignedBB boundary, double factor) {
        if (factor < 1.0) {
            double p;
            double deltaX = boundary.field_72336_d - boundary.field_72340_a;
            double deltaZ = boundary.field_72334_f - boundary.field_72339_c;
            Dungeons2.log.debug("deltaX -> {}", (Object)deltaX);
            Dungeons2.log.debug("deltaZ -> {}", (Object)deltaZ);
            int xAmount = (int)(deltaX * (1.0 - factor) / 2.0);
            int zAmount = (int)(deltaZ * (1.0 - factor) / 2.0);
            Dungeons2.log.debug("initial shrink amounts -> {} {}", (Object)xAmount, (Object)zAmount);
            if (Math.abs(deltaX - (double)(xAmount * 2)) < 25.0) {
                p = 1.0 - 50.0 / Math.abs(deltaX);
                xAmount = (int)(deltaX * p / 2.0);
                Dungeons2.log.debug("x less than min, new amount -> {} [{}%]", (Object)xAmount, (Object)p);
            }
            if (Math.abs(deltaZ - (double)(zAmount * 2)) < 25.0) {
                p = 1.0 - 50.0 / Math.abs(deltaZ);
                zAmount = (int)(deltaZ * p / 2.0);
                Dungeons2.log.debug("z less than min, new amount -> {} [{}%]", (Object)zAmount, (Object)p);
            }
            AxisAlignedBB newBoundary = boundary.func_72314_b((double)(-xAmount), 0.0, (double)(-zAmount));
            Dungeons2.log.debug("boundary shrunk by -> {} {}, to new size -> {}", (Object)xAmount, (Object)zAmount, (Object)newBoundary);
            return newBoundary;
        }
        return boundary;
    }

    @Deprecated
    protected List<Room> spawnRooms(Random rand, ICoords startPoint, LevelConfig config) {
        ArrayList<Room> rooms = new ArrayList<Room>();
        int levelSize = Math.max(5, RandomHelper.randomInt((Random)rand, (int)config.getNumberOfRooms().getMinInt(), (int)config.getNumberOfRooms().getMaxInt()));
        for (int i = 0; i < levelSize; ++i) {
            Room room = new Room(i);
            room = this.randomizeRoom(rand, room, startPoint, config);
            rooms.add(room);
        }
        return rooms;
    }

    @Deprecated
    protected List<Room> spawnRooms(Random rand, AxisAlignedBB field, ICoords startPoint, LevelConfig config) {
        ArrayList<Room> rooms = new ArrayList<Room>();
        int levelSize = Math.max(5, RandomHelper.randomInt((Random)rand, (int)config.getNumberOfRooms().getMinInt(), (int)config.getNumberOfRooms().getMaxInt()));
        for (int i = 0; i < levelSize; ++i) {
            Room room = new Room(i);
            room = this.randomizeRoom(rand, room, field, startPoint, config);
            rooms.add(room);
        }
        return rooms;
    }

    protected List<Room> spawnRooms(Random rand, AxisAlignedBB field, ICoords startPoint, ILevelConfig config) {
        ArrayList<Room> rooms = new ArrayList<Room>();
        int levelSize = Math.max(5, RandomHelper.randomInt((Random)rand, (int)config.getNumRooms().getMinInt(), (int)config.getNumRooms().getMaxInt()));
        for (int i = 0; i < levelSize; ++i) {
            Room room = new Room(i);
            room = this.randomizeRoom(rand, room, field, startPoint, config);
            rooms.add(room);
        }
        return rooms;
    }

    protected Room randomizeRoom(Random rand, Room roomIn, ICoords startPoint, LevelConfig config) {
        Room room = this.randomizeDimensions(rand, roomIn, config);
        room = this.randomizeRoomCoords(rand, room, config);
        room.setCoords(room.getCoords().add(startPoint.getX() - room.getWidth() / 2, startPoint.getY(), startPoint.getZ() - room.getDepth() / 2));
        room.setDistance(room.getCenter().getDistanceSq(startPoint));
        room.setDegrees(RandomHelper.randomInt((Random)rand, (int)config.getDegrees().getMinInt(), (int)config.getDegrees().getMaxInt()));
        room.setDirection(Direction.getByCode((Integer)RandomHelper.randomInt((int)2, (int)5)));
        return room;
    }

    protected Room randomizeRoom(Random rand, Room roomIn, AxisAlignedBB field, ICoords startPoint, ILevelConfig config) {
        Room room = this.randomizeDimensions(rand, roomIn, config);
        room = this.randomizeRoomCoords(rand, room, field, config);
        room.setCoords(room.getCoords().resetY(startPoint.getY()));
        room.setDistance(room.getCenter().getDistanceSq(startPoint));
        room.setDegrees(RandomHelper.randomInt((Random)rand, (int)config.getDegrees().getMinInt(), (int)config.getDegrees().getMaxInt()));
        room.setDirection(Direction.getByCode((Integer)RandomHelper.randomInt((int)2, (int)5)));
        return room;
    }

    @Deprecated
    protected Room randomizeRoom(Random rand, Room roomIn, AxisAlignedBB field, ICoords startPoint, LevelConfig config) {
        Room room = this.randomizeDimensions(rand, roomIn, config);
        room = this.randomizeRoomCoords(rand, room, field, config);
        room.setCoords(room.getCoords().resetY(startPoint.getY()));
        room.setDistance(room.getCenter().getDistanceSq(startPoint));
        room.setDegrees(RandomHelper.randomInt((Random)rand, (int)config.getDegrees().getMinInt(), (int)config.getDegrees().getMaxInt()));
        room.setDirection(Direction.getByCode((Integer)RandomHelper.randomInt((int)2, (int)5)));
        return room;
    }

    protected Room randomizeRoomCoords(Random random, Room roomIn, LevelConfig config) {
        Room room = new Room(roomIn);
        ICoords c = this.randomizeCoords(random, config);
        room.setCoords(c.add(-(room.getWidth() / 2), 0, -(room.getDepth() / 2)));
        return room;
    }

    protected Room randomizeRoomCoords(Random random, Room roomIn, AxisAlignedBB field, ILevelConfig config) {
        Room room = new Room(roomIn);
        ICoords c = this.randomizeCoords(random, field);
        room.centerOn(c);
        return room;
    }

    @Deprecated
    protected Room randomizeRoomCoords(Random random, Room roomIn, AxisAlignedBB field, LevelConfig config) {
        Room room = new Room(roomIn);
        ICoords c = this.randomizeCoords(random, field, config);
        room.setCoords(c.add(-(room.getWidth() / 2), 0, -(room.getDepth() / 2)));
        return room;
    }

    protected ICoords randomizeCoords(Random random, LevelConfig config) {
        int x = RandomHelper.randomInt((Random)random, (int)config.getXDistance().getMinInt(), (int)config.getXDistance().getMaxInt());
        int y = RandomHelper.randomInt((Random)random, (int)config.getYVariance().getMinInt(), (int)config.getYVariance().getMaxInt());
        int z = RandomHelper.randomInt((Random)random, (int)config.getZDistance().getMinInt(), (int)config.getZDistance().getMaxInt());
        return new Coords(x, y, z);
    }

    protected ICoords randomizeCoords(Random random, AxisAlignedBB field, LevelConfig config) {
        int x = RandomHelper.randomInt((Random)random, (int)0, (int)((int)(field.field_72336_d - field.field_72340_a)));
        int y = RandomHelper.randomInt((Random)random, (int)0, (int)((int)(field.field_72337_e - field.field_72338_b)));
        int z = RandomHelper.randomInt((Random)random, (int)0, (int)((int)(field.field_72334_f - field.field_72339_c)));
        return new Coords((int)field.field_72340_a, (int)field.field_72338_b, (int)field.field_72339_c).add(x, y, z);
    }

    protected ICoords randomizeCoords(Random random, AxisAlignedBB field) {
        int x = RandomHelper.randomInt((Random)random, (int)0, (int)((int)(field.field_72336_d - field.field_72340_a)));
        int y = RandomHelper.randomInt((Random)random, (int)0, (int)((int)(field.field_72337_e - field.field_72338_b)));
        int z = RandomHelper.randomInt((Random)random, (int)0, (int)((int)(field.field_72334_f - field.field_72339_c)));
        return new Coords((int)field.field_72340_a, (int)field.field_72338_b, (int)field.field_72339_c).add(x, y, z);
    }

    protected Room randomizeDimensions(Random rand, Room roomIn, ILevelConfig config) {
        Room room = new Room(roomIn);
        room.setWidth(Math.max(5, RandomHelper.randomInt((Random)rand, (int)config.getWidth().getMinInt(), (int)config.getWidth().getMaxInt())));
        room.setDepth(Math.max(5, RandomHelper.randomInt((Random)rand, (int)config.getDepth().getMinInt(), (int)config.getDepth().getMaxInt())));
        room.setHeight(Math.max(4, RandomHelper.randomInt((Random)rand, (int)config.getHeight().getMinInt(), (int)config.getHeight().getMaxInt())));
        return room;
    }

    @Deprecated
    protected Room randomizeDimensions(Random rand, Room roomIn, LevelConfig config) {
        Room room = new Room(roomIn);
        room.setWidth(Math.max(5, RandomHelper.randomInt((Random)rand, (int)config.getWidth().getMinInt(), (int)config.getWidth().getMaxInt())));
        room.setDepth(Math.max(5, RandomHelper.randomInt((Random)rand, (int)config.getDepth().getMinInt(), (int)config.getDepth().getMaxInt())));
        room.setHeight(Math.max(4, RandomHelper.randomInt((Random)rand, (int)config.getHeight().getMinInt(), (int)config.getHeight().getMaxInt())));
        return room;
    }

    protected List<Room> applyDistanceBuffering(Random rand, ICoords startPoint, List<Room> anchors, List<Room> rooms) {
        ArrayList<Room> bufferedRooms = new ArrayList<Room>();
        int processCount = 0;
        bufferedRooms.addAll(anchors);
        block0: for (Room room : rooms) {
            if (room.isReject()) {
                this.incrementLossToDistanceBuffering(1);
                continue;
            }
            processCount = 0;
            AxisAlignedBB roomBB = room.getXZBoundingBox();
            if (bufferedRooms != null && bufferedRooms.size() > 0) {
                boolean processBufferedRooms = true;
                block1: while (processBufferedRooms) {
                    if (++processCount > 50) {
                        Dungeons2.log.trace("Detected endless loop when positioning room ==> room REJECTED.");
                        room.setReject(true);
                        this.incrementLossToDistanceBuffering(1);
                        continue block0;
                    }
                    for (Room bufferedRoom : bufferedRooms) {
                        AxisAlignedBB bufferedBB = bufferedRoom.getXZBoundingBox();
                        int failSafeCount = 0;
                        while (roomBB.func_72326_a(bufferedBB)) {
                            if (room.isAnchor()) {
                                Dungeons2.log.info("Room is anchored. Remove from level as it can not change position.");
                                room.setReject(true);
                                this.incrementLossToDistanceBuffering(1);
                                continue block0;
                            }
                            double angle = room.getCenter().getXZAngle(startPoint);
                            Intersect intersect = Intersect.getIntersect((AxisAlignedBB)roomBB, (AxisAlignedBB)bufferedBB);
                            double force = FORCE_SOURCE_COORDS.getDistance(intersect.getX(), 0.0, intersect.getZ()) * 0.85;
                            double xForce = Math.sin(angle) * force;
                            double zForce = Math.cos(angle) * force;
                            room = room.addXZForce(angle, force);
                            room.setDistance(room.getCenter().getDistanceSq(startPoint));
                            roomBB = room.getXZBoundingBox();
                            if (!roomBB.func_72326_a(bufferedBB)) continue block1;
                            if (++failSafeCount < 5) continue;
                            room.setReject(true);
                            this.incrementLossToDistanceBuffering(1);
                            continue block0;
                        }
                        failSafeCount = 0;
                    }
                    processBufferedRooms = false;
                }
            }
            bufferedRooms.add(room);
        }
        return bufferedRooms;
    }

    public Shaft join(Level sourceLevel, Level destLevel) {
        Shaft shaft = EMPTY_SHAFT;
        List destRooms = destLevel.getRooms().stream().filter(room -> room.isEnd()).collect(Collectors.toList());
        List sourceRooms = sourceLevel.getRooms().stream().filter(room -> room.isStart()).collect(Collectors.toList());
        Dungeons2.log.debug("destRooms.size=" + destRooms.size());
        Dungeons2.log.debug("sourceRooms.size=" + sourceRooms.size());
        if (destRooms == null || sourceRooms == null || destRooms.size() == 0 || sourceRooms.size() == 0) {
            return shaft;
        }
        Room destRoom = (Room)destRooms.get(0);
        Room sourceRoom = (Room)sourceRooms.get(0);
        Dungeons2.log.debug("destRoom: " + destRoom);
        Dungeons2.log.debug("sourceRoom: " + sourceRoom);
        shaft = this.join(sourceRoom, destRoom);
        Dungeons2.log.debug("shaft: " + shaft);
        if (shaft != EMPTY_SHAFT) {
            sourceLevel.getShafts().add(shaft);
        }
        return shaft;
    }

    public Shaft join(Room sourceRoom, Room destRoom) {
        Shaft shaft = EMPTY_SHAFT;
        if (destRoom.getMinY() - sourceRoom.getMaxY() > 1) {
            ICoords center = destRoom.getCenter();
            Dungeons2.log.debug("center of dest room: " + center);
            shaft = (Shaft)new Shaft().setDirection(sourceRoom.getDirection()).setDegrees(0).setType(Room.Type.LADDER);
            shaft.setWidth(3).setDepth(3).setHeight(destRoom.getMinY() - sourceRoom.getMaxY() - 1);
            shaft.setParent(sourceRoom);
            switch (shaft.getDirection()) {
                case NORTH: {
                    shaft.setCoords((ICoords)new Coords(center.getX() - 1, sourceRoom.getMaxY() + 1, center.getZ()));
                    break;
                }
                case EAST: {
                    shaft.setCoords((ICoords)new Coords(center.getX() - 2, sourceRoom.getMaxY() + 1, center.getZ() - 1));
                    break;
                }
                case SOUTH: {
                    shaft.setCoords((ICoords)new Coords(center.getX() - 1, sourceRoom.getMaxY() + 1, center.getZ() - 2));
                    break;
                }
                case WEST: {
                    shaft.setCoords((ICoords)new Coords(center.getX(), sourceRoom.getMaxY() + 1, center.getZ() - 1));
                    break;
                }
            }
        }
        Dungeons2.log.debug("shaft: " + shaft);
        return shaft;
    }

    public Level build(World world, Random rand, ICoords startPoint, List<Room> plannedRooms, ILevelConfig config) {
        ArrayList<Room> anchors = new ArrayList<Room>();
        List<Room> spawned = null;
        List<Room> rooms = null;
        List<Edge> edges = null;
        List<Edge> paths = null;
        List<Wayline> waylines = null;
        ArrayList<Hallway> hallways = null;
        Room startRoom = null;
        Room endRoom = null;
        Level level = new Level();
        spawned = this.spawnRooms(rand, this.getRoomBoundary(), startPoint, config);
        Dungeons2.log.debug("Spawned.size=" + spawned.size());
        for (Room room2 : plannedRooms) {
            if (room2.isStart() && startRoom == null) {
                startRoom = room2;
            } else if (room2.isEnd() && endRoom == null) {
                endRoom = room2;
            }
            if (room2.isAnchor()) {
                anchors.add(room2);
                continue;
            }
            spawned.add(room2);
        }
        Collections.sort(spawned, Room.distanceComparator);
        Dungeons2.log.debug("Before Apply Distance Buffering Rooms.size -> {}", (Object)(anchors.size() + spawned.size()));
        rooms = this.applyDistanceBuffering(rand, startPoint, anchors, spawned);
        Dungeons2.log.debug("After Apply Distance Buffering Rooms.size -> {}, room loss -> {}", (Object)rooms.size(), (Object)this.getRoomLossToDistanceBuffering());
        rooms = this.selectValidRooms(world, rand, rooms, config);
        Dungeons2.log.debug("After select valid rooms Rooms.size -> {}, room loss -> {}", (Object)rooms.size(), (Object)this.getRoomLossToValidation());
        if (rooms == null || rooms.size() < 5) {
            return EMPTY_LEVEL;
        }
        int mx = 0;
        int mz = 0;
        for (int i = 0; i < rooms.size(); ++i) {
            if (rooms.get(i).getMinX() < mx) {
                mx = rooms.get(i).getMinX();
            }
            if (rooms.get(i).getMinZ() >= mz) continue;
            mz = rooms.get(i).getMinZ();
        }
        if (mx < 0 || mz < 0) {
            for (Room room : rooms) {
                room.setCoords(room.getCoords().add(Math.abs(mx) + 1, 0, Math.abs(mz) + 1));
            }
        }
        if ((edges = this.triangulate(rooms)) == null) {
            return EMPTY_LEVEL;
        }
        paths = this.calculatePaths(rand, edges, rooms);
        Dungeons2.log.debug("StartRoom.id=" + startRoom.getId());
        Dungeons2.log.debug("EndRoom.id=" + endRoom.getId());
        if (!this.BFS(startRoom.getId(), endRoom.getId(), rooms, paths)) {
            Dungeons2.log.debug("A path doesn't exist from start room to end room on level.");
            return EMPTY_LEVEL;
        }
        waylines = this.calculateWaylines(rand, paths, rooms);
        if (waylines == EMPTY_WAYLINES) {
            return EMPTY_LEVEL;
        }
        if (mx < 0 || mz < 0) {
            for (Room room : rooms) {
                room.setCoords(room.getCoords().add(mx - 1, 0, mz - 1));
            }
            for (Wayline wayline : waylines) {
                wayline.getPoint1().setCoords(wayline.getPoint1().getCoords().add(mx - 1, 0, mz - 1));
                wayline.getPoint2().setCoords(wayline.getPoint2().getCoords().add(mx - 1, 0, mz - 1));
            }
        }
        hallways = new ArrayList<Hallway>();
        ArrayList<Wayline> processedJoins = new ArrayList<Wayline>(10);
        for (Wayline line : waylines) {
            Hallway hallway = this.buildHallway(line, rooms);
            hallways.add(hallway);
            this.addDoorsToRoom(hallway);
            if (line.getWayline() == null || processedJoins.contains(line.getWayline())) continue;
            Hallway hallway2 = this.buildHallway(line.getWayline(), rooms);
            hallway2.setHallway(hallway);
            hallway.setHallway(hallway2);
            this.addDoorsToRoom(hallway2);
            hallways.add(hallway2);
            processedJoins.add(line);
        }
        Room room = rooms.get(0);
        int minX = room.getMinX();
        int maxX = room.getMaxX();
        int minY = room.getMinY();
        int maxY = room.getMaxY();
        int minZ = room.getMinZ();
        int maxZ = room.getMaxZ();
        for (int i = 1; i < rooms.size(); ++i) {
            if (rooms.get(i).getMinX() < minX) {
                minX = rooms.get(i).getMinX();
            }
            if (rooms.get(i).getMaxX() > maxX) {
                maxX = rooms.get(i).getMaxX();
            }
            if (rooms.get(i).getMinY() < minY) {
                minY = rooms.get(i).getMinY();
            }
            if (rooms.get(i).getMaxY() > maxY) {
                maxY = rooms.get(i).getMaxY();
            }
            if (rooms.get(i).getMinZ() < minZ) {
                minZ = rooms.get(i).getMinZ();
            }
            if (rooms.get(i).getMaxZ() <= maxZ) continue;
            maxZ = rooms.get(i).getMaxZ();
        }
        level.setStartPoint(startPoint);
        level.setStartRoom(startRoom);
        level.setEndRoom(endRoom);
        level.setRooms(rooms);
        level.setEdges(edges);
        level.setPaths(paths);
        level.setWaylines(waylines);
        level.setHallways(hallways);
        level.setMinX(minX);
        level.setMaxX(maxX);
        level.setMinY(minY);
        level.setMaxY(maxY);
        level.setMinZ(minZ);
        level.setMaxZ(maxZ);
        level.setConfig(config);
        return level;
    }

    private void addDoorsToRoom(Hallway hallway) {
        for (Door d : hallway.getDoors()) {
            Door door = new Door(d.getCoords(), d.getRoom(), d.getHallway(), d.getDirection().rotate(Rotate.ROTATE_180));
            d.getRoom().getDoors().add(door);
        }
    }

    protected List<Edge> calculatePaths(Random rand, List<Edge> edges, List<Room> rooms) {
        ArrayList<Edge> paths = new ArrayList<Edge>();
        int[] edgeCount = new int[rooms.size()];
        EdgeWeightedGraph graph = new EdgeWeightedGraph(rooms.size(), edges);
        LazyPrimMST mst = new LazyPrimMST(graph);
        for (Edge e : mst.edges()) {
            if (e.v < rooms.size() && e.w < rooms.size()) {
                Room room1 = rooms.get(e.v);
                Room room2 = rooms.get(e.w);
                paths.add(e);
                int n = room1.getId();
                edgeCount[n] = edgeCount[n] + 1;
                int n2 = room2.getId();
                edgeCount[n2] = edgeCount[n2] + 1;
                continue;
            }
            Dungeons2.log.warn(String.format("Ignored Room: array out-of-bounds: v: %d, w: %d", e.v, e.w));
        }
        int addtionalEdges = (int)((double)edges.size() * 0.25);
        for (int i = 0; i < addtionalEdges; ++i) {
            int pos = rand.nextInt(edges.size());
            Edge e = edges.get(pos);
            Room room1 = rooms.get(e.v);
            Room room2 = rooms.get(e.w);
            if (room1.isEnd() || room2.isEnd() || edgeCount[room1.getId()] >= room1.getDegrees() || edgeCount[room2.getId()] >= room2.getDegrees()) continue;
            paths.add(e);
            int n = room1.getId();
            edgeCount[n] = edgeCount[n] + 1;
            int n3 = room2.getId();
            edgeCount[n3] = edgeCount[n3] + 1;
        }
        return paths;
    }

    @Deprecated
    protected List<Edge> calculatePaths(Random rand, List<Edge> edges, List<Room> rooms, LevelConfig config) {
        ArrayList<Edge> paths = new ArrayList<Edge>();
        int[] edgeCount = new int[rooms.size()];
        EdgeWeightedGraph graph = new EdgeWeightedGraph(rooms.size(), edges);
        LazyPrimMST mst = new LazyPrimMST(graph);
        for (Edge e : mst.edges()) {
            if (e.v < rooms.size() && e.w < rooms.size()) {
                Room room1 = rooms.get(e.v);
                Room room2 = rooms.get(e.w);
                paths.add(e);
                int n = room1.getId();
                edgeCount[n] = edgeCount[n] + 1;
                int n2 = room2.getId();
                edgeCount[n2] = edgeCount[n2] + 1;
                continue;
            }
            Dungeons2.log.warn(String.format("Ignored Room: array out-of-bounds: v: %d, w: %d", e.v, e.w));
        }
        int addtionalEdges = (int)((double)edges.size() * 0.25);
        for (int i = 0; i < addtionalEdges; ++i) {
            int pos = rand.nextInt(edges.size());
            Edge e = edges.get(pos);
            Room room1 = rooms.get(e.v);
            Room room2 = rooms.get(e.w);
            if (room1.isEnd() || room2.isEnd() || edgeCount[room1.getId()] >= room1.getDegrees() || edgeCount[room2.getId()] >= room2.getDegrees()) continue;
            paths.add(e);
            int n = room1.getId();
            edgeCount[n] = edgeCount[n] + 1;
            int n3 = room2.getId();
            edgeCount[n3] = edgeCount[n3] + 1;
        }
        return paths;
    }

    public Hallway buildHallway(Wayline wayline, List<Room> rooms) {
        Direction d;
        int width = 3;
        int depth = 3;
        Waypoint startPoint = null;
        Waypoint endPoint = null;
        ICoords startCoords = null;
        boolean isElbowJoint = false;
        if (wayline.getAlignment() == Alignment.HORIZONTAL) {
            if (wayline.getPoint1().getX() < wayline.getPoint2().getX()) {
                startPoint = wayline.getPoint1();
                endPoint = wayline.getPoint2();
            } else {
                startPoint = wayline.getPoint2();
                endPoint = wayline.getPoint1();
            }
            if (!startPoint.isTerminated() || !endPoint.isTerminated()) {
                isElbowJoint = true;
            }
            if (isElbowJoint) {
                if (!startPoint.isTerminated()) {
                    startPoint.setCoords(startPoint.getCoords().add(-1, 0, 0));
                }
                if (!endPoint.isTerminated()) {
                    endPoint.setCoords(endPoint.getCoords().add(1, 0, 0));
                }
            }
            width = Math.abs(startPoint.getX() - endPoint.getX()) + 1;
            startCoords = startPoint.getCoords();
            startCoords = startCoords.add(0, 0, -1);
        } else {
            if (wayline.getPoint1().getZ() < wayline.getPoint2().getZ()) {
                startPoint = wayline.getPoint1();
                endPoint = wayline.getPoint2();
            } else {
                startPoint = wayline.getPoint2();
                endPoint = wayline.getPoint1();
            }
            if (isElbowJoint) {
                if (!startPoint.isTerminated()) {
                    startPoint.setCoords(startPoint.getCoords().add(0, 0, -1));
                }
                if (!endPoint.isTerminated()) {
                    endPoint.setCoords(endPoint.getCoords().add(0, 0, 1));
                }
            }
            depth = Math.abs(startPoint.getZ() - endPoint.getZ()) + 1;
            startCoords = startPoint.getCoords();
            startCoords = startCoords.add(-1, 0, 0);
        }
        Room room1 = rooms.get(startPoint.getId());
        Room room2 = rooms.get(endPoint.getId());
        startPoint.setCoords(startPoint.getCoords().resetY(room1.getCoords().getY()));
        endPoint.setCoords(endPoint.getCoords().resetY(room2.getCoords().getY()));
        int height = Math.abs(Math.min(room1.getMinY(), room2.getMinY()) - Math.max(room1.getMinY(), room2.getMinY())) + 1 + 3;
        Hallway hallway = (Hallway)new Hallway().setCoords((ICoords)new Coords(startCoords.getX(), startPoint.getCoords().getY(), startCoords.getZ())).setWidth(width).setDepth(depth).setHeight(height).setType(Room.Type.HALLWAY);
        hallway.setAlignment(wayline.getAlignment());
        if (startPoint.isTerminated()) {
            d = this.calculateDirection(hallway, startPoint.getCoords(), room1);
            hallway.getDoors().add(new Door(startPoint.getCoords(), room1, hallway, d));
        }
        if (endPoint.isTerminated()) {
            d = this.calculateDirection(hallway, endPoint.getCoords(), room2);
            hallway.getDoors().add(new Door(endPoint.getCoords(), room2, hallway, d));
        }
        return hallway;
    }

    public Direction calculateDirection(Hallway hw, ICoords coords, Room room) {
        if (hw.getAlignment() == Alignment.HORIZONTAL) {
            if (coords.getX() == hw.getMinX()) {
                return Direction.WEST;
            }
            if (coords.getX() == hw.getMaxX()) {
                return Direction.EAST;
            }
        } else {
            if (coords.getZ() == hw.getMinZ()) {
                return Direction.NORTH;
            }
            if (coords.getZ() == hw.getMaxZ()) {
                return Direction.SOUTH;
            }
        }
        return null;
    }

    protected boolean BFS(int start, int end, List<Room> rooms, List<Edge> edges) {
        LinkedList[] adj = new LinkedList[rooms.size()];
        for (Room r : rooms) {
            adj[r.getId()] = new LinkedList();
        }
        for (Edge e : edges) {
            adj[e.v].add(e.w);
            adj[e.w].add(e.v);
        }
        boolean[] visited = new boolean[rooms.size()];
        LinkedList<Integer> queue = new LinkedList<Integer>();
        visited[start] = true;
        queue.add(start);
        while (queue.size() != 0) {
            int s = (Integer)queue.poll();
            ListIterator i = adj[s].listIterator();
            while (i.hasNext()) {
                int n = (Integer)i.next();
                if (n == end) {
                    return true;
                }
                if (visited[n]) continue;
                visited[n] = true;
                queue.add(n);
            }
        }
        return false;
    }

    protected List<Edge> triangulate(List<Room> rooms) {
        HashMap<String, Room> map = new HashMap<String, Room>();
        Vector<Vector2D> pointSet = new Vector<Vector2D>();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        double[][] matrix = LevelBuilder.getDistanceMatrix(rooms);
        boolean isEndEdgeMet = false;
        int endEdgeCount = 0;
        Collections.sort(rooms, Room.idComparator);
        for (Room room : rooms) {
            ICoords center = room.getCoords();
            map.put(center.getX() + ":" + center.getZ(), room);
            Vector2D v = new Vector2D(center.getX(), center.getZ());
            pointSet.add(v);
        }
        DelaunayTriangulator triangulator = null;
        try {
            triangulator = new DelaunayTriangulator(pointSet);
            triangulator.triangulate();
        }
        catch (NotEnoughPointsException e) {
            Dungeons2.log.warn("Not enough points where provided for triangulation. Level generation aborted.");
            return null;
        }
        catch (Exception e) {
            if (rooms != null) {
                Dungeons2.log.debug("rooms.size=" + rooms.size());
            } else {
                Dungeons2.log.debug("Rooms is NULL!");
            }
            if (pointSet != null) {
                Dungeons2.log.debug("Pointset.size=" + pointSet.size());
            } else {
                Dungeons2.log.debug("Pointset is NULL!");
            }
            Dungeons2.log.error("Unable to triangulate: ", (Throwable)e);
        }
        List<Triangle2D> triangles = triangulator.getTriangles();
        for (Triangle2D triangle : triangles) {
            Room r1 = (Room)map.get((int)triangle.a.x + ":" + (int)triangle.a.y);
            Room r2 = (Room)map.get((int)triangle.b.x + ":" + (int)triangle.b.y);
            Room r3 = (Room)map.get((int)triangle.c.x + ":" + (int)triangle.c.y);
            Edge e = new Edge(r1.getId(), r2.getId(), matrix[r1.getId()][r2.getId()]);
            if (!r1.isEnd() && !r2.isEnd()) {
                edges.add(e);
            } else if (!(r1.isStart() || r2.isStart() || isEndEdgeMet)) {
                Room end;
                edges.add(e);
                Room room = end = r1.isEnd() ? r1 : r2;
                if (++endEdgeCount >= end.getDegrees()) {
                    isEndEdgeMet = true;
                }
            }
            e = new Edge(r2.getId(), r3.getId(), matrix[r2.getId()][r3.getId()]);
            if (!r2.isEnd() && !r3.isEnd()) {
                edges.add(e);
            } else if (!(r1.isStart() || r2.isStart() || isEndEdgeMet)) {
                edges.add(e);
                isEndEdgeMet = true;
            }
            e = new Edge(r1.getId(), r3.getId(), matrix[r1.getId()][r3.getId()]);
            if (!r1.isEnd() && !r3.isEnd()) {
                edges.add(e);
                continue;
            }
            if (r1.isStart() || r2.isStart() || isEndEdgeMet) continue;
            edges.add(e);
            isEndEdgeMet = true;
        }
        return edges;
    }

    protected static double[][] getDistanceMatrix(List<Room> rooms) {
        double[][] matrix = new double[rooms.size()][rooms.size()];
        for (int i = 0; i < rooms.size(); ++i) {
            Room room = rooms.get(i);
            for (int j = 0; j < rooms.size(); ++j) {
                double dist;
                Room node = rooms.get(j);
                if (room == node) {
                    matrix[i][j] = 0.0;
                    continue;
                }
                if (matrix[i][j] != 0.0) continue;
                matrix[i][j] = dist = room.getCenter().getDistance(node.getCenter());
                matrix[j][i] = dist;
            }
        }
        return matrix;
    }

    protected List<Wayline> calculateWaylines(Random rand, List<Edge> paths, List<Room> rooms) {
        List<Wayline> resolvedWaylines = null;
        ArrayList<Wayline> waylines = new ArrayList<Wayline>();
        for (Edge path : paths) {
            Wayline wayline;
            Room room1 = rooms.get(path.v);
            Room room2 = rooms.get(path.w);
            ICoords midpoint = room1.getCenter().add(room2.getCenter());
            midpoint = new Coords(midpoint.getX() / 2, midpoint.getY() / 2, midpoint.getZ() / 2);
            HashMap<Integer, Room> minXMap = new HashMap<Integer, Room>(5);
            minXMap.put(new Integer(room1.getMinX()), room1);
            minXMap.put(new Integer(room2.getMinX()), room2);
            HashMap<Integer, Room> maxXMap = new HashMap<Integer, Room>(5);
            maxXMap.put(new Integer(room1.getMaxX()), room1);
            maxXMap.put(new Integer(room2.getMaxX()), room2);
            HashMap<Integer, Room> minZMap = new HashMap<Integer, Room>(5);
            minZMap.put(new Integer(room1.getMinZ()), room1);
            minZMap.put(new Integer(room2.getMinZ()), room2);
            HashMap<Integer, Room> maxZMap = new HashMap<Integer, Room>(5);
            maxZMap.put(new Integer(room1.getMaxZ()), room1);
            maxZMap.put(new Integer(room2.getMaxZ()), room2);
            int innerMaxX = Math.min(room1.getMaxX(), room2.getMaxX());
            int innerMinX = Math.max(room1.getMinX(), room2.getMinX());
            int innerMaxZ = Math.min(room1.getMaxZ(), room2.getMaxZ());
            int innerMinZ = Math.max(room1.getMinZ(), room2.getMinZ());
            Stack<Wayline> stack = new Stack<Wayline>();
            if (room1.getMaxZ() <= room2.getMaxZ() && room1.getMaxZ() > room2.getMinZ() + 1 || room2.getMaxZ() <= room1.getMaxZ() && room2.getMaxZ() > room1.getMinZ() + 1 || room1.getMinZ() >= room2.getMinZ() && room1.getMinZ() < room2.getMaxZ() - 1 || room2.getMinZ() >= room1.getMinZ() && room2.getMinZ() < room1.getMaxZ() - 1) {
                int z = (innerMaxZ + innerMinZ) / 2;
                wayline = new Wayline(new Waypoint(((Room)minXMap.get(innerMinX)).getId(), innerMinX - 1, 0, z), new Waypoint(((Room)maxXMap.get(innerMaxX)).getId(), innerMaxX + 1, 0, z), Alignment.HORIZONTAL);
                if (wayline.getPoint1().getCoords().equals((Object)wayline.getPoint2().getCoords())) {
                    Dungeons2.log.trace("Wayline's points are equal !!: " + wayline);
                }
                stack.add(wayline);
                resolvedWaylines = this.resolveWaylineRoomIntersections(rooms, stack);
                if (resolvedWaylines == EMPTY_WAYLINES) {
                    return resolvedWaylines;
                }
                waylines.addAll(resolvedWaylines);
                continue;
            }
            if (room1.getMaxX() <= room2.getMaxX() && room1.getMaxX() > room2.getMinX() + 1 || room2.getMaxX() <= room1.getMaxX() && room2.getMaxX() > room1.getMinX() + 1 || room1.getMinX() > room2.getMinX() && room1.getMinX() <= room2.getMaxX() - 1 || room2.getMinX() > room1.getMinX() && room2.getMinX() <= room1.getMaxX() - 1) {
                int x2 = (innerMaxX + innerMinX) / 2;
                wayline = new Wayline(new Waypoint(((Room)minZMap.get(innerMinZ)).getId(), x2, 0, innerMinZ - 1), new Waypoint(((Room)maxZMap.get(innerMaxZ)).getId(), x2, 0, innerMaxZ + 1), Alignment.VERTICAL);
                if (wayline.getPoint1().getCoords().equals((Object)wayline.getPoint2().getCoords())) {
                    Dungeons2.log.trace("Wayline's points are equal !!: " + wayline);
                }
                stack.add(wayline);
                waylines.addAll(this.resolveWaylineRoomIntersections(rooms, stack));
                continue;
            }
            ICoords r1c = room1.getCenter();
            wayline = null;
            wayline = room2.getCenter().getX() > room1.getCenter().getX() ? new Wayline(new Waypoint(room1.getId(), room1.getMaxX() + 1, 0, r1c.getZ()), new Waypoint(room2.getId(), room2.getCenter().getX(), 0, r1c.getZ(), false)) : new Wayline(new Waypoint(room1.getId(), room1.getMinX() - 1, 0, r1c.getZ()), new Waypoint(room2.getId(), room2.getCenter().getX(), 0, r1c.getZ(), false));
            if (wayline.getPoint1().getCoords().equals((Object)wayline.getPoint2().getCoords())) {
                Dungeons2.log.warn("Wayline's points are equal !!: " + wayline);
            }
            stack.add(wayline);
            List<Wayline> segmented = this.resolveWaylineRoomIntersections(rooms, stack);
            waylines.addAll(segmented);
            Optional<Wayline> arm1 = segmented.stream().filter(x -> !x.getPoint1().isTerminated() || !x.getPoint2().isTerminated()).findFirst();
            wayline = room2.getCenter().getZ() > room1.getCenter().getZ() ? new Wayline(new Waypoint(room1.getId(), room2.getCenter().getX(), 0, r1c.getZ(), false), new Waypoint(room2.getId(), room2.getCenter().getX(), 0, room2.getMinZ() - 1)) : new Wayline(new Waypoint(room1.getId(), room2.getCenter().getX(), 0, r1c.getZ(), false), new Waypoint(room2.getId(), room2.getCenter().getX(), 0, room2.getMaxZ() + 1));
            if (wayline.getPoint1().getCoords().equals((Object)wayline.getPoint2().getCoords())) {
                Dungeons2.log.warn("Wayline's points are equal !!: " + wayline);
            }
            stack.add(wayline);
            segmented = this.resolveWaylineRoomIntersections(rooms, stack);
            waylines.addAll(segmented);
            Optional<Wayline> arm2 = segmented.stream().filter(x -> !x.getPoint1().isTerminated() || !x.getPoint2().isTerminated()).findFirst();
            if (!arm1.isPresent() || !arm2.isPresent() || arm1.get() == null || arm2.get() == null) continue;
            arm1.get().setWayline(arm2.get());
            arm2.get().setWayline(arm1.get());
        }
        return waylines;
    }

    protected List<Wayline> resolveWaylineRoomIntersections(List<Room> rooms, Stack<Wayline> stack) {
        List<Object> waylines = new ArrayList();
        ArrayList<Wayline> result = new ArrayList<Wayline>();
        int failSafeLimit = rooms.size() * 3;
        int failSafeCount = 0;
        do {
            ++failSafeCount;
            Wayline wayline = stack.pop();
            for (Room room : rooms) {
                if (wayline == null) {
                    Dungeons2.log.trace("Wayline is null on room:" + room.getId());
                    break;
                }
                AxisAlignedBB bb1 = new AxisAlignedBB((double)wayline.getPoint1().getX(), 0.0, (double)wayline.getPoint1().getZ(), (double)wayline.getPoint2().getX(), 1.0, (double)wayline.getPoint2().getZ());
                if (!(wayline.getPoint1().getCoords().getDistance(wayline.getPoint2().getCoords()) > 0.0) || !bb1.func_72326_a(room.getXZBoundingBox())) continue;
                Dungeons2.log.trace(String.format("Room [%d] intersection with wayline %s", room.getId(), wayline));
                waylines = this.resolveWaylineRoomIntersection(room, wayline);
                if (waylines == null || waylines.size() <= 0) break;
                stack.addAll(waylines);
                wayline = null;
                break;
            }
            if (wayline != null) {
                result.add(wayline);
            }
            if (failSafeCount < failSafeLimit) continue;
            return EMPTY_WAYLINES;
        } while (!stack.isEmpty());
        return result;
    }

    protected List<Wayline> resolveWaylineRoomIntersection(Room room, Wayline wayline) {
        ArrayList<Wayline> waylines = new ArrayList<Wayline>();
        Wayline remainderWayline1 = null;
        Wayline remainderWayline2 = null;
        boolean isHorz = false;
        isHorz = wayline.getAlignment() == Alignment.HORIZONTAL;
        Waypoint p1 = wayline.getPoint1();
        Waypoint p2 = wayline.getPoint2();
        Waypoint terminatedPoint = null;
        if (isHorz) {
            if (wayline.getPoint1().getX() >= room.getMinX() && wayline.getPoint1().getX() <= room.getMaxX()) {
                terminatedPoint = wayline.getPoint1();
                p1 = wayline.getPoint2();
                p2 = wayline.getPoint1();
            } else if (wayline.getPoint2().getX() >= room.getMinX() && wayline.getPoint2().getX() <= room.getMaxX()) {
                terminatedPoint = wayline.getPoint2();
                p1 = wayline.getPoint1();
                p2 = wayline.getPoint2();
            }
            if (p1.getX() < p2.getX()) {
                remainderWayline1 = new Wayline(p1, new Waypoint(room.getId(), room.getMinX(), p1.getY(), p1.getZ()), Alignment.HORIZONTAL);
                if (terminatedPoint == null) {
                    remainderWayline2 = new Wayline(new Waypoint(room.getId(), room.getMaxX() + 1, p2.getY(), p2.getZ(), p2.isTerminated()), p2, Alignment.HORIZONTAL);
                }
            } else {
                remainderWayline1 = new Wayline(p1, new Waypoint(room.getId(), room.getMaxX() + 1, p1.getY(), p1.getZ()), Alignment.HORIZONTAL);
                if (terminatedPoint == null) {
                    remainderWayline2 = new Wayline(new Waypoint(room.getId(), room.getMinX(), p2.getY(), p2.getZ(), p2.isTerminated()), p2, Alignment.HORIZONTAL);
                }
            }
        } else {
            if (wayline.getPoint1().getZ() >= room.getMinZ() && wayline.getPoint1().getZ() <= room.getMaxZ()) {
                terminatedPoint = wayline.getPoint1();
                p1 = wayline.getPoint2();
                p2 = wayline.getPoint1();
            } else if (wayline.getPoint2().getZ() >= room.getMinZ() && wayline.getPoint2().getZ() <= room.getMaxZ()) {
                terminatedPoint = wayline.getPoint2();
                p1 = wayline.getPoint1();
                p2 = wayline.getPoint2();
            }
            if (p1.getZ() > p2.getZ()) {
                remainderWayline1 = new Wayline(p1, new Waypoint(room.getId(), p1.getX(), p1.getY(), room.getMaxZ() + 1), Alignment.VERTICAL);
                if (terminatedPoint == null) {
                    remainderWayline2 = new Wayline(new Waypoint(room.getId(), p2.getX(), p2.getY(), room.getMinZ(), p2.isTerminated()), p2, Alignment.VERTICAL);
                }
            } else {
                remainderWayline1 = new Wayline(p1, new Waypoint(room.getId(), p1.getX(), p1.getY(), room.getMinZ()), Alignment.VERTICAL);
                if (terminatedPoint == null) {
                    remainderWayline2 = new Wayline(new Waypoint(room.getId(), p2.getX(), p2.getY(), room.getMaxZ() + 1, p2.isTerminated()), p2, Alignment.VERTICAL);
                }
            }
        }
        if (remainderWayline1 != null) {
            if (remainderWayline1.getPoint1().getCoords().equals((Object)wayline.getPoint2().getCoords())) {
                Dungeons2.log.trace("Remainder Wayline1's points are equal !!: " + remainderWayline1);
            }
            waylines.add(remainderWayline1);
        }
        if (remainderWayline2 != null) {
            if (remainderWayline2.getPoint1().getCoords().equals((Object)wayline.getPoint2().getCoords())) {
                Dungeons2.log.trace("Remainder Wayline2's points are equal !!: " + remainderWayline2);
            }
            waylines.add(remainderWayline2);
        }
        return waylines;
    }

    @Deprecated
    protected List<Wayline> resolveWaylineRoomIntersections(List<Room> rooms, Wayline wayline) {
        ArrayList<Wayline> waylines = new ArrayList<Wayline>();
        for (Room room : rooms) {
            Dungeons2.log.trace(String.format("Checking against room [%d]", room.getId()));
            if (wayline == null) {
                Dungeons2.log.debug("Wayline is null on room:" + room.getId());
                break;
            }
            AxisAlignedBB bb1 = new AxisAlignedBB((double)wayline.getPoint1().getX(), 0.0, (double)wayline.getPoint1().getZ(), (double)wayline.getPoint2().getX(), 1.0, (double)wayline.getPoint2().getZ());
            if (!bb1.func_72326_a(room.getBoundingBox())) continue;
            Dungeons2.log.trace(String.format("Room [%d] intersection with wayline %s", room.getId(), wayline));
            wayline = this.resolveWaylineRoomIntersection(room, wayline, waylines);
        }
        if (wayline != null) {
            waylines.add(wayline);
        }
        return waylines;
    }

    @Deprecated
    protected Wayline resolveWaylineRoomIntersection(Room room, Wayline wayline, List<Wayline> waylines) {
        Wayline newWayline = null;
        Wayline remainderWayline = null;
        boolean isHorz = false;
        if (wayline.getPoint1().getZ() == wayline.getPoint2().getZ()) {
            isHorz = true;
        }
        Waypoint p1 = wayline.getPoint1();
        Waypoint p2 = wayline.getPoint2();
        Waypoint terminatedPoint = null;
        if (isHorz) {
            if (wayline.getPoint1().getX() >= room.getMinX() && wayline.getPoint1().getX() <= room.getMaxX()) {
                terminatedPoint = wayline.getPoint1();
                p1 = wayline.getPoint2();
                p2 = wayline.getPoint1();
            } else if (wayline.getPoint2().getX() >= room.getMinX() && wayline.getPoint2().getX() <= room.getMaxX()) {
                terminatedPoint = wayline.getPoint2();
                p1 = wayline.getPoint1();
                p2 = wayline.getPoint2();
            }
            if (p1.getX() < p2.getX()) {
                newWayline = new Wayline(p1, new Waypoint(room.getId(), room.getMinX(), p1.getY(), p1.getZ()));
                if (terminatedPoint == null) {
                    remainderWayline = new Wayline(new Waypoint(room.getId(), room.getMaxX(), p2.getY(), p2.getZ()), p2);
                }
            } else {
                newWayline = new Wayline(p1, new Waypoint(room.getId(), room.getMaxX(), p1.getY(), p1.getZ()));
                if (terminatedPoint == null) {
                    remainderWayline = new Wayline(new Waypoint(room.getId(), room.getMinX(), p2.getY(), p2.getZ()), p2);
                }
            }
        } else {
            if (wayline.getPoint1().getZ() >= room.getMinZ() && wayline.getPoint1().getZ() <= room.getMaxZ()) {
                terminatedPoint = wayline.getPoint1();
                p1 = wayline.getPoint2();
                p2 = wayline.getPoint1();
            } else if (wayline.getPoint2().getZ() >= room.getMinZ() && wayline.getPoint2().getZ() <= room.getMaxZ()) {
                terminatedPoint = wayline.getPoint2();
                p1 = wayline.getPoint1();
                p2 = wayline.getPoint2();
            }
            if (p1.getZ() > p2.getZ()) {
                newWayline = new Wayline(p1, new Waypoint(room.getId(), p1.getX(), p1.getY(), room.getMaxZ()));
                if (terminatedPoint == null) {
                    remainderWayline = new Wayline(new Waypoint(room.getId(), p2.getX(), p2.getY(), room.getMinZ()), p2);
                }
            } else {
                newWayline = new Wayline(p1, new Waypoint(room.getId(), p1.getX(), p1.getY(), room.getMinZ()));
                if (terminatedPoint == null) {
                    remainderWayline = new Wayline(new Waypoint(room.getId(), p2.getX(), p2.getY(), room.getMaxZ()), p2);
                }
            }
        }
        waylines.add(newWayline);
        return remainderWayline;
    }

    public static void printMatrix(double[][] m) {
        try {
            int rows = m.length;
            int columns = m[0].length;
            String str = "|\t";
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < columns; ++j) {
                    str = str + (int)m[i][j] + "\t";
                }
                System.out.println(str + "|");
                str = "|\t";
            }
        }
        catch (Exception e) {
            System.out.println("Matrix is empty!!");
        }
    }

    protected List<Room> selectValidRooms(World world, Random rand, List<Room> rooms, ILevelConfig config) {
        ArrayList<Room> met = new ArrayList<Room>();
        int roomId = 0;
        AxisAlignedBB dbb = this.getDungeonBuilder().getBoundary();
        AxisAlignedBB lbb = this.getBoundary();
        for (Room room : rooms) {
            if (room.isObstacle()) continue;
            if (room.isAnchor()) {
                room.setId(roomId++);
                met.add(room);
                continue;
            }
            boolean isValid = false;
            AxisAlignedBB rbb = room.getXZBoundingBox();
            if (rbb.field_72340_a >= lbb.field_72340_a && rbb.field_72336_d <= lbb.field_72336_d && rbb.field_72339_c >= lbb.field_72339_c && rbb.field_72334_f <= lbb.field_72334_f) {
                isValid = true;
            } else {
                Dungeons2.log.debug("Removing room for being outside level bounds -> {}", (Object)room);
                System.out.println("Removing room for being outside level bounds -> " + room);
                this.incrementLossToValidation(1);
            }
            if (isValid && rbb.field_72340_a >= dbb.field_72340_a && rbb.field_72336_d <= dbb.field_72336_d && rbb.field_72339_c >= dbb.field_72339_c && rbb.field_72334_f <= dbb.field_72334_f) {
                isValid = true;
            } else {
                Dungeons2.log.debug("Removing room for being outside dungeon bounds -> {}", (Object)room.getId());
                System.out.println("Removing room for being outside dungeon bounds -> " + room.getId());
                this.incrementLossToValidation(1);
            }
            if (isValid && this.getDungeonBuilder().getConfig().isMinecraftConstraints()) {
                isValid = false;
                if (this.isRoomInLoadedChunks(world, room)) {
                    isValid = true;
                } else {
                    Dungeons2.log.debug("Removing room for residing in unloaded chunk -> {}", (Object)room.getId());
                    this.incrementLossToValidation(1);
                }
            }
            if (isValid) {
                isValid = this.validateRoomConstraints(world, room, config);
            } else {
                Dungeons2.log.debug("Removing room for failing constraints -> {}", (Object)room);
                this.incrementLossToValidation(1);
            }
            if (isValid) {
                room.setId(roomId++);
                met.add(room);
                continue;
            }
            Dungeons2.log.debug("Removing room for failing constraints -> {}", (Object)room);
            this.incrementLossToValidation(1);
        }
        return met;
    }

    public boolean isRoomInLoadedChunks(World world, Room room) {
        boolean isValid = false;
        ChunkPos[] cp = room.getCornersInChunkPos();
        if (world.func_190526_b(cp[0].field_77276_a, cp[0].field_77275_b) && world.func_190526_b(cp[1].field_77276_a, cp[1].field_77275_b) && world.func_190526_b(cp[2].field_77276_a, cp[2].field_77275_b) && world.func_190526_b(cp[3].field_77276_a, cp[3].field_77275_b)) {
            isValid = true;
        }
        return isValid;
    }

    protected boolean validateRoomConstraints(World world, Room room, ILevelConfig config) {
        if (room == null || room.isReject()) {
            return false;
        }
        if (!this.getDungeonBuilder().getConfig().isMinecraftConstraints()) {
            return true;
        }
        if (room.getCoords().getY() <= this.getDungeonBuilder().getConfig().getBottomLimit()) {
            if (Dungeons2.log.isDebugEnabled()) {
                Dungeons2.log.debug("Room bottom [{}] is below min y constraint [{}]", (Object)room.getCoords().getY(), (Object)this.getDungeonBuilder().getConfig().getBottomLimit());
            }
            return false;
        }
        if (room.getCoords().getY() + room.getHeight() > this.getDungeonBuilder().getConfig().getTopLimit()) {
            if (Dungeons2.log.isDebugEnabled()) {
                Dungeons2.log.debug(String.format("Room top [%d] is above max y constraint [%d]", room.getCoords().getY() + room.getHeight(), this.getDungeonBuilder().getConfig().getTopLimit()));
            }
            return false;
        }
        double percentSolid = WorldInfo.getSolidBasePercent((World)world, (ICoords)room.getCoords(), (int)room.getWidth(), (int)room.getDepth());
        int surfaceRoomDepth = WorldInfo.getDifferenceWithSurface((World)world, (ICoords)room.getCenter());
        if (surfaceRoomDepth == -255) {
            Dungeons2.log.debug("Unable to locate the surface position.");
            return false;
        }
        if (room.getCoords().getY() + room.getHeight() > world.func_181545_F()) {
            Dungeons2.log.trace("Room is above sea level -> {}", (Object)room.getCenter());
            if (surfaceRoomDepth < -3) {
                Dungeons2.log.debug("Room rejected due to exposure -> {}", (Object)room.getCenter());
                return false;
            }
            if (percentSolid < 50.0) {
                Dungeons2.log.debug("Room has less than 50 % base @ " + room.getCenter());
                return false;
            }
        } else {
            if (percentSolid < 20.0) {
                Dungeons2.log.debug("Room has less than 20 % base @ " + room.getCenter());
                return false;
            }
            if (percentSolid < 50.0) {
                Dungeons2.log.debug("Room has less than 50 % base @ " + room.getCenter());
                return false;
            }
        }
        return true;
    }

    protected Room buildStartRoom(World world, Random rand, AxisAlignedBB field, ICoords startPoint, ILevelConfig config) {
        Room startRoom = new Room().setStart(true).setAnchor(true).setType(Room.Type.LADDER);
        startRoom = this.randomizeDimensions(rand, startRoom, config);
        startRoom.setWidth(Math.max(7, startRoom.getWidth()));
        startRoom.setDepth(Math.max(7, startRoom.getDepth()));
        if (startRoom.getWidth() % 2 == 0) {
            startRoom.setWidth(startRoom.getWidth() + 1);
        }
        if (startRoom.getDepth() % 2 == 0) {
            startRoom.setDepth(startRoom.getDepth() + 1);
        }
        startRoom.centerOn(startPoint);
        startRoom.setDistance(0.0);
        startRoom.setDirection(Direction.getByCode((Integer)RandomHelper.randomInt((int)2, (int)5)));
        if (!this.validateRoomConstraints(world, startRoom, config)) {
            Dungeons2.log.debug("Start Room failed room constraints @ " + startRoom.getCenter());
            if (Dungeons2.log.isWarnEnabled()) {
                Dungeons2.log.warn(String.format("Start Room has invalid Minecraft world room conditions: %s", startRoom.toString()));
            }
            return EMPTY_ROOM;
        }
        return startRoom;
    }

    protected Room buildEndRoom(World world, Random rand, AxisAlignedBB field, ICoords startPoint, List<Room> plannedRooms, ILevelConfig config) {
        Room endRoom = this.buildPlannedRoom(world, rand, field, startPoint, plannedRooms, config).setEnd(true).setAnchor(true).setType(Room.Type.LADDER);
        endRoom.setWidth(Math.max(7, endRoom.getWidth()));
        endRoom.setDepth(Math.max(7, endRoom.getDepth()));
        if (endRoom.getWidth() % 2 == 0) {
            endRoom.setWidth(endRoom.getWidth() + 1);
        }
        if (endRoom.getDepth() % 2 == 0) {
            endRoom.setDepth(endRoom.getDepth() + 1);
        }
        return endRoom;
    }

    protected Room buildPlannedRoom(World world, Random rand, AxisAlignedBB field, ICoords startPoint, List<Room> plannedRooms, ILevelConfig config) {
        Room plannedRoom = new Room();
        boolean checkRooms = true;
        int endCheckIndex = 0;
        block0: do {
            plannedRoom = this.randomizeRoom(rand, plannedRoom, field, startPoint, config);
            Dungeons2.log.debug("New Planned Room:" + plannedRoom);
            if (++endCheckIndex > 10) {
                Dungeons2.log.warn("Unable to position Planned Room that meets positional criteria.");
                return EMPTY_ROOM;
            }
            for (Room room : plannedRooms) {
                if (!room.getXZBoundingBox().func_72326_a(plannedRoom.getXZBoundingBox())) continue;
                Dungeons2.log.debug("New Planned room intersects with planned list room.");
                continue block0;
            }
            if (!this.validateRoomConstraints(world, plannedRoom, config)) break;
            checkRooms = false;
        } while (checkRooms);
        return plannedRoom;
    }

    protected Room buildBossRoom(World world, Random rand, AxisAlignedBB field, ICoords startPoint, List<Room> predefinedRooms, ILevelConfig config) {
        int BOSS_ROOM_MIN_XZ = 10;
        int BOSS_ROOM_MIN_Y = 10;
        Room bossRoom = this.buildEndRoom(world, rand, field, startPoint, predefinedRooms, config).setType(Room.Type.BOSS).setDegrees(1);
        bossRoom.setWidth(Math.max(10, bossRoom.getWidth()));
        bossRoom.setDepth(Math.max(10, bossRoom.getDepth()));
        bossRoom.setHeight(Math.max(Math.min(10, config.getHeight().getMaxInt()), bossRoom.getHeight()));
        return bossRoom;
    }

    @Deprecated
    protected Room buildEntranceRoom(World world, Random rand, ICoords surfaceCoords, Room startRoom, LevelConfig levelConfig) {
        Room entranceRoom = new Room(startRoom);
        entranceRoom.setAnchor(true).setType(Room.Type.ENTRANCE);
        entranceRoom.setCoords(entranceRoom.getCoords().resetY(surfaceCoords.getY()));
        return null;
    }

    public LevelConfig getConfig() {
        return this.config;
    }

    public void setConfig(LevelConfig config) {
        this.config = config;
    }

    public String toString() {
        return "LevelBuilder []";
    }

    protected AxisAlignedBB getBoundary() {
        return this.field;
    }

    protected void setBoundary(AxisAlignedBB field) {
        this.field = field;
    }

    protected AxisAlignedBB getRoomBoundary() {
        return this.roomBoundary;
    }

    protected void setRoomBoundary(AxisAlignedBB roomBoundary) {
        this.roomBoundary = roomBoundary;
    }

    public void incrementLossToDistanceBuffering(int i) {
        this.roomLossToDistanceBuffering += i;
    }

    public void incrementLossToValidation(int i) {
        this.roomLossToValidation += i;
    }

    protected int getRoomLossToDistanceBuffering() {
        return this.roomLossToDistanceBuffering;
    }

    protected void setRoomLossToDistanceBuffering(int roomLossToDistanceBuffering) {
        this.roomLossToDistanceBuffering = roomLossToDistanceBuffering;
    }

    protected int getRoomLossToValidation() {
        return this.roomLossToValidation;
    }

    protected void setRoomLossToValidation(int roomLossToValidation) {
        this.roomLossToValidation = roomLossToValidation;
    }

    public IDungeonBuilder getDungeonBuilder() {
        return this.dungeonBuilder;
    }

    public void setDungeonBuilder(IDungeonBuilder dungeonBuilder) {
        this.dungeonBuilder = dungeonBuilder;
    }
}

