/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.generator.strategy;

import com.google.common.collect.Multimap;
import com.someguyssoftware.dungeons2.generator.AbstractRoomGenerationStrategy;
import com.someguyssoftware.dungeons2.generator.Arrangement;
import com.someguyssoftware.dungeons2.generator.blockprovider.IDungeonsBlockProvider;
import com.someguyssoftware.dungeons2.model.Hallway;
import com.someguyssoftware.dungeons2.model.LevelConfig;
import com.someguyssoftware.dungeons2.model.Room;
import com.someguyssoftware.dungeons2.style.DesignElement;
import com.someguyssoftware.dungeons2.style.StyleSheet;
import com.someguyssoftware.dungeons2.style.Theme;
import com.someguyssoftware.dungeonsengine.config.ILevelConfig;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class StandardHallwayGenerationStrategy
extends AbstractRoomGenerationStrategy {
    private List<Room> rooms;
    private List<Hallway> hallways;

    public StandardHallwayGenerationStrategy(IDungeonsBlockProvider blockProvider, List<Room> rooms, List<Hallway> hallways) {
        super(blockProvider);
        this.setRooms(rooms);
        this.setHallways(hallways);
    }

    @Override
    public void generate(World world, Random random, Room room, Theme theme, StyleSheet styleSheet, ILevelConfig config) {
        Hallway hallway = (Hallway)room;
        IBlockState blockState = null;
        HashMap<ICoords, Arrangement> postProcessMap = new HashMap<ICoords, Arrangement>();
        Multimap<DesignElement, ICoords> blueprint = room.getFloorMap();
        ArrayList<Room> intersectRooms = new ArrayList<Room>();
        for (Room otherRoom : this.getRooms()) {
            if (!hallway.getBoundingBox().func_72326_a(otherRoom.getBoundingBox())) continue;
            intersectRooms.add(otherRoom);
        }
        for (int y = 0; y < room.getHeight(); ++y) {
            for (int z = 0; z < room.getDepth(); ++z) {
                for (int x = 0; x < room.getWidth(); ++x) {
                    Coords indexCoords = new Coords(x, y, z);
                    ICoords worldCoords = room.getCoords().add((ICoords)indexCoords);
                    Arrangement arrangement = this.getBlockProvider().getArrangement(worldCoords, room, room.getLayout());
                    if (this.isPostProcessed(arrangement, worldCoords, postProcessMap) || (blockState = this.getBlockProvider().getBlockState(random, worldCoords, room, arrangement, theme, styleSheet, config)) == IDungeonsBlockProvider.NULL_BLOCK) continue;
                    AxisAlignedBB box = new AxisAlignedBB(worldCoords.toPos());
                    boolean buildBlock = true;
                    if (arrangement.getElement() != DesignElement.AIR) {
                        AxisAlignedBB bb;
                        AxisAlignedBB bb2;
                        AxisAlignedBB bb1 = hallway.getDoors().size() > 0 && hallway.getDoors().get(0) != null ? hallway.getDoors().get(0).getRoom().getBoundingBox() : null;
                        AxisAlignedBB axisAlignedBB = bb2 = hallway.getDoors().size() > 1 && hallway.getDoors().get(1) != null ? hallway.getDoors().get(1).getRoom().getBoundingBox() : null;
                        if (bb1 != null && box.func_72326_a(bb1) || bb2 != null && box.func_72326_a(bb2)) {
                            buildBlock = false;
                        }
                        if (buildBlock) {
                            for (Room room2 : intersectRooms) {
                                bb = room2.getBoundingBox();
                                if (!box.func_72326_a(bb)) continue;
                                buildBlock = false;
                                break;
                            }
                        }
                        if (buildBlock) {
                            for (Room room3 : this.getHallways()) {
                                bb = room3.getBoundingBox();
                                if (!box.func_72326_a(bb)) continue;
                                buildBlock = false;
                                break;
                            }
                        }
                    }
                    if (blockState == null || !buildBlock || blockState == IDungeonsBlockProvider.NULL_BLOCK) continue;
                    world.func_180501_a(worldCoords.toPos(), blockState, 3);
                }
            }
        }
        this.postProcess(world, random, postProcessMap, room.getLayout(), theme, styleSheet, config);
    }

    @Override
    @Deprecated
    public void generate(World world, Random random, Room room, Theme theme, StyleSheet styleSheet, LevelConfig config) {
        Hallway hallway = (Hallway)room;
        IBlockState blockState = null;
        HashMap<ICoords, Arrangement> postProcessMap = new HashMap<ICoords, Arrangement>();
        Multimap<DesignElement, ICoords> blueprint = room.getFloorMap();
        ArrayList<Room> intersectRooms = new ArrayList<Room>();
        for (Room otherRoom : this.getRooms()) {
            if (!hallway.getBoundingBox().func_72326_a(otherRoom.getBoundingBox())) continue;
            intersectRooms.add(otherRoom);
        }
        for (int y = 0; y < room.getHeight(); ++y) {
            for (int z = 0; z < room.getDepth(); ++z) {
                for (int x = 0; x < room.getWidth(); ++x) {
                    Coords indexCoords = new Coords(x, y, z);
                    ICoords worldCoords = room.getCoords().add((ICoords)indexCoords);
                    Arrangement arrangement = this.getBlockProvider().getArrangement(worldCoords, room, room.getLayout());
                    if (this.isPostProcessed(arrangement, worldCoords, postProcessMap) || (blockState = this.getBlockProvider().getBlockState(random, worldCoords, room, arrangement, theme, styleSheet, config)) == IDungeonsBlockProvider.NULL_BLOCK) continue;
                    AxisAlignedBB box = new AxisAlignedBB(worldCoords.toPos());
                    boolean buildBlock = true;
                    if (arrangement.getElement() != DesignElement.AIR) {
                        AxisAlignedBB bb;
                        AxisAlignedBB bb2;
                        AxisAlignedBB bb1 = hallway.getDoors().size() > 0 && hallway.getDoors().get(0) != null ? hallway.getDoors().get(0).getRoom().getBoundingBox() : null;
                        AxisAlignedBB axisAlignedBB = bb2 = hallway.getDoors().size() > 1 && hallway.getDoors().get(1) != null ? hallway.getDoors().get(1).getRoom().getBoundingBox() : null;
                        if (bb1 != null && box.func_72326_a(bb1) || bb2 != null && box.func_72326_a(bb2)) {
                            buildBlock = false;
                        }
                        if (buildBlock) {
                            for (Room room2 : intersectRooms) {
                                bb = room2.getBoundingBox();
                                if (!box.func_72326_a(bb)) continue;
                                buildBlock = false;
                                break;
                            }
                        }
                        if (buildBlock) {
                            for (Room room3 : this.getHallways()) {
                                bb = room3.getBoundingBox();
                                if (!box.func_72326_a(bb)) continue;
                                buildBlock = false;
                                break;
                            }
                        }
                    }
                    if (blockState == null || !buildBlock || blockState == IDungeonsBlockProvider.NULL_BLOCK) continue;
                    world.func_180501_a(worldCoords.toPos(), blockState, 3);
                }
            }
        }
        this.postProcess(world, random, postProcessMap, room.getLayout(), theme, styleSheet, config);
    }

    public List<Hallway> getHallways() {
        return this.hallways;
    }

    public void setHallways(List<Hallway> hallways) {
        this.hallways = hallways;
    }

    public List<Room> getRooms() {
        return this.rooms;
    }

    public void setRooms(List<Room> rooms) {
        this.rooms = rooms;
    }
}

