/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.model;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.someguyssoftware.dungeons2.model.Door;
import com.someguyssoftware.dungeons2.style.DesignElement;
import com.someguyssoftware.dungeons2.style.Layout;
import com.someguyssoftware.gottschcore.enums.Direction;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.positional.Intersect;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;

public class Room {
    public static final int MIN_DEPTH = 5;
    public static final int MIN_WIDTH = 5;
    public static final int MIN_HEIGHT = 4;
    private int id;
    private String name;
    private Type type;
    private ICoords coords;
    private int depth;
    private int width;
    private int height;
    private Direction direction;
    private double distance;
    private boolean anchor;
    private boolean obstacle;
    private boolean reject;
    private boolean start;
    private boolean end;
    private int degrees;
    private Layout layout;
    private boolean crown;
    private boolean trim;
    private boolean pilaster;
    private boolean pillar;
    private boolean gutter;
    private boolean grate;
    private boolean coffer;
    private boolean wallBase;
    private boolean wallCapital;
    private boolean cornice;
    private boolean plinth;
    private boolean column;
    private boolean crenellation;
    private boolean parapet;
    private boolean merlon;
    private Multimap<DesignElement, ICoords> floorMap;
    private List<Door> doors;
    public static Comparator<Room> idComparator = new Comparator<Room>(){

        @Override
        public int compare(Room p1, Room p2) {
            if (p1.getId() > p2.getId()) {
                return 1;
            }
            return -1;
        }
    };
    public static Comparator<Room> distanceComparator = new Comparator<Room>(){

        @Override
        public int compare(Room p1, Room p2) {
            if (p1.getDistance() > p2.getDistance()) {
                return 1;
            }
            return -1;
        }
    };

    public Room() {
        this.setId(RandomHelper.randomInt((int)-5000, (int)5000));
        this.coords = new Coords(0, 0, 0);
        this.setType(Type.GENERAL);
        this.setDirection(Direction.SOUTH);
    }

    public Room(int id) {
        this();
        this.setId(id);
    }

    public Room(String name) {
        this();
        this.setName(name);
    }

    public Room(Room room) {
        if (room != null) {
            this.setId(room.getId());
            this.setAnchor(room.isAnchor());
            this.setCoords((ICoords)new Coords(room.getCoords()));
            this.setDepth(room.getDepth());
            this.setDistance(room.getDistance());
            this.setHeight(room.getHeight());
            this.setWidth(room.getWidth());
            this.setStart(room.isStart());
            this.setEnd(room.isEnd());
            this.setReject(room.isReject());
            this.setType(room.getType());
            this.setDirection(room.getDirection());
            this.setDegrees(room.getDegrees());
            this.setName(room.getName());
            this.setObstacle(room.isObstacle());
            for (Door door : room.getDoors()) {
                Door d = new Door();
                d.setCoords(door.getCoords());
                d.setRoom(this);
                this.getDoors().add(d);
            }
        }
    }

    public Room copy() {
        return new Room(this);
    }

    public void centerOn(ICoords coords) {
        this.setCoords((ICoords)new Coords(coords.getX() - this.getWidth() / 2, coords.getY(), coords.getZ() - this.getDepth() / 2));
    }

    public ChunkPos[] getCornersInChunkPos() {
        ChunkPos[] chunkPos = new ChunkPos[]{new ChunkPos(new BlockPos(this.getMinX(), 0, this.getMinZ())), new ChunkPos(new BlockPos(this.getMinX(), 0, this.getMaxZ())), new ChunkPos(new BlockPos(this.getMaxX(), 0, this.getMinZ())), new ChunkPos(new BlockPos(this.getMaxX(), 0, this.getMaxZ()))};
        return chunkPos;
    }

    public AxisAlignedBB getBoundingBox() {
        BlockPos bp1 = this.getCoords().toPos();
        BlockPos bp2 = this.getCoords().add(this.getWidth(), this.getHeight(), this.getDepth()).toPos();
        AxisAlignedBB bb = new AxisAlignedBB(bp1, bp2);
        return bb;
    }

    public AxisAlignedBB getXZBoundingBox() {
        BlockPos bp1 = new BlockPos(this.getCoords().getX(), 0, this.getCoords().getZ());
        BlockPos bp2 = this.getCoords().add(this.getWidth(), 1, this.getDepth()).toPos();
        AxisAlignedBB bb = new AxisAlignedBB(bp1, bp2);
        return bb;
    }

    public static EnumFacing getHorizontal(int direction) {
        return EnumFacing.field_176754_o[MathHelper.func_76130_a((int)(direction % EnumFacing.field_176754_o.length))];
    }

    public int getMinX() {
        return this.getCoords().getX();
    }

    public int getMaxX() {
        return this.getCoords().getX() + this.getWidth() - 1;
    }

    public int getMinY() {
        return this.getCoords().getY();
    }

    public int getMaxY() {
        return this.getCoords().getY() + this.getHeight() - 1;
    }

    public int getMinZ() {
        return this.getCoords().getZ();
    }

    public int getMaxZ() {
        return this.getCoords().getZ() + this.getDepth() - 1;
    }

    public ICoords getCenter() {
        int x = this.getCoords().getX() + (this.getWidth() - 1) / 2;
        int y = this.getCoords().getY() + (this.getHeight() - 1) / 2;
        int z = this.getCoords().getZ() + (this.getDepth() - 1) / 2;
        Coords coords = new Coords(x, y, z);
        return coords;
    }

    public ICoords getXZCenter() {
        int x = this.getCoords().getX() + (this.getWidth() - 1) / 2;
        int y = this.getCoords().getY();
        int z = this.getCoords().getZ() + (this.getDepth() - 1) / 2;
        Coords coords = new Coords(x, y, z);
        return coords;
    }

    public ICoords getTopCenter() {
        int x = this.getCoords().getX() + (this.getWidth() - 1) / 2;
        int y = this.getCoords().getY() + this.getHeight();
        int z = this.getCoords().getZ() + (this.getDepth() - 1) / 2;
        Coords coords = new Coords(x, y, z);
        return coords;
    }

    public Intersect getIntersect(Room room) {
        return Intersect.getIntersect((AxisAlignedBB)this.getBoundingBox(), (AxisAlignedBB)room.getBoundingBox());
    }

    public Room addXZForce(double angle, double force) {
        double xForce = Math.sin(angle) * force;
        double zForce = Math.cos(angle) * force;
        Room room = new Room(this);
        room.setCoords(room.getCoords().add((int)xForce, 0, (int)zForce));
        return room;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ICoords getCoords() {
        return this.coords;
    }

    public Room setCoords(ICoords coords) {
        this.coords = coords;
        return this;
    }

    public int getDepth() {
        return this.depth;
    }

    public Room setDepth(int depth) {
        this.depth = depth;
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public Room setWidth(int width) {
        this.width = width;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public Room setHeight(int height) {
        this.height = height;
        return this;
    }

    public boolean isAnchor() {
        return this.anchor;
    }

    public Room setAnchor(boolean anchor) {
        this.anchor = anchor;
        return this;
    }

    public String toString() {
        return "Room [\n\tid=" + this.id + ",\n\tname=" + this.name + ",\n\tcoords=" + this.coords + ",\n\tcenter=" + this.getCenter() + ",\n\tdepth=" + this.depth + ",\n\twidth=" + this.width + ",\n\theight=" + this.height + ",\n\tanchor=" + this.anchor + ",\n\tdistance=" + this.distance + ",\n\tdirection=" + this.direction + ",\n\treject=" + this.reject + ",\n\tlayout=" + this.layout + ",\n\tstart=" + this.start + "\n\tend=" + this.end + ",\n\tboundingBox" + this.getBoundingBox() + "\n]";
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isReject() {
        return this.reject;
    }

    public void setReject(boolean reject) {
        this.reject = reject;
    }

    public boolean isStart() {
        return this.start;
    }

    public Room setStart(boolean start) {
        this.start = start;
        return this;
    }

    public boolean isEnd() {
        return this.end;
    }

    public Room setEnd(boolean end) {
        this.end = end;
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public Room setType(Type type) {
        this.type = type;
        return this;
    }

    public int getDegrees() {
        return this.degrees;
    }

    public Room setDegrees(int degrees) {
        this.degrees = degrees;
        return this;
    }

    public boolean isObstacle() {
        return this.obstacle;
    }

    public void setObstacle(boolean obstacle) {
        this.obstacle = obstacle;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Room setDirection(Direction direction) {
        this.direction = direction;
        return this;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public Room setLayout(Layout layout) {
        this.layout = layout;
        return this;
    }

    public Multimap<DesignElement, ICoords> getFloorMap() {
        if (this.floorMap == null) {
            this.floorMap = ArrayListMultimap.create();
        }
        return this.floorMap;
    }

    public void setFloorMap(Multimap<DesignElement, ICoords> floorMap) {
        this.floorMap = floorMap;
    }

    public boolean hasTrim() {
        return this.trim;
    }

    public void setHasTrim(boolean trim) {
        this.trim = trim;
    }

    public boolean hasCornice() {
        return this.cornice;
    }

    public void setHasCornice(boolean cornice) {
        this.cornice = cornice;
    }

    public boolean hasPlinth() {
        return this.plinth;
    }

    public void setHasPlinth(boolean plinth) {
        this.plinth = plinth;
    }

    public boolean hasPillar() {
        return this.pillar;
    }

    public void setHasPillar(boolean pillar) {
        this.pillar = pillar;
    }

    public boolean hasColumn() {
        return this.column;
    }

    public void setHasColumn(boolean column) {
        this.column = column;
    }

    public boolean hasCrown() {
        return this.crown;
    }

    public void setHasCrown(boolean crown) {
        this.crown = crown;
    }

    public boolean hasCrenellation() {
        return this.crenellation;
    }

    public void setHasCrenellation(boolean crenellation) {
        this.crenellation = crenellation;
    }

    public boolean hasParapet() {
        return this.parapet;
    }

    public void setHasParapet(boolean parapet) {
        this.parapet = parapet;
    }

    public boolean hasMerlon() {
        return this.merlon;
    }

    public void setHasMerlon(boolean merlon) {
        this.merlon = merlon;
    }

    public boolean hasPilaster() {
        return this.pilaster;
    }

    public void setHasPilaster(boolean pilaster) {
        this.pilaster = pilaster;
    }

    public boolean hasGutter() {
        return this.gutter;
    }

    public void setHasGutter(boolean gutter) {
        this.gutter = gutter;
    }

    public boolean hasGrate() {
        return this.grate;
    }

    public void setHasGrate(boolean grate) {
        this.grate = grate;
    }

    public boolean hasCoffer() {
        return this.coffer;
    }

    public void setHasCoffer(boolean coffer) {
        this.coffer = coffer;
    }

    public void setCoffer(boolean coffer) {
        this.setHasCoffer(coffer);
    }

    public boolean hasWallBase() {
        return this.wallBase;
    }

    public void setHasWallBase(boolean base) {
        this.wallBase = base;
    }

    public void setWallBase(boolean base) {
        this.setHasWallBase(base);
    }

    public boolean hasWallCapital() {
        return this.wallCapital;
    }

    public void setHasWallCapital(boolean capital) {
        this.wallCapital = capital;
    }

    public void setWallCapital(boolean capital) {
        this.setHasWallCapital(capital);
    }

    public List<Door> getDoors() {
        if (this.doors == null) {
            this.doors = new ArrayList<Door>(5);
        }
        return this.doors;
    }

    public void setDoors(List<Door> doors) {
        this.doors = doors;
    }

    public ICoords getBottomCenter() {
        int x = this.getCoords().getX() + (this.getWidth() - 1) / 2;
        int y = this.getCoords().getY();
        int z = this.getCoords().getZ() + (this.getDepth() - 1) / 2;
        Coords coords = new Coords(x, y, z);
        return coords;
    }

    public static enum Type {
        GENERAL("general"),
        LADDER("ladder"),
        ENTRANCE("entrance"),
        EXIT("exit"),
        TREASURE("treasure"),
        BOSS("boss"),
        HALLWAY("hallway");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

