/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.style;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeons2.generator.DungeonGenerator;
import com.someguyssoftware.dungeons2.model.Hallway;
import com.someguyssoftware.dungeons2.model.Room;
import com.someguyssoftware.dungeons2.style.DesignElement;
import com.someguyssoftware.dungeons2.style.Layout;
import com.someguyssoftware.dungeons2.style.StyleSheet;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class LayoutAssigner {
    private StyleSheet styleSheet;
    private Multimap<String, Layout> map = ArrayListMultimap.create();

    public LayoutAssigner(StyleSheet styleSheet) {
        this.styleSheet = styleSheet;
        this.loadStyleSheet(styleSheet);
    }

    public void loadStyleSheet(StyleSheet styleSheet) {
        this.map.clear();
        for (Map.Entry<String, Layout> e : styleSheet.getLayouts().entrySet()) {
            Layout layout = e.getValue();
            if (layout.getCategory() != null && !layout.getCategory().equals("")) {
                this.map.put((Object)layout.getCategory().toLowerCase(), (Object)layout);
                continue;
            }
            this.map.put((Object)Layout.Type.ROOM.getName().toLowerCase(), (Object)layout);
        }
    }

    public Layout assign(Random random, Room room, String layoutName) {
        Layout layout = this.getStyleSheet().getLayouts().get(layoutName);
        if (layout == null) {
            Dungeons2.log.debug("Getting default layout from default stylesheet.");
            layout = DungeonGenerator.getDefaultStyleSheet().getLayouts().get("default");
        }
        this.assignLayoutToRoom(random, layout, room);
        return layout;
    }

    public Layout assign(Random random, Room room) {
        List layouts = null;
        Layout layout = null;
        if (room.getType() == Room.Type.GENERAL) {
            layouts = (List)this.map.get((Object)Layout.Type.ROOM.getName().toLowerCase());
        } else if (room.isStart() && room.getType() != Room.Type.ENTRANCE) {
            layouts = (List)this.map.get((Object)Layout.Type.START.getName().toLowerCase());
        } else if (room.isEnd() && room.getType() != Room.Type.BOSS) {
            layouts = (List)this.map.get((Object)Layout.Type.END.getName().toLowerCase());
        } else {
            if (room.getType() == Room.Type.HALLWAY || room instanceof Hallway) {
                layouts = (List)this.map.get((Object)Layout.Type.HALLWAY.getName().toLowerCase());
                layout = (Layout)layouts.get(random.nextInt(layouts.size()));
                room.setLayout(layout);
                return layout;
            }
            layouts = room.getType() == Room.Type.ENTRANCE ? (List)this.map.get((Object)Layout.Type.ENTRANCE.getName().toLowerCase()) : (room.getType() == Room.Type.TREASURE ? (List)this.map.get((Object)Layout.Type.TREASURE.getName().toLowerCase()) : (room.getType() == Room.Type.BOSS ? (List)this.map.get((Object)Layout.Type.BOSS.getName().toLowerCase()) : (List)this.map.get((Object)Layout.Type.ROOM.getName().toLowerCase())));
        }
        layout = layouts != null && layouts.size() > 0 ? (Layout)layouts.get(random.nextInt(layouts.size())) : DungeonGenerator.getDefaultStyleSheet().getLayouts().get("default");
        this.assignLayoutToRoom(random, layout, room);
        return layout;
    }

    private void assignLayoutToRoom(Random random, Layout layout, Room room) {
        if (layout.isUseAll()) {
            Dungeons2.log.debug("Using ALL Frames!");
            if (this.getStyleSheet().hasFrame(layout, DesignElement.CROWN)) {
                room.setHasCrown(true);
            }
            if (this.getStyleSheet().hasFrame(layout, DesignElement.TRIM)) {
                room.setHasTrim(true);
            }
            if (this.getStyleSheet().hasFrame(layout, DesignElement.PILLAR)) {
                room.setHasPillar(true);
            }
            if (this.getStyleSheet().hasFrame(layout, DesignElement.PILASTER) && room.getWidth() >= 5 && room.getDepth() >= 5) {
                room.setHasPilaster(true);
            }
            if (this.getStyleSheet().hasFrame(layout, DesignElement.GUTTER)) {
                room.setHasGutter(true);
            }
            if (this.getStyleSheet().hasFrame(layout, DesignElement.GRATE)) {
                room.setHasGrate(true);
            }
            if (this.getStyleSheet().hasFrame(layout, DesignElement.COFFERED_CROSSBEAM) || this.getStyleSheet().hasFrame(layout, DesignElement.COFFERED_MIDBEAM)) {
                room.setHasCoffer(true);
            }
            if (this.getStyleSheet().hasFrame(layout, DesignElement.WALL_BASE)) {
                room.setHasWallBase(true);
            }
            if (this.getStyleSheet().hasFrame(layout, DesignElement.WALL_CAPITAL)) {
                room.setHasWallCapital(true);
            }
            if (room.getType() == Room.Type.ENTRANCE) {
                if (this.getStyleSheet().hasFrame(layout, DesignElement.COLUMN)) {
                    room.setHasColumn(true);
                }
                if (this.getStyleSheet().hasFrame(layout, DesignElement.CORNICE)) {
                    room.setHasCornice(true);
                }
                if (this.getStyleSheet().hasFrame(layout, DesignElement.CRENELLATION) && room.getWidth() >= 7 && room.getDepth() >= 7) {
                    room.setHasCrenellation(true);
                    room.setHasMerlon(true);
                    room.setHasParapet(true);
                } else if (this.getStyleSheet().hasFrame(layout, DesignElement.MERLON)) {
                    room.setHasMerlon(true);
                } else if (this.getStyleSheet().hasFrame(layout, DesignElement.PARAPET)) {
                    room.setHasParapet(true);
                }
                if (this.getStyleSheet().hasFrame(layout, DesignElement.PLINTH)) {
                    room.setHasPlinth(true);
                }
            }
        } else {
            if (this.getStyleSheet().hasFrame(layout, DesignElement.CROWN) && random.nextInt(100) < 25) {
                room.setHasCrown(true);
            }
            if (this.getStyleSheet().hasFrame(layout, DesignElement.TRIM) && random.nextInt(100) < 20) {
                room.setHasTrim(true);
            }
            if (this.getStyleSheet().hasFrame(layout, DesignElement.PILLAR) && random.nextInt(100) < 25) {
                room.setHasPillar(true);
            }
            if (this.getStyleSheet().hasFrame(layout, DesignElement.PILASTER) && room.getWidth() >= 5 && room.getDepth() >= 5 && random.nextInt(100) < 25) {
                room.setHasPilaster(true);
            }
            if (this.getStyleSheet().hasFrame(layout, DesignElement.GUTTER) && random.nextInt(100) < 25) {
                room.setHasGutter(true);
            }
            if (this.getStyleSheet().hasFrame(layout, DesignElement.GRATE) && random.nextInt(100) < 15) {
                room.setHasGrate(true);
            }
            if ((this.getStyleSheet().hasFrame(layout, DesignElement.COFFERED_CROSSBEAM) || this.getStyleSheet().hasFrame(layout, DesignElement.COFFERED_MIDBEAM)) && random.nextInt(100) < 20) {
                room.setHasCoffer(true);
            }
            if (this.getStyleSheet().hasFrame(layout, DesignElement.WALL_BASE) && random.nextInt(100) < 25) {
                room.setHasWallBase(true);
            }
            if (this.getStyleSheet().hasFrame(layout, DesignElement.WALL_CAPITAL) && random.nextInt(100) < 25) {
                room.setHasWallCapital(true);
            }
            if (room.getType() == Room.Type.ENTRANCE) {
                if (room.getWidth() >= 7 && this.getStyleSheet().hasFrame(layout, DesignElement.PILASTER) && random.nextInt(100) < 25) {
                    room.setHasPilaster(true);
                } else {
                    room.setHasPilaster(false);
                }
                room.setHasPillar(false);
                if (this.getStyleSheet().hasFrame(layout, DesignElement.COLUMN) && random.nextInt(100) < 50) {
                    room.setHasColumn(true);
                }
                if (this.getStyleSheet().hasFrame(layout, DesignElement.CORNICE) && random.nextInt(100) < 60) {
                    room.setHasCornice(true);
                }
                if (this.getStyleSheet().hasFrame(layout, DesignElement.CRENELLATION) && room.getWidth() >= 7 && room.getDepth() >= 7 && random.nextInt(100) < 50) {
                    room.setHasCrenellation(true);
                    room.setHasMerlon(true);
                    room.setHasParapet(true);
                } else if (this.getStyleSheet().hasFrame(layout, DesignElement.MERLON) && random.nextInt(100) < 60) {
                    room.setHasMerlon(true);
                } else if (this.getStyleSheet().hasFrame(layout, DesignElement.PARAPET) && random.nextInt(100) < 70) {
                    room.setHasParapet(true);
                }
                if (this.getStyleSheet().hasFrame(layout, DesignElement.PLINTH) && random.nextInt(100) < 50) {
                    room.setHasPlinth(true);
                }
            }
        }
        room.setLayout(layout);
    }

    public StyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    public void setStyleSheet(StyleSheet styleSheet) {
        this.styleSheet = styleSheet;
    }
}

