/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.style;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeons2.config.ModConfig;
import com.someguyssoftware.dungeons2.style.Alias;
import com.someguyssoftware.dungeons2.style.Frame;
import com.someguyssoftware.dungeons2.style.Layout;
import com.someguyssoftware.dungeons2.style.Style;
import com.someguyssoftware.dungeons2.style.StyleSheet;
import com.someguyssoftware.dungeons2.style.Theme;
import com.someguyssoftware.gottschcore.json.JSMin;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class StyleSheetLoader {
    public static final String BUILT_IN_STYLE_SHEET_PATH = "/stylesheet.json";
    public static final String BUILT_IN_STYLE_SHEET_SUB_FOLDER = "/styleSheets/";
    private static final StyleSheet EMPTY_SHEET = new StyleSheet();

    public static StyleSheet load() throws Exception {
        StyleSheet styleSheet = null;
        InputStream is = ((Object)((Object)Dungeons2.instance)).getClass().getResourceAsStream(BUILT_IN_STYLE_SHEET_PATH);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JSMin minifier = new JSMin(is, (OutputStream)out);
        minifier.jsmin();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        InputStreamReader reader = new InputStreamReader(in);
        JsonReader jsonReader = new JsonReader((Reader)reader);
        GsonBuilder gsonBuilder = new GsonBuilder();
        Type styleType = new TypeToken<Map<String, Style>>(){}.getType();
        Type layoutType = new TypeToken<Map<String, Layout>>(){}.getType();
        Type themeType = new TypeToken<Map<String, Theme>>(){}.getType();
        gsonBuilder.registerTypeAdapter(styleType, (Object)new StyleDeserializer());
        gsonBuilder.registerTypeAdapter(layoutType, (Object)new LayoutDeserializer());
        gsonBuilder.registerTypeAdapter(themeType, (Object)new ThemeDeserializer());
        Gson gson = gsonBuilder.create();
        try {
            styleSheet = (StyleSheet)gson.fromJson(jsonReader, StyleSheet.class);
        }
        catch (JsonIOException | JsonSyntaxException e) {
            throw new Exception("Unable to load style sheet.");
        }
        finally {
            try {
                jsonReader.close();
            }
            catch (IOException e) {
                Dungeons2.log.warn("Unable to close JSON Reader when reading built-in style sheet.");
            }
        }
        return styleSheet;
    }

    public static StyleSheet loadAll() throws Exception {
        Path defaultSheetPath = Paths.get(ModConfig.dungeonsFolder, "styleSheet.json").toAbsolutePath();
        Dungeons2.log.debug("Sheets Folder:" + defaultSheetPath.toString());
        StyleSheet sheet = StyleSheetLoader.load(defaultSheetPath.toString());
        if (sheet == null || sheet == EMPTY_SHEET) {
            Dungeons2.log.warn("Unable to locate default style sheet at location " + defaultSheetPath.toString());
            return EMPTY_SHEET;
        }
        Files.newDirectoryStream(Paths.get(ModConfig.dungeonsFolder, BUILT_IN_STYLE_SHEET_SUB_FOLDER), path -> path.toString().endsWith(".json")).forEach(x -> {
            try {
                StyleSheet s = StyleSheetLoader.load(x.toString());
                if (sheet.getThemes() != null && s.getThemes() != null) {
                    for (Map.Entry<String, Theme> entry : s.getThemes().entrySet()) {
                        if (sheet.getThemes().containsKey(entry.getKey())) {
                            Theme theme = sheet.getThemes().get(entry.getKey());
                            theme.getAliases().putAll(entry.getValue().getAliases());
                            continue;
                        }
                        sheet.getThemes().put(entry.getKey(), entry.getValue());
                    }
                }
                if (sheet.getStyles() != null && s.getStyles() != null) {
                    sheet.getStyles().putAll(s.getStyles());
                }
                if (sheet.getLayouts() != null && s.getLayouts() != null) {
                    sheet.getLayouts().putAll(s.getLayouts());
                }
            }
            catch (Exception e) {
                Dungeons2.log.error("Unable to load additional style sheet " + x.toString(), (Throwable)e);
            }
        });
        return sheet;
    }

    public static StyleSheet load(String filePath) throws Exception {
        StyleSheet styleSheet = null;
        Path path = Paths.get(filePath, new String[0]).toAbsolutePath();
        if (Files.notExists(path, new LinkOption[0])) {
            Dungeons2.log.warn("Unable to locate style sheet using path: " + filePath);
            return EMPTY_SHEET;
        }
        FileInputStream is = new FileInputStream(path.toString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JSMin minifier = new JSMin((InputStream)is, (OutputStream)out);
        minifier.jsmin();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        InputStreamReader reader = new InputStreamReader(in);
        JsonReader jsonReader = new JsonReader((Reader)reader);
        GsonBuilder gsonBuilder = new GsonBuilder();
        Type styleType = new TypeToken<Map<String, Style>>(){}.getType();
        Type layoutType = new TypeToken<Map<String, Layout>>(){}.getType();
        Type themeType = new TypeToken<Map<String, Theme>>(){}.getType();
        gsonBuilder.registerTypeAdapter(styleType, (Object)new StyleDeserializer());
        gsonBuilder.registerTypeAdapter(layoutType, (Object)new LayoutDeserializer());
        gsonBuilder.registerTypeAdapter(themeType, (Object)new ThemeDeserializer());
        Gson gson = gsonBuilder.create();
        try {
            styleSheet = (StyleSheet)gson.fromJson(jsonReader, StyleSheet.class);
            Dungeons2.log.debug("Loaded styleSheet:" + styleSheet);
        }
        catch (JsonIOException | JsonSyntaxException e) {
            throw new Exception("Unable to load style sheet.", e);
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (IOException e) {
                Dungeons2.log.warn("Unable to close JSON Reader when reading built-in style sheet.");
            }
        }
        return styleSheet;
    }

    public static boolean hasStyleSheet(String filePath) {
        Path path = Paths.get(filePath, new String[0]).toAbsolutePath();
        return Files.exists(path, new LinkOption[0]);
    }

    public static boolean hasStyleSheet(Path path) {
        return Files.exists(path.toAbsolutePath(), new LinkOption[0]);
    }

    public static void exposeStyleSheet(String filePath) {
        Path path = Paths.get(filePath, new String[0]).toAbsolutePath();
        if (Files.notExists(path, new LinkOption[0])) {
            InputStream is = ((Object)((Object)Dungeons2.instance)).getClass().getResourceAsStream(BUILT_IN_STYLE_SHEET_PATH);
            try (FileOutputStream fos = new FileOutputStream(path.toFile());){
                int r;
                byte[] buf = new byte[2048];
                while ((r = is.read(buf)) != -1) {
                    fos.write(buf, 0, r);
                }
            }
            catch (IOException e) {
                Dungeons2.log.error("Error exposing stylesheet resource to file system.");
            }
        }
    }

    public static class LayoutDeserializer
    implements JsonDeserializer<Map<String, Layout>> {
        public Map<String, Layout> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            HashMap<String, Layout> map = new HashMap<String, Layout>();
            JsonObject jsonObj = json.getAsJsonObject();
            for (Map.Entry entry : jsonObj.entrySet()) {
                JsonObject element = ((JsonElement)entry.getValue()).getAsJsonObject();
                Layout layout = new Layout();
                layout.setName((String)entry.getKey());
                if (element.get("ref") != null) {
                    layout.setRef(element.get("ref").getAsString());
                }
                if (element.get("category") != null) {
                    layout.setCategory(element.get("category").getAsString());
                }
                if (element.get("useAll") != null) {
                    layout.setUseAll(element.get("useAll").getAsBoolean());
                }
                if (element.get("__comment") != null) {
                    layout.setComment(element.get("__comment").getAsString());
                }
                JsonObject frameMap = element.get("frames").getAsJsonObject();
                HashMap<String, Frame> frames = new HashMap<String, Frame>();
                for (Map.Entry frameEntry : frameMap.entrySet()) {
                    JsonObject frameElement = ((JsonElement)frameEntry.getValue()).getAsJsonObject();
                    Frame frame = (Frame)context.deserialize((JsonElement)frameElement, Frame.class);
                    frames.put((String)frameEntry.getKey(), frame);
                }
                layout.setFrames(frames);
                map.put(layout.getName(), layout);
            }
            return map;
        }
    }

    public static class StyleDeserializer
    implements JsonDeserializer<Map<String, Style>> {
        public Map<String, Style> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            HashMap<String, Style> map = new HashMap<String, Style>();
            JsonObject jsonObj = json.getAsJsonObject();
            for (Map.Entry entry : jsonObj.entrySet()) {
                JsonObject element = ((JsonElement)entry.getValue()).getAsJsonObject();
                Style style = new Style();
                style.setName((String)entry.getKey());
                style.setCategory(element.get("category").getAsString());
                style.setBlock(element.get("block").getAsString());
                style.setDecay(element.get("decay").getAsDouble());
                JsonArray array = element.getAsJsonArray("decayBlocks");
                ArrayList<String> blocks = new ArrayList<String>();
                for (JsonElement e : array) {
                    blocks.add(e.getAsString());
                }
                style.setDecayBlocks(blocks);
                map.put((String)entry.getKey(), style);
            }
            return map;
        }
    }

    public static class ThemeDeserializer
    implements JsonDeserializer<Map<String, Theme>> {
        public Map<String, Theme> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            HashMap<String, Theme> map = new HashMap<String, Theme>();
            JsonObject jsonObj = json.getAsJsonObject();
            for (Map.Entry entry : jsonObj.entrySet()) {
                JsonObject element = ((JsonElement)entry.getValue()).getAsJsonObject();
                Theme theme = new Theme();
                theme.setName((String)entry.getKey());
                JsonObject aliasMap = element.get("aliases").getAsJsonObject();
                HashMap<String, Alias> aliases = new HashMap<String, Alias>();
                for (Map.Entry aliasEntry : aliasMap.entrySet()) {
                    JsonObject aliasElement = ((JsonElement)aliasEntry.getValue()).getAsJsonObject();
                    Alias alias = new Alias();
                    alias.setAlias((String)aliasEntry.getKey());
                    alias.setStyle(aliasElement.get("style").getAsString());
                    aliases.put(alias.getAlias(), alias);
                }
                theme.setAliases(aliases);
                map.put((String)entry.getKey(), theme);
            }
            return map;
        }
    }
}

