/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeonsengine.config;

import com.someguyssoftware.dungeonsengine.config.IChestConfig;
import com.someguyssoftware.dungeonsengine.config.LootTableMethod;
import com.someguyssoftware.gottschcore.Quantity;
import com.someguyssoftware.gottschcore.enums.Rarity;
import java.util.ArrayList;
import java.util.List;

public class ChestConfig
implements IChestConfig {
    private List<Rarity> rarity;
    private Quantity probability;
    private LootTableMethod lootTableMethod;
    private String lootTableName;

    public ChestConfig() {
    }

    public ChestConfig(IChestConfig config) {
        this.setLootTableName(config.getLootTableName());
        this.setLootTableMethod(config.getLootTableMethod());
        this.setProbability(new Quantity(config.getProbability()));
        this.setRarity(new ArrayList<Rarity>(config.getRarity()));
    }

    @Override
    public IChestConfig copy() {
        return new ChestConfig(this);
    }

    @Override
    public IChestConfig apply(IChestConfig config) {
        if (this.getLootTableMethod() == null) {
            this.setLootTableMethod(config.getLootTableMethod());
        }
        if (this.getLootTableName() == null) {
            this.setLootTableName(config.getLootTableName());
        }
        if (this.getProbability() == null) {
            this.setProbability(new Quantity(config.getProbability()));
        }
        if (this.getRarity() == null) {
            this.setRarity(new ArrayList<Rarity>(config.getRarity()));
        }
        return this;
    }

    @Override
    public List<Rarity> getRarity() {
        return this.rarity;
    }

    @Override
    public void setRarity(List<Rarity> rarity) {
        this.rarity = rarity;
    }

    @Override
    public Quantity getProbability() {
        return this.probability;
    }

    @Override
    public void setProbability(Quantity probability) {
        this.probability = probability;
    }

    @Override
    public LootTableMethod getLootTableMethod() {
        return this.lootTableMethod;
    }

    @Override
    public void setLootTableMethod(LootTableMethod lootTableType) {
        this.lootTableMethod = lootTableType;
    }

    @Override
    public String getLootTableName() {
        return this.lootTableName;
    }

    @Override
    public void setLootTableName(String lootTableName) {
        this.lootTableName = lootTableName;
    }

    public String toString() {
        return "ChestConfig [rarity=" + this.rarity + ", probability=" + this.probability + ", lootTableMethod=" + (Object)((Object)this.lootTableMethod) + ", lootTableName=" + this.lootTableName + "]";
    }
}

