/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeonsengine.style;

import com.someguyssoftware.dungeonsengine.enums.Face;
import com.someguyssoftware.dungeonsengine.style.ArchitecturalElement;
import com.someguyssoftware.dungeonsengine.style.IArchitecturalElement;
import com.someguyssoftware.gottschcore.enums.IEnum;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class Elements {
    public static IArchitecturalElement NONE = new ArchitecturalElement("none", -1.0, -1.0);
    public static IArchitecturalElement AIR = new ArchitecturalElement("air", 0.0, 0.0);
    public static IArchitecturalElement SURFACE_AIR = new ArchitecturalElement("surface_air", 0.0, 0.0, AIR);
    public static IArchitecturalElement FLOOR_AIR = new ArchitecturalElement("floor_air", 0.0, 0.0, SURFACE_AIR);
    public static IArchitecturalElement WALL_AIR = new ArchitecturalElement("wall_air", 0.0, 0.0, SURFACE_AIR);
    public static IArchitecturalElement CEILING_AIR = new ArchitecturalElement("ceiling_air", 0.0, 0.0, SURFACE_AIR);
    public static IArchitecturalElement FLOOR = new ArchitecturalElement("floor", 100.0, 50.0);
    public static IArchitecturalElement FLOOR_ALT = new ArchitecturalElement("floor_alt", 100.0, 50.0);
    public static IArchitecturalElement WALL = new ArchitecturalElement("wall", 100.0, 50.0);
    public static IArchitecturalElement WALL_BASE = new ArchitecturalElement("wall_base", 100.0, 50.0, WALL);
    public static IArchitecturalElement WALL_CAPITAL = new ArchitecturalElement("wall_capital", 100.0, 50.0, WALL);
    public static IArchitecturalElement CEILING = new ArchitecturalElement("ceiling", 100.0, 50.0);
    public static IArchitecturalElement FACADE = new ArchitecturalElement("facade", 100.0, 0.0);
    public static IArchitecturalElement FACADE_SUPPORT = new ArchitecturalElement("facade_support", 100.0, 100.0, WALL);
    public static IArchitecturalElement BASE = new ArchitecturalElement("base", 100.0, 0.0).setFace(Face.EXTERIOR);
    public static IArchitecturalElement COLUMN = new ArchitecturalElement("column", 100.0, 100.0).setFace(Face.EXTERIOR);
    public static IArchitecturalElement CAPITAL = new ArchitecturalElement("capital", 100.0, 0.0).setFace(Face.EXTERIOR);
    public static IArchitecturalElement TRIM = new ArchitecturalElement("trim", 0.0, 0.0, FACADE).setFace(Face.INTERIOR);
    public static IArchitecturalElement CROWN = new ArchitecturalElement("crown", 100.0, 0.0, FACADE).setFace(Face.INTERIOR);
    public static IArchitecturalElement CORNICE = new ArchitecturalElement("cornice", 100.0, 0.0, FACADE).setFace(Face.EXTERIOR);
    public static IArchitecturalElement PLINTH = new ArchitecturalElement("plinth", 0.0, 0.0, FACADE).setFace(Face.EXTERIOR);
    public static IArchitecturalElement PILASTER = new ArchitecturalElement("pilaster", 100.0, 100.0).setFace(Face.INTERIOR);
    public static IArchitecturalElement PILASTER_BASE = new ArchitecturalElement("pilaster_base", 100.0, 0.0).setFace(Face.INTERIOR);
    public static IArchitecturalElement PILASTER_CAPITAL = new ArchitecturalElement("pilaster_capital", 100.0, 0.0).setFace(Face.INTERIOR);
    public static IArchitecturalElement PILLAR = new ArchitecturalElement("pillar", 100.0, 100.0).setFace(Face.INTERIOR);
    public static IArchitecturalElement PILLAR_BASE = new ArchitecturalElement("pillar_base", 100.0, 0.0).setFace(Face.INTERIOR);
    public static IArchitecturalElement PILLAR_CAPITAL = new ArchitecturalElement("pillar_capital", 100.0, 0.0).setFace(Face.INTERIOR);
    public static IArchitecturalElement CRENELLATION = new ArchitecturalElement("crenellation", 100.0, 50.0).setFace(Face.EXTERIOR);
    public static IArchitecturalElement PARAPET = new ArchitecturalElement("parapet", 100.0, 50.0).setFace(Face.EXTERIOR);
    public static IArchitecturalElement MERLON = new ArchitecturalElement("merlon", 100.0, 50.0).setFace(Face.EXTERIOR);
    public static IArchitecturalElement COFFER = new ArchitecturalElement("coffer", 100.0, 100.0).setFace(Face.INTERIOR);
    public static IArchitecturalElement COFFERED_MIDBEAM = new ArchitecturalElement("coffered_midbeam", 100.0, 100.0).setFace(Face.INTERIOR);
    public static IArchitecturalElement COFFERED_CROSSBEAM = new ArchitecturalElement("coffered_crossbeam", 100.0, 100.0).setFace(Face.EXTERIOR);
    public static IArchitecturalElement LADDER = new ArchitecturalElement("ladder", 100.0, 0.0);
    public static IArchitecturalElement LADDER_PILLAR = new ArchitecturalElement("ladder_pillar", 100.0, 100.0);
    public static IArchitecturalElement GUTTER = new ArchitecturalElement("gutter", 100.0, 50.0);
    public static IArchitecturalElement GRATE = new ArchitecturalElement("grate", 100.0, 50.0);
    public static IArchitecturalElement WINDOW = new ArchitecturalElement("window", 100.0, 0.0);
    public static IArchitecturalElement SIGN = new ArchitecturalElement("sign", 0.0, 0.0);

    public static IArchitecturalElement getElement(String name) {
        return ElementsEnum.valueOf(name.toUpperCase()).getElement();
    }

    public static enum ElementsEnum implements IEnum
    {
        NONE(-1, NONE.getName(), NONE),
        AIR(0, AIR.getName(), AIR),
        SURFACE_AIR(0, SURFACE_AIR.getName(), SURFACE_AIR),
        FLOOR_AIR(0, FLOOR_AIR.getName(), FLOOR_AIR),
        WALL_AIR(0, WALL_AIR.getName(), WALL_AIR),
        CEILING_AIR(0, CEILING_AIR.getName(), CEILING_AIR),
        FLOOR(1, FLOOR.getName(), FLOOR),
        FLOOR_ALT(1, FLOOR_ALT.getName(), FLOOR_ALT),
        WALL(2, WALL.getName(), WALL),
        WALL_BASE(3, WALL_BASE.getName(), WALL_BASE),
        WALL_CAPITAL(4, WALL_CAPITAL.getName(), WALL_CAPITAL),
        CEILING(3, CEILING.getName(), CEILING),
        BASE(4, BASE.getName(), BASE),
        COLUMN(5, COLUMN.getName(), COLUMN),
        CAPITAL(6, CAPITAL.getName(), CAPITAL),
        TRIM(7, TRIM.getName(), TRIM),
        CROWN(8, CROWN.getName(), CROWN),
        CORNICE(9, CORNICE.getName(), CORNICE),
        PLINTH(10, PLINTH.getName(), PLINTH),
        PILASTER(11, PILASTER.getName(), PILASTER),
        PILASTER_BASE(11, PILASTER_BASE.getName(), PILASTER_BASE),
        PILASTER_CAPITAL(11, PILASTER_CAPITAL.getName(), PILASTER_CAPITAL),
        PILLAR(12, PILLAR.getName(), PILLAR),
        PILLAR_BASE(12, PILLAR_BASE.getName(), PILLAR_BASE),
        PILLAR_CAPITAL(12, PILLAR_CAPITAL.getName(), PILLAR_CAPITAL),
        COFFERED_CROSSBEAM(13, COFFERED_CROSSBEAM.getName(), COFFERED_CROSSBEAM),
        COFFERED_MIDBEAM(13, COFFERED_MIDBEAM.getName(), COFFERED_MIDBEAM),
        LADDER(25, LADDER.getName(), LADDER),
        LADDER_PILLAR(26, LADDER_PILLAR.getName(), LADDER_PILLAR),
        GUTTER(26, GUTTER.getName(), GUTTER),
        GRATE(27, GRATE.getName(), GRATE),
        WINDOW(27, WINDOW.getName(), WINDOW),
        SIGN(28, SIGN.getName(), SIGN),
        CRENELLATION(50, CRENELLATION.getName(), CRENELLATION),
        PARAPET(51, PARAPET.getName(), PARAPET),
        MERLON(52, MERLON.getName(), MERLON),
        FACADE(100, FACADE.getName(), FACADE),
        FACADE_SUPPORT(101, FACADE_SUPPORT.getName(), FACADE_SUPPORT);

        private Integer code;
        private String value;
        private IArchitecturalElement element;
        private static final Map<Integer, IEnum> codes;
        private static final Map<String, IEnum> values;

        private ElementsEnum(int code, String value, IArchitecturalElement element) {
            this.code = code;
            this.value = value;
            this.element = element;
        }

        public IArchitecturalElement getElement() {
            return this.element;
        }

        public String getName() {
            return this.name();
        }

        public Integer getCode() {
            return this.code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public static ElementsEnum getByCode(Integer code) {
            return (ElementsEnum)codes.get(code);
        }

        public static ElementsEnum getByValue(String value) {
            return (ElementsEnum)values.get(value);
        }

        public Map<Integer, IEnum> getCodes() {
            return codes;
        }

        public Map<String, IEnum> getValues() {
            return values;
        }

        static {
            codes = new HashMap<Integer, IEnum>();
            values = new HashMap<String, IEnum>();
            for (ElementsEnum x : EnumSet.allOf(ElementsEnum.class)) {
                codes.put(x.getCode(), x);
                values.put(x.getValue(), x);
            }
        }
    }
}

