/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.api.capability.extendedplayer;

import com.bewitchment.Bewitchment;
import com.bewitchment.api.message.SyncExtendedPlayer;
import com.bewitchment.api.registry.Curse;
import com.bewitchment.api.registry.Fortune;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ExtendedPlayer
implements ICapabilitySerializable<NBTTagCompound>,
Capability.IStorage<ExtendedPlayer> {
    @CapabilityInject(value=ExtendedPlayer.class)
    public static final Capability<ExtendedPlayer> CAPABILITY = null;
    public NBTTagList uniqueDefeatedBosses = new NBTTagList();
    public Fortune fortune;
    public Map<String, Integer> curses = new HashMap<String, Integer>();
    public boolean canRitual = true;
    public int ritualDisabledTime;
    public int fortuneTime;
    public int ritualsCast;
    public int mobsKilled;

    public static void syncToClient(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            Bewitchment.network.sendTo((IMessage)new SyncExtendedPlayer(((ExtendedPlayer)player.getCapability(CAPABILITY, null)).serializeNBT()), (EntityPlayerMP)player);
        }
    }

    @Nullable
    public NBTBase writeNBT(Capability<ExtendedPlayer> capability, ExtendedPlayer instance, EnumFacing face) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("uniqueDefeatedBosses", (NBTBase)instance.uniqueDefeatedBosses);
        tag.func_74778_a("fortune", instance.fortune == null ? "" : instance.fortune.getRegistryName().toString());
        tag.func_74757_a("canRitual", instance.canRitual);
        NBTTagList cursesList = new NBTTagList();
        tag.func_74782_a("curses", (NBTBase)cursesList);
        instance.curses.entrySet().stream().forEach(entry -> this.addNewCouple((Map.Entry<String, Integer>)entry, cursesList));
        tag.func_74768_a("fortuneTime", this.fortuneTime);
        tag.func_74768_a("ritualsCast", instance.ritualsCast);
        tag.func_74768_a("mobsKilled", instance.mobsKilled);
        tag.func_74768_a("ritualDisabledTime", instance.ritualDisabledTime);
        return tag;
    }

    public void readNBT(Capability<ExtendedPlayer> capability, ExtendedPlayer instance, EnumFacing face, NBTBase nbt) {
        NBTTagCompound tag = (NBTTagCompound)nbt;
        instance.uniqueDefeatedBosses = tag.func_150295_c("uniqueDefeatedBosses", 8);
        instance.fortune = tag.func_74779_i("fortune").isEmpty() ? null : (Fortune)GameRegistry.findRegistry(Fortune.class).getValue(new ResourceLocation(tag.func_74779_i("fortune")));
        instance.canRitual = tag.func_74767_n("canRitual");
        instance.curses.clear();
        tag.func_150295_c("curses", 10).forEach(s -> this.loadCouple(instance, (NBTBase)s));
        instance.fortuneTime = tag.func_74762_e("fortuneTime");
        instance.ritualsCast = tag.func_74762_e("ritualsCast");
        instance.mobsKilled = tag.func_74762_e("mobsKilled");
        instance.ritualDisabledTime = tag.func_74762_e("ritualDisabledTime");
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing face) {
        return this.getCapability(capability, null) != null;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing face) {
        return (T)(capability == CAPABILITY ? CAPABILITY.cast((Object)this) : null);
    }

    public NBTTagCompound serializeNBT() {
        return (NBTTagCompound)CAPABILITY.getStorage().writeNBT(CAPABILITY, (Object)this, null);
    }

    public void deserializeNBT(NBTTagCompound tag) {
        CAPABILITY.getStorage().readNBT(CAPABILITY, (Object)this, null, (NBTBase)tag);
    }

    public List<Curse> getCurses() {
        ArrayList<Curse> curseList = new ArrayList<Curse>();
        this.curses.keySet().forEach(s -> {
            Curse curse = (Curse)GameRegistry.findRegistry(Curse.class).getValue(new ResourceLocation(s));
            if (curse != null) {
                curseList.add(curse);
            }
        });
        return curseList;
    }

    public void addCurse(Curse curse, int days) {
        this.curses.putIfAbsent(curse.getRegistryName().toString(), days * 24000);
    }

    public boolean hasCurse(Curse curse) {
        return this.getCurses().contains((Object)curse);
    }

    public boolean removeCurse(Curse curse) {
        if (this.getCurses().contains((Object)curse)) {
            this.curses.remove(curse.getRegistryName().toString());
            return true;
        }
        return false;
    }

    public void updateCurses() {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String curs : this.curses.keySet()) {
            this.curses.replace(curs, this.curses.get(curs), this.curses.get(curs) - 20);
            if (this.curses.get(curs) > 0) continue;
            toRemove.add(curs);
        }
        toRemove.forEach(s -> this.curses.remove(s));
    }

    private void addNewCouple(Map.Entry<String, Integer> entry, NBTTagList list) {
        NBTTagCompound couple = new NBTTagCompound();
        couple.func_74778_a("curseId", entry.getKey());
        couple.func_74768_a("daysLeft", entry.getValue().intValue());
        list.func_74742_a((NBTBase)couple);
    }

    private void loadCouple(ExtendedPlayer instance, NBTBase s) {
        NBTTagCompound tag = (NBTTagCompound)s;
        instance.curses.put(tag.func_74779_i("curseId"), tag.func_74762_e("daysLeft"));
    }
}

