/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.api.capability.extendedworld;

import com.bewitchment.common.entity.spirit.demon.AbstractGreaterDemon;
import com.bewitchment.common.entity.util.IPledgeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class ExtendedWorld
extends WorldSavedData {
    private static final String TAG = "bewitchment.world_data";
    public final List<NBTTagCompound> storedCauldrons = new ArrayList<NBTTagCompound>();
    public final List<NBTTagCompound> storedPoppetShelves = new ArrayList<NBTTagCompound>();
    public final Map<String, Set<UUID>> demonPledgedPlayers = new HashMap<String, Set<UUID>>();

    public ExtendedWorld(String name) {
        super(name);
    }

    public static ExtendedWorld get(World world) {
        ExtendedWorld data = (ExtendedWorld)world.func_175693_T().func_75742_a(ExtendedWorld.class, TAG);
        if (data == null) {
            data = new ExtendedWorld(TAG);
            world.func_175693_T().func_75745_a(TAG, (WorldSavedData)data);
        }
        return data;
    }

    public static void pledgePlayerToDemon(World world, EntityPlayer player, IPledgeable demon) {
        ExtendedWorld extendedWorld = ExtendedWorld.get(world);
        HashSet<UUID> players = new HashSet<UUID>();
        if (extendedWorld.demonPledgedPlayers.containsKey(demon.getPledgeName())) {
            players.addAll((Collection)extendedWorld.demonPledgedPlayers.get(demon.getPledgeName()));
        }
        players.add(player.func_110124_au());
        extendedWorld.demonPledgedPlayers.put(demon.getPledgeName(), players);
        extendedWorld.func_76185_a();
        if (demon instanceof AbstractGreaterDemon && player instanceof EntityPlayerMP) {
            ((AbstractGreaterDemon)demon).bossInfo.func_186761_b((EntityPlayerMP)player);
        }
    }

    public static void depledgePlayerToDemon(World world, EntityPlayer player, IPledgeable demon) {
        ExtendedWorld extendedWorld = ExtendedWorld.get(world);
        HashSet players = new HashSet();
        if (extendedWorld.demonPledgedPlayers.containsKey(demon.getPledgeName())) {
            players.addAll(extendedWorld.demonPledgedPlayers.get(demon.getPledgeName()));
        }
        players.remove(player.getPersistentID());
        extendedWorld.demonPledgedPlayers.put(demon.getPledgeName(), players);
        extendedWorld.func_76185_a();
        if (demon instanceof AbstractGreaterDemon && player instanceof EntityPlayerMP) {
            ((AbstractGreaterDemon)demon).bossInfo.func_186760_a((EntityPlayerMP)player);
        }
    }

    public static boolean playerPledgedToDemon(World world, EntityPlayer player, String demon) {
        ExtendedWorld extendedWorld = ExtendedWorld.get(world);
        Set<UUID> players = extendedWorld.demonPledgedPlayers.get(demon);
        return players != null && players.contains(player.getPersistentID());
    }

    public void func_76184_a(NBTTagCompound nbt) {
        int i;
        NBTTagList storedCauldrons = nbt.func_150295_c("storedCauldrons", 10);
        NBTTagList storedPoppetShelves = nbt.func_150295_c("storedPoppetShelves", 10);
        for (i = 0; i < storedCauldrons.func_74745_c(); ++i) {
            this.storedCauldrons.add(storedCauldrons.func_150305_b(i));
        }
        for (i = 0; i < storedPoppetShelves.func_74745_c(); ++i) {
            this.storedPoppetShelves.add(storedPoppetShelves.func_150305_b(i));
        }
        nbt.func_150295_c("demonPledges", 10).forEach(tag -> this.readPledge(this.demonPledgedPlayers, (NBTTagCompound)tag));
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagList storedCauldrons = new NBTTagList();
        NBTTagList storedPoppetShelves = new NBTTagList();
        NBTTagList demonPledges = new NBTTagList();
        for (NBTTagCompound cauldron : this.storedCauldrons) {
            storedCauldrons.func_74742_a((NBTBase)cauldron);
        }
        for (NBTTagCompound poppet : this.storedPoppetShelves) {
            storedPoppetShelves.func_74742_a((NBTBase)poppet);
        }
        this.demonPledgedPlayers.entrySet().forEach(entry -> this.writePledge((Map.Entry<String, Set<UUID>>)entry, demonPledges));
        nbt.func_74782_a("storedCauldrons", (NBTBase)storedCauldrons);
        nbt.func_74782_a("storedPoppetShelves", (NBTBase)storedPoppetShelves);
        nbt.func_74782_a("demonPledges", (NBTBase)demonPledges);
        return nbt;
    }

    private void writePledge(Map.Entry<String, Set<UUID>> entry, NBTTagList list) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("demon", entry.getKey());
        NBTTagList players = new NBTTagList();
        for (UUID uuid : entry.getValue()) {
            players.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        data.func_74782_a("players", (NBTBase)players);
        list.func_74742_a((NBTBase)data);
    }

    private void readPledge(Map<String, Set<UUID>> map, NBTTagCompound tag) {
        HashSet<UUID> players = new HashSet<UUID>();
        String demon = tag.func_74779_i("demon");
        for (NBTBase player : tag.func_150295_c("players", 8)) {
            players.add(UUID.fromString(((NBTTagString)player).func_150285_a_()));
        }
        map.put(demon, players);
    }
}

