/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.api.registry;

import com.bewitchment.Util;
import com.bewitchment.common.block.BlockGlyph;
import com.bewitchment.common.item.tool.ItemAthame;
import com.bewitchment.common.item.tool.ItemBoline;
import com.bewitchment.registry.ModObjects;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Ritual
extends IForgeRegistryEntry.Impl<Ritual> {
    public static final int[][] small = new int[][]{{0, 0, 1, 1, 1, 0, 0}, {0, 1, 0, 0, 0, 1, 0}, {1, 0, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 0, 1}, {0, 1, 0, 0, 0, 1, 0}, {0, 0, 1, 1, 1, 0, 0}};
    public static final int[][] medium = new int[][]{{0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0}, {0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0}, {0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0}};
    public static final int[][] large = new int[][]{{0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0}, {0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0}};
    public final List<Ingredient> input;
    public final List<ItemStack> output;
    public final Predicate<EntityLivingBase> sacrificePredicate;
    public final int[] circles = new int[3];
    public final int time;
    public final int startingPower;
    public final int runningPower;
    public final boolean canBePerformedRemotely;

    public Ritual(ResourceLocation name, List<Ingredient> input, Predicate<EntityLivingBase> sacrificePredicate, List<ItemStack> output, boolean canBePerformedRemotely, int time, int startingPower, int runningPower, int small, int medium, int big) {
        this.setRegistryName(name);
        if (input.size() > 10) {
            throw new IllegalArgumentException("Rituals can only have at most 10 input items");
        }
        if (output != null && output.size() > 5) {
            throw new IllegalArgumentException("Rituals can only have at most 5 output items");
        }
        this.input = input;
        this.sacrificePredicate = sacrificePredicate;
        this.output = output;
        this.canBePerformedRemotely = canBePerformedRemotely;
        this.time = time;
        this.startingPower = startingPower;
        this.runningPower = runningPower;
        if (small < 0) {
            throw new IllegalArgumentException("Cannot have the smaller circle missing");
        }
        if (medium < 0 && big > 0) {
            throw new IllegalArgumentException("Cannot have missing middle circle when a big circle is present");
        }
        if (small == 0 || medium == 0 || big == 0) {
            throw new IllegalArgumentException("No golden circles allowed");
        }
        this.circles[0] = small;
        this.circles[1] = medium;
        this.circles[2] = big;
    }

    public Ritual(ResourceLocation name, List<Ingredient> input, Predicate<EntityLivingBase> sacrificePredicate, List<ItemStack> output, int time, int startingPower, int runningPower, int small, int medium, int big) {
        this(name, input, sacrificePredicate, output, true, time, startingPower, runningPower, small, medium, big);
    }

    public String getPreconditionMessage() {
        return "ritual.precondition.empty";
    }

    public boolean isValid(World world, BlockPos altarPos, EntityPlayer caster, ItemStackHandler inventory) {
        return this.sacrificePredicate == null;
    }

    public void onStarted(World world, BlockPos pos, EntityPlayer caster, ItemStackHandler inventory) {
        world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public void onFinished(World world, BlockPos altarPos, BlockPos effectivePos, EntityPlayer caster, ItemStackHandler inventory) {
        world.func_184133_a(null, altarPos, SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 0.7f, 0.7f);
        world.func_184133_a(null, effectivePos, SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 0.7f, 0.7f);
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_77973_b() instanceof ItemAthame) {
                stack.func_77972_a(35, (EntityLivingBase)caster);
            }
            if (stack.func_77973_b() instanceof ItemBoline) {
                stack.func_77972_a(50, (EntityLivingBase)caster);
                continue;
            }
            inventory.extractItem(i, 1, false);
        }
        if (!world.field_72995_K && this.output != null) {
            for (ItemStack stack : this.output) {
                InventoryHelper.func_180173_a((World)world, (double)altarPos.func_177958_n(), (double)altarPos.func_177956_o(), (double)altarPos.func_177952_p(), (ItemStack)stack.func_77946_l());
            }
        }
    }

    public void onHalted(World world, BlockPos altarPos, BlockPos effectivePos, EntityPlayer caster, ItemStackHandler inventory) {
        world.func_184133_a(null, altarPos, SoundEvents.field_187665_Y, SoundCategory.BLOCKS, 0.7f, 0.7f);
        if (!world.field_72995_K) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                InventoryHelper.func_180173_a((World)world, (double)altarPos.func_177958_n(), (double)altarPos.func_177956_o(), (double)altarPos.func_177952_p(), (ItemStack)inventory.extractItem(i, inventory.getStackInSlot(i).func_190916_E(), false));
            }
        }
    }

    public void onUpdate(World world, BlockPos altarPos, BlockPos effectivePos, EntityPlayer caster, ItemStackHandler inventory) {
    }

    public final boolean matches(World world, BlockPos pos, ItemStackHandler handler) {
        IBlockState state;
        int z;
        int x;
        for (x = 0; x < small.length; ++x) {
            for (z = 0; z < small.length; ++z) {
                state = world.func_180495_p(pos.func_177982_a(x - small.length / 2, 0, z - small.length / 2));
                if (small[x][z] != 1 || state.func_177230_c() == ModObjects.glyph && ((Integer)state.func_177229_b((IProperty)BlockGlyph.TYPE) == 0 || (Integer)state.func_177229_b((IProperty)BlockGlyph.TYPE) == this.circles[0] || this.circles[0] == 4)) continue;
                return false;
            }
        }
        if (this.circles[1] != -1) {
            for (x = 0; x < medium.length; ++x) {
                for (z = 0; z < medium.length; ++z) {
                    state = world.func_180495_p(pos.func_177982_a(x - medium.length / 2, 0, z - medium.length / 2));
                    if (medium[x][z] != 1 || state.func_177230_c() == ModObjects.glyph && ((Integer)state.func_177229_b((IProperty)BlockGlyph.TYPE) == 0 || (Integer)state.func_177229_b((IProperty)BlockGlyph.TYPE) == this.circles[1] || this.circles[1] == 4)) continue;
                    return false;
                }
            }
        }
        if (this.circles[2] != -1) {
            for (x = 0; x < large.length; ++x) {
                for (z = 0; z < large.length; ++z) {
                    state = world.func_180495_p(pos.func_177982_a(x - large.length / 2, 0, z - large.length / 2));
                    if (large[x][z] != 1 || state.func_177230_c() == ModObjects.glyph && ((Integer)state.func_177229_b((IProperty)BlockGlyph.TYPE) == 0 || (Integer)state.func_177229_b((IProperty)BlockGlyph.TYPE) == this.circles[2] || this.circles[2] == 4)) continue;
                    return false;
                }
            }
        }
        return Util.areISListsEqual(this.input, handler);
    }
}

