/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.block;

import com.bewitchment.client.misc.Statues;
import com.bewitchment.common.block.tile.entity.TileEntityStatue;
import com.bewitchment.common.block.util.ModBlock;
import com.bewitchment.common.block.util.ModBlockContainer;
import com.bewitchment.registry.ModObjects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockStatue
extends ModBlockContainer {
    public final Statues.Statue statue;

    public BlockStatue(Statues.Statue statue) {
        super(null, statue.getName(), statue.getBase(), -1);
        this.statue = statue;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityStatue();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.field_176754_o[meta]);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        for (int i = 0; i < this.statue.getHeight(); ++i) {
            world.func_175698_g(pos.func_177981_b(i));
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        for (int i = 0; i < this.statue.getHeight() - 1; ++i) {
            world.func_175656_a(pos.func_177984_a().func_177981_b(i), ModObjects.filler.func_176223_P().func_177226_a((IProperty)BlockFiller.HEIGHT, (Comparable)Integer.valueOf(i)));
        }
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityStatue) {
            TileEntityStatue te = (TileEntityStatue)world.func_175625_s(pos);
            te.name = this.statue.getName();
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return 3.5f;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176736_b();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return field_185505_j.func_72321_a(0.0, (double)(this.statue.getHeight() - 1), 0.0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockHorizontal.field_185512_D});
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase living, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.func_176733_a((double)living.field_70177_z).func_176734_d());
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing face) {
        BlockPos pos0 = world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) ? pos : pos.func_177972_a(face);
        for (int i = 0; i < this.statue.getHeight(); ++i) {
            if (this.func_176196_c(world, pos0.func_177981_b(i))) continue;
            return false;
        }
        return true;
    }

    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return false;
    }

    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return false;
    }

    public static class BlockFiller
    extends ModBlock {
        public static final PropertyInteger HEIGHT = PropertyInteger.func_177719_a((String)"height", (int)0, (int)3);

        public BlockFiller() {
            super("statue_filler", Blocks.field_150340_R, new String[0]);
            this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)HEIGHT, (Comparable)Integer.valueOf(0)));
        }

        private int getHeightAbove(BlockPos pos, World world) {
            int height = 0;
            while (world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockFiller) {
                ++height;
                pos = pos.func_177984_a();
            }
            return height;
        }

        private BlockPos getStatuePos(World world, BlockPos pos) {
            for (int i = 0; i < 5; ++i) {
                if (!(world.func_180495_p(pos.func_177979_c(i)).func_177230_c() instanceof BlockStatue)) continue;
                return pos.func_177979_c(i);
            }
            return null;
        }

        @Override
        public boolean func_149662_c(IBlockState state) {
            return false;
        }

        public EnumBlockRenderType func_149645_b(IBlockState state) {
            return EnumBlockRenderType.INVISIBLE;
        }

        public int func_149745_a(Random random) {
            return 0;
        }

        public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
            return false;
        }

        public IBlockState func_176203_a(int meta) {
            return this.func_176223_P().func_177226_a((IProperty)HEIGHT, (Comparable)Integer.valueOf(meta));
        }

        public int func_176201_c(IBlockState state) {
            return (Integer)state.func_177229_b((IProperty)HEIGHT);
        }

        protected BlockStateContainer func_180661_e() {
            return new BlockStateContainer((Block)this, new IProperty[]{HEIGHT});
        }

        public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
            return BlockFaceShape.UNDEFINED;
        }

        public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
            return false;
        }

        public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
            int height = 1;
            if (source instanceof World) {
                height = this.getHeightAbove(pos, (World)source);
            }
            return new AxisAlignedBB(0.0, (double)(-((Integer)state.func_177229_b((IProperty)HEIGHT)).intValue() - 1), 0.0, 1.0, (double)(height + 1), 1.0);
        }

        public void func_180663_b(World world, BlockPos pos, IBlockState state) {
            BlockPos statuePos = this.getStatuePos(world, pos);
            if (statuePos != null) {
                InventoryHelper.func_180173_a((World)world, (double)statuePos.func_177958_n(), (double)statuePos.func_177956_o(), (double)statuePos.func_177952_p(), (ItemStack)new ItemStack(world.func_180495_p(statuePos).func_177230_c()));
                world.func_180495_p(statuePos).func_177230_c().func_180663_b(world, statuePos, world.func_180495_p(statuePos));
            } else {
                super.func_180663_b(world, pos, state);
            }
        }

        public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
            BlockPos statuePos = this.getStatuePos(worldIn, pos);
            if (statuePos != null) {
                return new ItemStack(worldIn.func_180495_p(statuePos).func_177230_c());
            }
            return ItemStack.field_190927_a;
        }

        public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
            return false;
        }

        public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
            return false;
        }
    }
}

