/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.block.tile.entity;

import com.bewitchment.ModConfig;
import com.bewitchment.api.BewitchmentAPI;
import com.bewitchment.api.capability.magicpower.MagicPower;
import com.bewitchment.api.registry.AltarUpgrade;
import com.bewitchment.common.block.BlockWitchesAltar;
import com.bewitchment.common.block.tile.entity.TileEntityPlacedItem;
import com.bewitchment.common.block.tile.entity.util.ModTileEntity;
import com.bewitchment.common.item.tool.ItemGrimoireMagia;
import com.bewitchment.registry.ModObjects;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockMelon;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityWitchesAltar
extends ModTileEntity
implements ITickable {
    public final MagicPower magicPower = (MagicPower)MagicPower.CAPABILITY.getDefaultInstance();
    private final Map<IBlockState, Integer> map = new HashMap<IBlockState, Integer>();
    private final BlockPos.MutableBlockPos checking = new BlockPos.MutableBlockPos();
    public int color;
    public int gain;
    private int counter;
    private int maxPower;

    private static AltarUpgrade getAltarUpgrade(World world, BlockPos pos) {
        for (Predicate<BlockWorldState> predicate : BewitchmentAPI.ALTAR_UPGRADES.keySet()) {
            if (!predicate.test(new BlockWorldState(world, pos, true))) continue;
            return BewitchmentAPI.ALTAR_UPGRADES.get(predicate);
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        this.magicPower.deserializeNBT(tag.func_74775_l("magicPower"));
        this.color = tag.func_74762_e("color");
        super.func_145839_a(tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74782_a("magicPower", (NBTBase)this.magicPower.serializeNBT());
        tag.func_74768_a("color", this.color);
        return super.func_189515_b(tag);
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        boolean flag;
        boolean bl = flag = super.shouldRefresh(world, pos, oldState, newState) || !((Integer)newState.func_177229_b((IProperty)BlockWitchesAltar.TYPE)).equals(oldState.func_177229_b((IProperty)BlockWitchesAltar.TYPE));
        if (!world.field_72995_K && flag) {
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)((double)pos.func_177956_o() + 0.75), (double)pos.func_177952_p(), (ItemStack)new ItemStack(Blocks.field_150404_cg, 1, this.color - 1));
        }
        return flag;
    }

    @Override
    public ItemStackHandler[] getInventories() {
        ItemStackHandler fin = new ItemStackHandler();
        fin.insertItem(0, new ItemStack(Blocks.field_150404_cg, 1, this.color - 1), false);
        return new ItemStackHandler[]{fin};
    }

    public void onLoad() {
        this.forceScan();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing face) {
        return capability == MagicPower.CAPABILITY || super.hasCapability(capability, face);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing face) {
        return (T)(capability == MagicPower.CAPABILITY ? MagicPower.CAPABILITY.cast((Object)this.magicPower) : super.getCapability(capability, face));
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 100L == 0L) {
                block0: for (EntityPlayer player : this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(25.0))) {
                    for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                        ItemStack stack = player.field_71071_by.func_70301_a(i);
                        if (!(stack.func_77973_b() instanceof ItemGrimoireMagia) || !stack.func_77942_o()) continue;
                        MagicPower temp = new MagicPower();
                        temp.amount = stack.func_77978_p().func_74762_e("amount");
                        temp.maxAmount = stack.func_77978_p().func_74762_e("maxAmount");
                        if (!MagicPower.transfer(this.magicPower, temp, 50, 0.5f)) continue;
                        stack.func_77978_p().func_74768_a("amount", temp.amount);
                        player.field_71071_by.func_70299_a(i, stack);
                        player.field_71071_by.func_70296_d();
                        continue block0;
                    }
                }
            }
            if (this.magicPower.amount > this.magicPower.maxAmount) {
                this.magicPower.amount = this.magicPower.maxAmount;
            }
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.magicPower.fill(this.gain * 8);
            }
            this.scan(ModConfig.misc.altarScansPerTick);
        }
    }

    public void forceScan() {
        this.syncToClient();
        this.counter = 0;
        this.maxPower = 0;
        this.map.clear();
        this.scan(Short.MAX_VALUE);
    }

    protected void scan(int times) {
        for (int i = 0; i < times; ++i) {
            ++this.counter;
            this.counter %= Short.MAX_VALUE;
            int x = this.counter & 0x1F;
            int y = this.counter >> 5 & 0x1F;
            int z = this.counter >> 10 & 0x1F;
            this.checking.func_181079_c(this.field_174879_c.func_177958_n() + x - 8, this.field_174879_c.func_177956_o() + y - 8, this.field_174879_c.func_177952_p() + z - 8);
            this.registerToMap(this.field_145850_b.func_180495_p((BlockPos)this.checking));
            if (this.counter != 32766) continue;
            boolean foundStone = false;
            boolean foundCup = false;
            boolean foundPentacle = false;
            boolean foundSword = false;
            boolean foundWand = false;
            this.gain = 1;
            double multiplier = 1.0;
            for (BlockPos pos0 : BlockPos.func_177975_b((BlockPos)this.field_174879_c.func_177982_a(-1, 0, -1), (BlockPos)this.field_174879_c.func_177982_a(1, 0, 1))) {
                AltarUpgrade upgrade;
                ItemStack stack;
                if (!(this.field_145850_b.func_180495_p(pos0).func_177230_c() instanceof BlockWitchesAltar)) continue;
                if (this.field_145850_b.func_180495_p(pos0.func_177984_a()).func_177230_c() == ModObjects.blessed_stone) {
                    foundStone = true;
                }
                if (this.field_145850_b.func_175625_s(pos0.func_177984_a()) instanceof TileEntityPlacedItem && (stack = ((TileEntityPlacedItem)this.field_145850_b.func_175625_s(pos0.func_177984_a())).getInventories()[0].getStackInSlot(0)).func_77973_b() instanceof ItemGrimoireMagia && stack.func_77942_o()) {
                    MagicPower temp = new MagicPower();
                    temp.amount = stack.func_77978_p().func_74762_e("amount");
                    temp.maxAmount = stack.func_77978_p().func_74762_e("maxAmount");
                    if (MagicPower.transfer(this.magicPower, temp, 100, 0.25f)) {
                        stack.func_77978_p().func_74768_a("amount", temp.amount);
                    }
                }
                if (foundStone || (upgrade = TileEntityWitchesAltar.getAltarUpgrade(this.field_145850_b, pos0.func_177984_a())) == null) continue;
                AltarUpgrade.Type type = upgrade.type;
                if (type == AltarUpgrade.Type.CUP && !foundCup) {
                    this.gain += upgrade.upgrade1;
                    multiplier *= upgrade.upgrade2;
                    foundCup = true;
                }
                if (type == AltarUpgrade.Type.PENTACLE && !foundPentacle) {
                    this.gain += upgrade.upgrade1;
                    foundPentacle = true;
                }
                if (type == AltarUpgrade.Type.SWORD && !foundSword) {
                    multiplier *= upgrade.upgrade2;
                    foundSword = true;
                }
                if (type != AltarUpgrade.Type.WAND || foundWand) continue;
                this.maxPower = (int)((double)this.maxPower + 64.0 * upgrade.upgrade2);
                foundWand = true;
            }
            if (foundStone) {
                this.gain = Short.MAX_VALUE;
                this.maxPower = Short.MAX_VALUE;
                multiplier = 1.0;
            }
            if (this.gain < 0) {
                this.gain = 0;
            }
            this.magicPower.maxAmount = (int)((double)this.maxPower * multiplier);
            this.maxPower = 0;
            this.counter = 0;
            this.map.clear();
        }
    }

    protected IBlockState convert(IBlockState state) {
        if (Loader.isModLoaded((String)"dynamictrees") && state.func_177230_c() instanceof ITreePart) {
            return state;
        }
        if (state.func_177230_c() instanceof BlockLog) {
            state = state.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
        } else if (state.func_177230_c() instanceof BlockRotatedPillar) {
            state = state.func_177230_c().func_176223_P().func_177226_a((IProperty)BlockRotatedPillar.field_176298_M, (Comparable)EnumFacing.Axis.Y);
        } else if (state.func_177230_c() instanceof BlockLeaves) {
            state = state.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));
        } else if (!(state.func_177230_c() instanceof BlockFlower)) {
            state = state.func_177230_c().func_176223_P();
        }
        return state;
    }

    protected boolean isNatural(IBlockState state) {
        if (Loader.isModLoaded((String)"dynamictrees")) {
            // empty if block
        }
        return !(state.func_177230_c() instanceof BlockGrass) && (state.func_177230_c() instanceof IGrowable || state.func_177230_c() instanceof IPlantable || state.func_177230_c() instanceof BlockMelon || state.func_177230_c() instanceof BlockPumpkin || state.func_177230_c() instanceof BlockLeaves || state.func_177230_c() instanceof BlockRotatedPillar && state.func_185904_a() == Material.field_151575_d);
    }

    protected void registerToMap(IBlockState state) {
        if (this.isNatural(state)) {
            IBlockState state0 = this.convert(state);
            int current = this.map.getOrDefault(state0, 0);
            if (this.map.keySet().isEmpty() || current < 4 * this.map.keySet().size()) {
                this.map.put(state0, ++current);
                ++this.maxPower;
            }
        }
    }
}

