/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.curse;

import com.bewitchment.Util;
import com.bewitchment.api.registry.Curse;
import com.bewitchment.registry.ModObjects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.eventhandler.Event;

public class CurseInsanity
extends Curse {
    public CurseInsanity() {
        super(new ResourceLocation("bewitchment", "insanity"), Arrays.asList(Util.get(Blocks.field_150337_Q), Util.get(ModObjects.belladonna), Util.get(ModObjects.elderberries), Util.get(ModObjects.oil_of_vitriol), Util.get(ModObjects.toe_of_frog), Util.get(ModObjects.spanish_moss), Util.get(ModObjects.taglock)), false, false, Curse.CurseCondition.EXIST, 0.01);
    }

    @Override
    public boolean doCurse(Event event, EntityPlayer target) {
        EntityLiving fake = this.getRandomFakeMob(target.func_70681_au(), target);
        target.field_70170_p.func_72838_d((Entity)fake);
        return true;
    }

    private EntityLiving getRandomFakeMob(Random rand, EntityPlayer target) {
        EntityZombie temp;
        World world = target.field_70170_p;
        List spawns = world.func_180494_b(target.func_180425_c()).func_76747_a(EnumCreatureType.MONSTER);
        if (spawns.size() <= 0) {
            temp = new EntityZombie(world);
        } else {
            try {
                temp = (EntityLiving)((Biome.SpawnListEntry)spawns.get((int)rand.nextInt((int)spawns.size()))).field_76300_b.getConstructor(World.class).newInstance(world);
            }
            catch (Exception e) {
                temp = new EntityZombie(world);
            }
        }
        int x = (int)target.field_70165_t + rand.nextInt(6) - 5;
        int z = (int)target.field_70161_v + rand.nextInt(6) - 5;
        temp.func_70107_b((double)x, (double)world.func_189649_b(x, z), (double)z);
        temp.func_184224_h(true);
        ArrayList<EntityAIBase> toRemove = new ArrayList<EntityAIBase>();
        for (EntityAITasks.EntityAITaskEntry task : temp.field_70714_bg.field_75782_a) {
            toRemove.add(task.field_75733_a);
        }
        for (EntityAIBase remove : toRemove) {
            temp.field_70714_bg.func_85156_a(remove);
        }
        temp.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFakeAttack((EntityLiving)temp, 1.0, false));
        temp.func_70624_b((EntityLivingBase)target);
        return temp;
    }

    static class EntityAIFakeAttack
    extends EntityAIBase {
        World world;
        EntityLiving attacker;
        int attackTick;
        double speedTowardsTarget;
        boolean longMemory;
        Path path;
        int survivalTime;
        private int delayCounter;
        private double targetX;
        private double targetY;
        private double targetZ;
        private int failedPathFindingPenalty = 0;
        private boolean canPenalize = false;

        EntityAIFakeAttack(EntityLiving creature, double speedIn, boolean useLongMemory) {
            this.attacker = creature;
            this.world = creature.field_70170_p;
            this.speedTowardsTarget = speedIn;
            this.longMemory = useLongMemory;
            this.survivalTime = creature.func_70681_au().nextInt(20) + 30;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            if (this.canPenalize) {
                if (--this.delayCounter <= 0) {
                    this.path = this.attacker.func_70661_as().func_75494_a((Entity)entitylivingbase);
                    this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
                    return this.path != null;
                }
                return true;
            }
            this.path = this.attacker.func_70661_as().func_75494_a((Entity)entitylivingbase);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(entitylivingbase) >= this.attacker.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v);
        }

        public boolean func_75253_b() {
            EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            if (!this.longMemory) {
                return !this.attacker.func_70661_as().func_75500_f();
            }
            return !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).func_175149_v() && !((EntityPlayer)entitylivingbase).func_184812_l_();
        }

        public void func_75249_e() {
            this.attacker.func_70661_as().func_75484_a(this.path, this.speedTowardsTarget);
            this.delayCounter = 0;
        }

        public void func_75251_c() {
            EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
            if (entitylivingbase instanceof EntityPlayer && (((EntityPlayer)entitylivingbase).func_175149_v() || ((EntityPlayer)entitylivingbase).func_184812_l_())) {
                this.attacker.func_70624_b((EntityLivingBase)null);
            }
            this.attacker.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
            this.attacker.func_70671_ap().func_75651_a((Entity)entitylivingbase, 30.0f, 30.0f);
            double d0 = this.attacker.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v);
            --this.delayCounter;
            if ((this.longMemory || this.attacker.func_70635_at().func_75522_a((Entity)entitylivingbase)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || entitylivingbase.func_70092_e(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.func_70681_au().nextFloat() < 0.05f)) {
                this.targetX = entitylivingbase.field_70165_t;
                this.targetY = entitylivingbase.func_174813_aQ().field_72338_b;
                this.targetZ = entitylivingbase.field_70161_v;
                this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
                if (this.canPenalize) {
                    PathPoint finalPathPoint;
                    this.delayCounter += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.attacker.func_70661_as().func_75505_d() != null ? ((finalPathPoint = this.attacker.func_70661_as().func_75505_d().func_75870_c()) != null && entitylivingbase.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.delayCounter += 10;
                } else if (d0 > 256.0) {
                    this.delayCounter += 5;
                }
                if (!this.attacker.func_70661_as().func_75497_a((Entity)entitylivingbase, this.speedTowardsTarget)) {
                    this.delayCounter += 15;
                }
            }
            this.attackTick = Math.max(this.attackTick - 1, 0);
            this.checkAndPerformAttack(entitylivingbase, d0);
        }

        void checkAndPerformAttack(EntityLivingBase enemy, double distToEnemySqr) {
            double d0 = this.getAttackReachSqr(enemy);
            if (distToEnemySqr <= 5.0) {
                --this.survivalTime;
                if (this.survivalTime <= 0) {
                    ((WorldServer)this.world).func_180505_a(EnumParticleTypes.SMOKE_LARGE, false, this.attacker.field_70165_t, this.attacker.field_70163_u, this.attacker.field_70161_v, 100, 1.0, 2.0, 1.0, 0.05, new int[]{0});
                    this.attacker.func_70106_y();
                }
            }
            if (distToEnemySqr <= d0 && this.attackTick <= 0) {
                this.attackTick = 20;
                this.attacker.func_184609_a(EnumHand.MAIN_HAND);
            }
        }

        double getAttackReachSqr(EntityLivingBase attackTarget) {
            return this.attacker.field_70130_N * 2.0f * this.attacker.field_70130_N * 2.0f + attackTarget.field_70130_N;
        }
    }
}

