/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.entity.util;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public abstract class ModEntityTameable
extends EntityTameable {
    public static final DataParameter<Integer> SKIN = EntityDataManager.func_187226_a(ModEntityTameable.class, (DataSerializer)DataSerializers.field_187192_b);
    private final Set<Item> tameItems;
    private final ResourceLocation lootTableLocation;

    protected ModEntityTameable(World world, ResourceLocation lootTableLocation, Item ... tameItems) {
        super(world);
        this.tameItems = Sets.newHashSet((Object[])tameItems);
        this.lootTableLocation = lootTableLocation;
    }

    public EntityAgeable func_90011_a(EntityAgeable other) {
        EntityAgeable entity = (EntityAgeable)EntityRegistry.getEntry(((Object)((Object)this)).getClass()).newInstance(this.field_70170_p);
        entity.func_184212_Q().func_187227_b(SKIN, (Object)(this.field_70146_Z.nextBoolean() ? (Integer)this.field_70180_af.func_187225_a(SKIN) : (Integer)other.func_184212_Q().func_187225_a(SKIN)));
        return entity;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag;
        Entity entity = source.func_76346_g();
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        if ((flag = super.func_70097_a(source, amount)) && this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        return flag;
    }

    public abstract boolean func_70877_b(ItemStack var1);

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.func_70909_n() && this.tameItems.contains(stack.func_77973_b())) {
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_192797_eu, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(5) == 0 && !ForgeEventFactory.onAnimalTame((EntityAnimal)this, (EntityPlayer)player)) {
                    this.func_193101_c(player);
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    this.func_70691_i(this.func_110138_aP());
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        if (!this.field_70170_p.field_72995_K && this.func_152114_e((EntityLivingBase)player) && this.func_70909_n() && !this.func_70877_b(stack)) {
            this.field_70911_d.func_75270_a(!this.func_70906_o());
            this.field_70703_bu = false;
            this.field_70699_by.func_75499_g();
            this.func_70624_b(null);
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70878_b(EntityAnimal other) {
        if (other == this || !other.getClass().getName().equals(((Object)((Object)this)).getClass().getName())) {
            return false;
        }
        return this.func_70909_n() && this.func_70880_s() && ((EntityTameable)other).func_70909_n() && other.func_70880_s() && !((EntityTameable)other).func_70906_o();
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.boostHealth(this.func_70909_n());
    }

    protected ResourceLocation func_184647_J() {
        return this.lootTableLocation;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData data) {
        this.field_70180_af.func_187227_b(SKIN, (Object)this.field_70146_Z.nextInt(this.getSkinTypes()));
        return super.func_180482_a(difficulty, data);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SKIN, (Object)0);
    }

    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74768_a("skin", ((Integer)this.field_70180_af.func_187225_a(SKIN)).intValue());
        this.field_70180_af.func_187217_b(SKIN);
        super.func_70014_b(tag);
    }

    public void func_70037_a(NBTTagCompound tag) {
        this.field_70180_af.func_187227_b(SKIN, (Object)tag.func_74762_e("skin"));
        super.func_70037_a(tag);
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        this.boostHealth(tamed);
    }

    protected int getSkinTypes() {
        return 1;
    }

    protected void boostHealth(boolean tamed) {
        if (tamed) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
    }
}

