/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.integration;

import c4.consecration.common.init.ConsecrationItems;
import c4.consecration.common.init.ConsecrationPotions;
import com.bewitchment.Util;
import com.bewitchment.api.registry.Brew;
import com.bewitchment.common.integration.BAPCompat;
import com.bewitchment.common.integration.thaumcraft.ThaumcraftCompat;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.potion.PotionHandler;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.misc.feature.ExtraPotions;
import vazkii.quark.world.feature.Biotite;
import vazkii.quark.world.feature.CaveRoots;
import vazkii.quark.world.feature.Crabs;
import vazkii.quark.world.feature.Frogs;
import vazkii.quark.world.feature.UndergroundBiomes;

public class Compat {
    public static void init() {
        if (Loader.isModLoaded((String)"betteranimalsplus")) {
            BAPCompat.registerBAPHeadAlter();
        }
        if (Loader.isModLoaded((String)"thaumcraft")) {
            ThaumcraftCompat.init();
        }
    }

    @Optional.Method(modid="mowziesmobs")
    @SubscribeEvent
    public void registerMowziesBrew(RegistryEvent.Register<Brew> event) {
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "poison_resistance"), Util.get(ItemHandler.NAGA_FANG), new PotionEffect((Potion)PotionHandler.POISON_RESIST, 600)));
    }

    @Optional.Method(modid="consecration")
    @SubscribeEvent
    public void registerConsecrationBrew(RegistryEvent.Register<Brew> event) {
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "consecrated_water"), Util.get(ConsecrationItems.blessedDust), new PotionEffect(ConsecrationPotions.HOLY_POTION, 1)));
    }

    @Optional.Method(modid="quark")
    @SubscribeEvent
    public void registerQuarkBrew(RegistryEvent.Register<Brew> event) {
        event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "prismarine_haste"), Util.get(Items.field_179563_cD), new PotionEffect(MobEffects.field_76422_e, 600)));
        if (ModuleLoader.isFeatureEnabled(Frogs.class)) {
            event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "frog_boost"), Util.get(Frogs.gildedFrogLeg), new PotionEffect(MobEffects.field_76430_j, 600)));
        }
        if (ModuleLoader.isFeatureEnabled(Biotite.class)) {
            event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "biotite_resistance"), Util.get(Biotite.biotite), new PotionEffect(MobEffects.field_76429_m, 600)));
        }
        if (ModuleLoader.isFeatureEnabled(UndergroundBiomes.class) && ExtraPotions.enableDangerSight && UndergroundBiomes.glowceliumEnabled) {
            event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "danger_sight"), Util.get(UndergroundBiomes.glowshroom), new PotionEffect(ExtraPotions.dangerSight, 600)));
        }
        if (ModuleLoader.isFeatureEnabled(CaveRoots.class) && CaveRoots.enableFlowers) {
            event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "blueberry"), Util.get(new ItemStack(CaveRoots.root_flower, 1, 0)), new PotionEffect((Potion)CaveRoots.blue_effect, 600)));
            event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "blackening"), Util.get(new ItemStack(CaveRoots.root_flower, 1, 1)), new PotionEffect((Potion)CaveRoots.black_effect, 600)));
            event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "whitening"), Util.get(new ItemStack(CaveRoots.root_flower, 1, 2)), new PotionEffect((Potion)CaveRoots.white_effect, 600)));
        }
        if (ModuleLoader.isFeatureEnabled(Crabs.class)) {
            event.getRegistry().register((IForgeRegistryEntry)new Brew(new ResourceLocation("bewitchment", "stability"), Util.get(Crabs.crabShell), new PotionEffect((Potion)Crabs.resilience, 600)));
        }
    }
}

