/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.integration.dynamictrees;

import com.bewitchment.Bewitchment;
import com.bewitchment.ModConfig;
import com.bewitchment.Util;
import com.bewitchment.common.integration.dynamictrees.BiomeDataBasePopulator;
import com.bewitchment.common.integration.dynamictrees.DropCreatorFruit;
import com.bewitchment.common.integration.dynamictrees.SaplingReplacer;
import com.bewitchment.common.integration.dynamictrees.TreeCypress;
import com.bewitchment.common.integration.dynamictrees.TreeDragonsBlood;
import com.bewitchment.common.integration.dynamictrees.TreeElder;
import com.bewitchment.common.integration.dynamictrees.TreeJuniper;
import com.bewitchment.registry.ModObjects;
import com.ferreusveritas.dynamictrees.ModItems;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.WorldGenRegistry;
import com.ferreusveritas.dynamictrees.api.client.ModelHelper;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.blocks.LeavesPaging;
import com.ferreusveritas.dynamictrees.blocks.LeavesProperties;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DynamicTreesCompat {
    public static ILeavesProperties cypressLeavesProperties;
    public static ILeavesProperties elderLeavesProperties;
    public static ILeavesProperties juniperLeavesProperties;
    public static ILeavesProperties dragonsbloodLeavesProperties;
    public static TreeFamily cypressTree;
    public static TreeFamily elderTree;
    public static TreeFamily juniperTree;
    public static TreeFamily dragonsbloodTree;

    public static void preInit() {
        IForgeRegistry blockRegistry = ForgeRegistries.BLOCKS;
        cypressLeavesProperties = new LeavesProperties(ModObjects.cypress_leaves.func_176223_P(), new ItemStack(ModObjects.cypress_leaves), TreeRegistry.findCellKit((ResourceLocation)new ResourceLocation("dynamictrees", "conifer")));
        elderLeavesProperties = new LeavesProperties(ModObjects.elder_leaves.func_176223_P(), new ItemStack(ModObjects.elder_leaves));
        juniperLeavesProperties = new LeavesProperties(ModObjects.juniper_leaves.func_176223_P(), new ItemStack(ModObjects.juniper_leaves), TreeRegistry.findCellKit((ResourceLocation)new ResourceLocation("dynamictrees", "acacia")));
        dragonsbloodLeavesProperties = new LeavesProperties(ModObjects.dragons_blood_leaves.func_176223_P(), new ItemStack(ModObjects.dragons_blood_leaves));
        LeavesPaging.getLeavesBlockForSequence((String)"bewitchment", (int)0, (ILeavesProperties)cypressLeavesProperties);
        LeavesPaging.getLeavesBlockForSequence((String)"bewitchment", (int)1, (ILeavesProperties)elderLeavesProperties);
        LeavesPaging.getLeavesBlockForSequence((String)"bewitchment", (int)2, (ILeavesProperties)juniperLeavesProperties);
        LeavesPaging.getLeavesBlockForSequence((String)"bewitchment", (int)3, (ILeavesProperties)dragonsbloodLeavesProperties);
        cypressTree = new TreeCypress();
        elderTree = new TreeElder();
        juniperTree = new TreeJuniper();
        dragonsbloodTree = new TreeDragonsBlood();
        cypressTree.registerSpecies(Species.REGISTRY);
        elderTree.registerSpecies(Species.REGISTRY);
        juniperTree.registerSpecies(Species.REGISTRY);
        dragonsbloodTree.registerSpecies(Species.REGISTRY);
        ((Species)Species.REGISTRY.getValue(new ResourceLocation("dynamictrees", "oak"))).addDropCreator((IDropCreator)new DropCreatorFruit(ModObjects.oak_apple_gall, 30));
        ArrayList treeBlocks = new ArrayList();
        cypressTree.getRegisterableBlocks(treeBlocks);
        elderTree.getRegisterableBlocks(treeBlocks);
        juniperTree.getRegisterableBlocks(treeBlocks);
        dragonsbloodTree.getRegisterableBlocks(treeBlocks);
        treeBlocks.addAll(LeavesPaging.getLeavesMapForModId((String)"bewitchment").values());
        blockRegistry.registerAll((IForgeRegistryEntry[])treeBlocks.toArray(new Block[treeBlocks.size()]));
        ArrayList treeItems = new ArrayList();
        cypressTree.getRegisterableItems(treeItems);
        dragonsbloodTree.getRegisterableItems(treeItems);
        elderTree.getRegisterableItems(treeItems);
        juniperTree.getRegisterableItems(treeItems);
        for (Item toRegister : treeItems) {
            toRegister.func_77655_b(toRegister.getRegistryName().toString().replace(":", "."));
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)toRegister);
            Bewitchment.proxy.registerTexture(toRegister, "normal");
        }
        if (ModConfig.compat.replaceSapling) {
            MinecraftForge.EVENT_BUS.register((Object)new SaplingReplacer());
        }
        ResourceLocation seedConvertion = new ResourceLocation("bewitchment", "seeds");
        GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("bewitchment", "cypress"), (ResourceLocation)seedConvertion, (ItemStack)cypressTree.getCommonSpecies().getSeedStack(1), (Ingredient[])new Ingredient[]{Util.get(ModObjects.cypress_sapling), Util.get(ModItems.dirtBucket)});
        GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("bewitchment", "dragonsblood"), (ResourceLocation)seedConvertion, (ItemStack)dragonsbloodTree.getCommonSpecies().getSeedStack(1), (Ingredient[])new Ingredient[]{Util.get(ModObjects.dragons_blood_sapling), Util.get(ModItems.dirtBucket)});
    }

    public static void init() {
    }

    @SideOnly(value=Side.CLIENT)
    public static void clientPreInit() {
        ModelHelper.regModel((TreeFamily)cypressTree);
        ModelHelper.regModel((TreeFamily)elderTree);
        ModelHelper.regModel((TreeFamily)juniperTree);
        ModelHelper.regModel((TreeFamily)dragonsbloodTree);
        ModelHelper.regModel((Block)cypressTree.getDynamicBranch());
        ModelHelper.regModel((Block)elderTree.getDynamicBranch());
        ModelHelper.regModel((Block)juniperTree.getDynamicBranch());
        ModelHelper.regModel((Block)dragonsbloodTree.getDynamicBranch());
        LeavesPaging.getLeavesMapForModId((String)"bewitchment").forEach((key, leaves) -> ModelLoader.setCustomStateMapper((Block)leaves, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176237_a}).func_178441_a()));
    }

    public static boolean replaceWorldGen() {
        return ModConfig.compat.genDynamic && WorldGenRegistry.isWorldGenEnabled();
    }

    public static void addFurnaceRecipes() {
        ForgeRegistries.ITEMS.getValuesCollection().stream().filter(i -> i instanceof Seed).filter(i -> i.getRegistryName().toString().toLowerCase().contains("cactus") && FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(i)).func_190926_b()).forEach(i -> GameRegistry.addSmelting((Item)i, (ItemStack)new ItemStack(ModObjects.wood_ash, 1), (float)0.15f));
    }

    @Optional.Method(modid="dynamictrees")
    @SubscribeEvent
    public void registerDataBasePopulators(WorldGenRegistry.BiomeDataBasePopulatorRegistryEvent event) {
        event.register((IBiomeDataBasePopulator)new BiomeDataBasePopulator());
    }
}

