/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.integration.dynamictrees;

import com.bewitchment.common.integration.dynamictrees.DropCreatorFruit;
import com.bewitchment.common.integration.dynamictrees.DynamicTreesCompat;
import com.bewitchment.registry.ModObjects;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.blocks.BlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenClearVolume;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenRoots;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class TreeDragonsBlood
extends TreeFamily {
    private final BlockSurfaceRoot surfaceRootBlock;

    public TreeDragonsBlood() {
        super(new ResourceLocation("bewitchment", "dragonsblood"));
        IBlockState primLog = ModObjects.dragons_blood_wood.func_176223_P();
        this.setPrimitiveLog(primLog, new ItemStack(ModObjects.dragons_blood_wood));
        DynamicTreesCompat.dragonsbloodLeavesProperties.setTree((TreeFamily)this);
        this.surfaceRootBlock = new BlockSurfaceRoot(Material.field_151575_d, this.getName() + "root");
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesDragonsBlood(this));
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList.add((Block)this.surfaceRootBlock);
        return super.getRegisterableBlocks(blockList);
    }

    public BlockSurfaceRoot getSurfaceRoots() {
        return this.surfaceRootBlock;
    }

    public class SpeciesDragonsBlood
    extends Species {
        SpeciesDragonsBlood(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, DynamicTreesCompat.dragonsbloodLeavesProperties);
            this.setBasicGrowingParameters(0.4f, 14.0f, 4, 4, 1.0f);
            this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
            this.generateSeed();
            this.setupStandardSeedDropping();
            this.addDropCreator((IDropCreator)new DropCreatorFruit(ModObjects.dragons_blood_resin, 10));
            this.addGenFeature((IGenFeature)new FeatureGenClearVolume(6));
            this.addGenFeature((IGenFeature)new FeatureGenRoots(7).setScaler(this.getRootScaler()));
        }

        protected BiFunction<Integer, Integer, Integer> getRootScaler() {
            return (inRadius, trunkRadius) -> {
                float scale = MathHelper.func_76131_a((float)(trunkRadius >= 8 ? (float)trunkRadius.intValue() / 20.0f : 0.0f), (float)0.0f, (float)1.0f);
                return (int)((float)inRadius.intValue() * scale);
            };
        }

        public boolean isThick() {
            return false;
        }

        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            EnumFacing originDir = signal.dir.func_176734_d();
            probMap[0] = 0;
            if ((double)signal.energy < 3.5 && signal.energy > 1.0f) {
                probMap[1] = 1;
                probMap[5] = 0;
                probMap[4] = 0;
                probMap[3] = 0;
                probMap[2] = 0;
            } else {
                float r = Math.max(Math.abs(signal.delta.func_177958_n()), Math.abs(signal.delta.func_177952_p()));
                probMap[5] = 3;
                probMap[4] = 3;
                probMap[3] = 3;
                probMap[2] = 3;
                probMap[1] = 1 + (int)((double)r * 2.5);
                if (signal.delta.func_177952_p() > 0) {
                    probMap[2] = 0;
                }
                if (signal.delta.func_177952_p() < 0) {
                    probMap[3] = 0;
                }
                if (signal.delta.func_177958_n() > 0) {
                    probMap[4] = 0;
                }
                if (signal.delta.func_177958_n() < 0) {
                    probMap[5] = 0;
                }
                probMap[originDir.ordinal()] = 0;
                int n = signal.dir.ordinal();
                probMap[n] = probMap[n] + (signal.dir == EnumFacing.UP ? (int)(((double)r - 1.75) * 1.5) : 0);
            }
            return probMap;
        }

        protected EnumFacing newDirectionSelected(EnumFacing newDir, GrowSignal signal) {
            if (newDir != EnumFacing.UP) {
                signal.energy += 0.75f;
            }
            if (newDir == EnumFacing.UP && signal.dir != EnumFacing.UP) {
                signal.energy += ((float)Math.max(Math.abs(signal.delta.func_177958_n()), Math.abs(signal.delta.func_177952_p())) - 2.0f) * 1.5f;
            }
            return newDir;
        }

        public boolean isBiomePerfect(Biome biome) {
            return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA);
        }
    }
}

