/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.world;

import com.bewitchment.api.BewitchmentAPI;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeChangingUtils {
    public static void changeWholeBiome(BlockPos pos, Biome newBiome, World world) {
        int id = Biome.func_185362_a((Biome)newBiome);
        Chunk ch = world.func_175726_f(pos);
        byte[] array = ch.func_76605_m();
        for (int i = 0; i < 255; ++i) {
            BiomeChangingUtils.setArrayValue(array, id, i);
        }
        ch.func_76630_e();
        BiomeChangingUtils.refreshChunk(ch);
    }

    private static boolean setArrayValue(Object array, int value, int index) {
        if (int[].class.isAssignableFrom(array.getClass())) {
            if (((int[])array)[index] == value) {
                return false;
            }
            ((int[])array)[index] = value;
            return true;
        }
        if (((byte[])array)[index] == (byte)(value & 0xFF)) {
            return false;
        }
        ((byte[])array)[index] = (byte)(value & 0xFF);
        return true;
    }

    private static void refreshChunk(Chunk ch) {
        ch.func_177412_p().func_73046_m().func_184103_al().func_181057_v().stream().forEach(p -> p.field_71135_a.func_147359_a((Packet)new SPacketChunkData(ch, 65535)));
    }

    public static class BiomeChangerWalker {
        private boolean complete = false;
        private int biomeId;
        private Set<Chunk> chunkSet = Sets.newHashSet();

        public BiomeChangerWalker(Biome destinationBiome) {
            this(Biome.func_185362_a((Biome)destinationBiome));
        }

        public BiomeChangerWalker(int destinationBiomeId) {
            if (destinationBiomeId < 0) {
                throw new IllegalArgumentException("Biome ID must be positive, it was " + destinationBiomeId);
            }
            this.biomeId = destinationBiomeId;
        }

        public boolean visit(Chunk ch, BlockPos pos) {
            if (BiomeDictionary.hasType((Biome)ch.func_177412_p().func_180494_b(pos), (BiomeDictionary.Type)BewitchmentAPI.getAPI().IMMUTABLE)) {
                return false;
            }
            return this.visitImmutable(ch, pos);
        }

        public boolean visit(World world, BlockPos pos) {
            return this.visit(world.func_175726_f(pos), pos);
        }

        public boolean visitImmutable(Chunk ch, BlockPos pos) {
            if (this.complete) {
                throw new IllegalStateException("Cannot walk after completion!");
            }
            this.chunkSet.add(ch);
            return BiomeChangingUtils.setArrayValue(ch.func_76605_m(), this.biomeId, pos.func_177958_n() - ch.field_76635_g * 16 + 16 * (pos.func_177952_p() - ch.field_76647_h * 16));
        }

        public boolean visitImmutable(World world, BlockPos pos) {
            return this.visitImmutable(world.func_175726_f(pos), pos);
        }

        public void complete() {
            if (this.complete) {
                throw new IllegalStateException("Cannot complete the same walker multiple times!");
            }
            this.complete = true;
            for (Chunk ch : this.chunkSet) {
                ch.func_76630_e();
                BiomeChangingUtils.refreshChunk(ch);
            }
        }
    }
}

