/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.world.gen;

import com.bewitchment.ModConfig;
import com.bewitchment.common.integration.dynamictrees.DynamicTreesCompat;
import com.bewitchment.common.world.gen.structures.WorldGenMenhir;
import com.bewitchment.common.world.gen.structures.WorldGenStonecircle;
import com.bewitchment.common.world.gen.structures.WorldGenWickerman;
import com.bewitchment.common.world.gen.tree.WorldGenCypressTree;
import com.bewitchment.common.world.gen.tree.WorldGenElderTree;
import com.bewitchment.common.world.gen.tree.WorldGenJuniperTree;
import com.bewitchment.registry.ModObjects;
import java.util.Arrays;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;

public class ModWorldGen
implements IWorldGenerator {
    private final WorldGenerator cypressTree = new WorldGenCypressTree(true);
    private final WorldGenerator elderTree = new WorldGenElderTree(true);
    private final WorldGenerator juniperTree = new WorldGenJuniperTree(true);
    private final WorldGenerator silverOre;
    private final WorldGenerator saltOre;
    private final WorldGenerator amethystOre;
    private final WorldGenerator garnetOre;
    private final WorldGenerator opalOre;
    private final WorldGenerator wickerman;
    private final WorldGenerator stonecircle;
    private final WorldGenerator menhir;

    public ModWorldGen() {
        this.silverOre = new WorldGenMinable(ModObjects.silver_ore.func_176223_P(), ModConfig.worldGen.oreGen.silverSize);
        this.saltOre = new WorldGenMinable(ModObjects.salt_ore.func_176223_P(), ModConfig.worldGen.oreGen.saltSize);
        this.amethystOre = new WorldGenMinable(ModObjects.amethyst_ore.func_176223_P(), ModConfig.worldGen.oreGen.amethystSize);
        this.garnetOre = new WorldGenMinable(ModObjects.garnet_ore.func_176223_P(), ModConfig.worldGen.oreGen.garnetSize);
        this.opalOre = new WorldGenMinable(ModObjects.opal_ore.func_176223_P(), ModConfig.worldGen.oreGen.opalSize);
        this.wickerman = new WorldGenWickerman();
        this.stonecircle = new WorldGenStonecircle();
        this.menhir = new WorldGenMenhir();
        MinecraftForge.addGrassSeed((ItemStack)new ItemStack(ModObjects.aconitum_seeds), (int)3);
        MinecraftForge.addGrassSeed((ItemStack)new ItemStack(ModObjects.belladonna_seeds), (int)3);
        MinecraftForge.addGrassSeed((ItemStack)new ItemStack(ModObjects.hellebore_seeds), (int)3);
        MinecraftForge.addGrassSeed((ItemStack)new ItemStack(ModObjects.mandrake_seeds), (int)3);
        MinecraftForge.addGrassSeed((ItemStack)new ItemStack(ModObjects.wormwood_seeds), (int)3);
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("bewitchment", "chests/nether_materials"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("bewitchment", "chests/materials"));
    }

    private static int getGround(World world, int x, int z) {
        int y = world.func_189649_b(x, z);
        boolean foundGround = false;
        while (!foundGround && y-- >= 31) {
            Block blockAt = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            boolean bl = foundGround = blockAt == Blocks.field_150349_c || blockAt == Blocks.field_150354_m || blockAt == Blocks.field_150433_aE || blockAt == Blocks.field_150431_aC || blockAt == Blocks.field_150359_w || blockAt == Blocks.field_150391_bh;
            if (blockAt != Blocks.field_150358_i && blockAt != Blocks.field_150355_j) continue;
            y = -1;
            break;
        }
        return y;
    }

    public static boolean canSpawnHere(Template template, World world, BlockPos posAboveGround) {
        int zwidth = template.func_186259_a().func_177952_p();
        int xwidth = template.func_186259_a().func_177958_n();
        boolean corner1 = ModWorldGen.isCornerValid(world, posAboveGround);
        boolean corner2 = ModWorldGen.isCornerValid(world, posAboveGround.func_177982_a(xwidth, 0, zwidth));
        return posAboveGround.func_177956_o() > 31 && corner1 && corner2;
    }

    private static boolean isCornerValid(World world, BlockPos pos) {
        int highestBlock = ModWorldGen.getGround(world, pos.func_177958_n(), pos.func_177952_p());
        return highestBlock > pos.func_177956_o() - 1 && highestBlock < pos.func_177956_o() + 3;
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator generator, IChunkProvider provider) {
        if (Arrays.asList(ModConfig.worldGen.worldGenWhitelist).contains(world.field_73011_w.getDimension())) {
            this.generateCoquina(world, rand, chunkX, chunkZ);
            this.generateOre(world, rand, this.silverOre, chunkX, chunkZ, ModConfig.worldGen.oreGen.silverChance, ModConfig.worldGen.oreGen.silverMin, ModConfig.worldGen.oreGen.silverMax);
            this.generateOre(world, rand, this.saltOre, chunkX, chunkZ, ModConfig.worldGen.oreGen.saltChance, ModConfig.worldGen.oreGen.saltMin, ModConfig.worldGen.oreGen.saltMax);
            this.generateOre(world, rand, this.amethystOre, chunkX, chunkZ, ModConfig.worldGen.oreGen.amethystChance, ModConfig.worldGen.oreGen.amethystMin, ModConfig.worldGen.oreGen.amethystMax);
            this.generateOre(world, rand, this.garnetOre, chunkX, chunkZ, ModConfig.worldGen.oreGen.garnetChance, ModConfig.worldGen.oreGen.garnetMin, ModConfig.worldGen.oreGen.garnetMax);
            this.generateOre(world, rand, this.opalOre, chunkX, chunkZ, ModConfig.worldGen.oreGen.opalChance, ModConfig.worldGen.oreGen.opalMin, ModConfig.worldGen.oreGen.opalMax);
            ResourceLocation biomeResource = world.func_180494_b(new BlockPos(chunkX * 16 + 8, world.func_72800_K(), chunkZ * 16 + 8)).getRegistryName();
            if (biomeResource != null && !Arrays.asList(ModConfig.worldGen.treeGen.treeGenBlacklist).contains(biomeResource.func_110623_a())) {
                if (!Loader.isModLoaded((String)"dynamictrees") || !DynamicTreesCompat.replaceWorldGen()) {
                    this.generateTree(world, rand, this.cypressTree, ModObjects.cypress_sapling, chunkX, chunkZ, ModConfig.worldGen.treeGen.cypressChance, b -> BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && (BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) || BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY)));
                    this.generateTree(world, rand, this.elderTree, ModObjects.elder_sapling, chunkX, chunkZ, ModConfig.worldGen.treeGen.elderChance, b -> BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && !BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.COLD));
                    this.generateTree(world, rand, this.juniperTree, ModObjects.juniper_sapling, chunkX, chunkZ, ModConfig.worldGen.treeGen.juniperChance, b -> BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA) || BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL));
                }
                this.generateMoss(world, rand, chunkX, chunkZ, b -> BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
            }
        }
        if (ModConfig.worldGen.enableStructures && world.field_73011_w.getDimension() == 0) {
            this.generateStructure(this.wickerman, world, rand, ModConfig.worldGen.structureGen.wickermanChance, chunkX, chunkZ, b -> BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH));
            this.generateStructure(this.stonecircle, world, rand, ModConfig.worldGen.structureGen.stonecircleChance, chunkX, chunkZ, b -> BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
            this.generateStructure(this.menhir, world, rand, ModConfig.worldGen.structureGen.menhirChance, chunkX, chunkZ, b -> BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || b == Biomes.field_76768_g || b == Biomes.field_150584_S || b == Biomes.field_150578_U);
        }
    }

    private void generateCoquina(World world, Random rand, int chunkX, int chunkZ) {
        if (rand.nextInt(6) == 0) {
            BlockPos pos = world.func_175645_m(new BlockPos(chunkX * 16 + rand.nextInt(16), 0, chunkZ * 16 + rand.nextInt(16)));
            if (BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.BEACH).contains(world.func_180494_b(pos)) || BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN).contains(world.func_180494_b(pos))) {
                while (world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150354_m) {
                    for (int i = 0; i < 3; ++i) {
                        int x = rand.nextInt(2);
                        int y = rand.nextInt(2);
                        int z = rand.nextInt(2);
                        for (BlockPos blockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-x, -y, -z), (BlockPos)pos.func_177982_a(x, y, z))) {
                            if (!(blockpos.func_177951_i((Vec3i)pos) <= Math.pow((float)(x + y + z) * 0.333f + 0.5f, 2.0))) continue;
                            world.func_180501_a(blockpos, ModObjects.coquina[0].func_176223_P(), 2);
                        }
                        pos = pos.func_177982_a(rand.nextInt(2) - 1, -rand.nextInt(2), rand.nextInt(2) - 1);
                    }
                    pos = pos.func_177977_b();
                }
            }
        }
    }

    private void generateOre(World world, Random rand, WorldGenerator gen, int chunkX, int chunkZ, int chance, int minHeight, int maxHeight) {
        for (int i = 0; i < chance; ++i) {
            gen.func_180709_b(world, rand, new BlockPos(chunkX * 16 + rand.nextInt(16), rand.nextInt(maxHeight - minHeight) + minHeight, chunkZ * 16 + rand.nextInt(16)));
        }
    }

    private void generateTree(World world, Random rand, WorldGenerator gen, Block block, int chunkX, int chunkZ, double chance, Predicate<Biome> predicate) {
        int z;
        int x;
        BlockPos pos;
        Biome biome;
        if (chance != 0.0 && rand.nextDouble() < chance && predicate.test(biome = world.func_180494_b(pos = new BlockPos(x = chunkX * 16 + 8, world.func_189649_b(x, z = chunkZ * 16 + 8), z))) && block.func_176196_c(world, pos)) {
            gen.func_180709_b(world, rand, pos);
        }
    }

    private void generateMoss(World world, Random rand, int chunkX, int chunkZ, Predicate<Biome> predicate) {
        BlockPos position = new BlockPos(chunkX * 16 + 8, 64, chunkZ * 16 + 8);
        Biome biome = world.func_180494_b(position);
        if (!predicate.test(biome)) {
            return;
        }
        while (position.func_177956_o() < 128) {
            if (world.func_175623_d(position)) {
                for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL.func_179516_a()) {
                    if (!ModObjects.spanish_moss.func_176198_a(world, position, enumfacing)) continue;
                    IBlockState iblockstate = ModObjects.spanish_moss.func_176223_P().func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf(enumfacing == EnumFacing.NORTH)).func_177226_a((IProperty)BlockVine.field_176280_O, (Comparable)Boolean.valueOf(enumfacing == EnumFacing.EAST)).func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf(enumfacing == EnumFacing.SOUTH)).func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(enumfacing == EnumFacing.WEST));
                    BlockPos pos = position;
                    for (int i = 5; world.func_175623_d(pos) && i > 0; --i) {
                        world.func_180501_a(pos, iblockstate, 3);
                        pos = position.func_177977_b();
                    }
                    break;
                }
            } else {
                position = position.func_177982_a(rand.nextInt(4) - rand.nextInt(4), 0, rand.nextInt(4) - rand.nextInt(4));
            }
            position = position.func_177984_a();
        }
    }

    private void generateStructure(WorldGenerator structure, World world, Random rand, double chance, int chunkX, int chunkz, Predicate<Biome> biomes) {
        BlockPos pos = new BlockPos(chunkX * 16, ModWorldGen.getGround(world, chunkX * 16, chunkz * 16), chunkz * 16);
        if (rand.nextDouble() < chance && biomes.test(world.func_180494_b(pos)) && biomes.test(world.func_180494_b(pos.func_177982_a(7, 0, 7)))) {
            structure.func_180709_b(world, rand, pos);
        }
    }
}

