/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.gui.config;

import java.util.List;
import java.util.Objects;
import net.mcft.copy.backpacks.client.gui.config.BaseEntry;
import net.mcft.copy.backpacks.client.gui.config.IConfigValue;
import net.mcft.copy.backpacks.config.Setting;
import net.mcft.copy.backpacks.config.Status;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntrySetting<T>
extends BaseEntry.Value<T> {
    public final Setting<T> setting;

    public EntrySetting(Setting<T> setting, IConfigValue<T> control) {
        super(EntrySetting.setup(control, setting), setting.getDefault(), setting.getOwn());
        this.setting = setting;
        this.setting.setEntry(this);
        this.setLabelAndTooltip(setting.getFullName(), Objects.toString(setting.getDefault()), setting.requiresMinecraftRestart() ? "fml.configgui.gameRestartTitle" : null);
    }

    private static <T> IConfigValue<T> setup(IConfigValue<T> control, Setting<T> setting) {
        if (control instanceof IConfigValue.Setup) {
            ((IConfigValue.Setup)((Object)control)).setup(setting);
        }
        return control;
    }

    @Override
    public List<Status> getStatus() {
        List<Status> status = super.getStatus();
        status.addAll(0, this.setting.getStatusConfig());
        return status;
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.setting.isEnabledConfig();
    }

    @Override
    public Setting.ChangeRequiredAction applyChanges() {
        if (!this.isChanged()) {
            return Setting.ChangeRequiredAction.None;
        }
        this.setting.set(this.getValue().get());
        if (!this.setting.requiresMinecraftRestart()) {
            this.setting.update();
        }
        return this.setting.getChangeRequiredAction();
    }
}

