/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.gui.config.custom;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.mcft.copy.backpacks.client.gui.Direction;
import net.mcft.copy.backpacks.client.gui.GuiElementBase;
import net.mcft.copy.backpacks.client.gui.GuiLayout;
import net.mcft.copy.backpacks.client.gui.config.IConfigValue;
import net.mcft.copy.backpacks.config.Status;

public class EntryValueMulti<T>
extends GuiLayout
implements IConfigValue<List<T>> {
    public EntryValueMulti(int count, Class<? extends IConfigValue<T>> elementClass) {
        super(Direction.HORIZONTAL);
        if (count < 2) {
            throw new IllegalArgumentException("count must be at least 2");
        }
        try {
            for (int i = 0; i < count; ++i) {
                this.addWeighted((GuiElementBase)((Object)elementClass.newInstance()));
            }
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Optional<List<T>> getValue() {
        List values = this.children.stream().map(IConfigValue.class::cast).map(IConfigValue::getValue).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return values.size() == this.children.size() ? Optional.of(values) : Optional.empty();
    }

    @Override
    public void setValue(List<T> value) {
        if (value.size() != this.children.size()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ((IConfigValue)this.children.get(i)).setValue(value.get(i));
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks) {
        if (this.children.get(0) instanceof IConfigValue.ShowsStatus) {
            for (GuiElementBase child : this.children) {
                Optional value = ((IConfigValue)((Object)child)).getValue();
                ((IConfigValue.ShowsStatus)((Object)child)).setStatus(value.isPresent() ? Collections.emptyList() : Arrays.asList(Status.INVALID));
            }
        }
        super.draw(mouseX, mouseY, partialTicks);
    }
}

