/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.config;

import net.mcft.copy.backpacks.config.SettingSingleValue;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraftforge.common.config.Property;

public class SettingInteger
extends SettingSingleValue<Integer> {
    private int _minValue = Integer.MIN_VALUE;
    private int _maxValue = Integer.MAX_VALUE;

    public int getMinValue() {
        return this._minValue;
    }

    public int getMaxValue() {
        return this._maxValue;
    }

    public SettingInteger(int defaultValue) {
        super(defaultValue);
        this.setConfigEntryClass("net.mcft.copy.backpacks.client.gui.config.EntryValueField$Number");
    }

    public SettingInteger setValidRange(int min, int max) {
        this._minValue = min;
        this._maxValue = max;
        return this;
    }

    @Override
    protected Property.Type getPropertyType() {
        return Property.Type.INTEGER;
    }

    @Override
    public Integer parse(String str) {
        int i = Integer.parseInt(str);
        if (i < this._minValue || i > this._maxValue) {
            throw new IllegalArgumentException("Not within valid bounds [" + this._minValue + "," + this._maxValue + "]");
        }
        return i;
    }

    @Override
    public Integer read(NBTBase tag) {
        return ((NBTTagInt)tag).func_150287_d();
    }

    @Override
    public NBTBase write(Integer value) {
        return new NBTTagInt(value.intValue());
    }
}

