/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.config;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.mcft.copy.backpacks.config.Setting;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Status {
    public static final Status NONE = Status.FINE();
    public static final Status EMPTY = Status.ERROR();
    public static final Status INVALID = Status.ERROR();
    public final Severity severity;
    private final String _translateKey;
    private final Object[] _translateParams;

    public static Status OUT_OF_RANGE(Object min, Object max) {
        return Status.ERROR("general", "outOfRange", min, max);
    }

    public static Status REQUIRED(Setting<?> value) {
        return Status.ERROR("general", "required", value.getFullName());
    }

    public static Status RECOMMENDED(Setting<?> value, String key) {
        return Status.HINT("general", key, value.getFullName());
    }

    private Status(Severity severity, String translateKey, Object[] translateParams) {
        this.severity = severity;
        this._translateKey = translateKey;
        this._translateParams = translateParams;
    }

    private static Status constructStatus(Severity severity, String category, String key, Object ... args) {
        return new Status(severity, "config.wearablebackpacks." + category + ".status." + key, args);
    }

    public static Status FINE() {
        return new Status(Severity.FINE, null, null);
    }

    public static Status FINE(String category, String key, Object ... args) {
        return Status.constructStatus(Severity.FINE, category, key, args);
    }

    public static Status HINT() {
        return new Status(Severity.HINT, null, null);
    }

    public static Status HINT(String category, String key, Object ... args) {
        return Status.constructStatus(Severity.HINT, category, key, args);
    }

    public static Status WARN() {
        return new Status(Severity.WARN, null, null);
    }

    public static Status WARN(String category, String key, Object ... args) {
        return Status.constructStatus(Severity.WARN, category, key, args);
    }

    public static Status ERROR() {
        return new Status(Severity.ERROR, null, null);
    }

    public static Status ERROR(String category, String key, Object ... args) {
        return Status.constructStatus(Severity.ERROR, category, key, args);
    }

    public static Severity getSeverity(List<Status> status) {
        return status.stream().map(s -> s.severity).max(Enum::compareTo).orElse(Severity.FINE);
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> getMessage(List<Status> status) {
        return status.stream().filter(s -> s._translateKey != null).sorted(Comparator.comparingInt(s -> -s.severity.ordinal())).map(s -> "\u00a7" + s.severity.colorChar + I18n.func_135052_a((String)s._translateKey, (Object[])s._translateParams)).collect(Collectors.toList());
    }

    public static enum Severity {
        FINE('f', 0),
        HINT('2', 0x2000D000),
        WARN('e', 820039680),
        ERROR('c', 0x40D00000);

        public final char colorChar;
        public final int foregroundColor;
        public final int backgroundColor;
        public final int guiIconIndex;

        private Severity(char chr, int background) {
            this.colorChar = chr;
            this.foregroundColor = 0xFF000000 | GuiUtils.getColorCode((char)chr, (boolean)true);
            this.backgroundColor = background;
            this.guiIconIndex = this.ordinal();
        }
    }
}

