/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.bloodyquests;

import WayofTime.bloodmagic.event.RitualEvent;
import WayofTime.bloodmagic.tile.TileAlchemyTable;
import WayofTime.bloodmagic.tile.TileAltar;
import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.registry.IFactoryData;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.tasks.TaskRegistry;
import bq_standard.tasks.TaskCrafting;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import xyz.brassgoggledcoders.bloodyquests.TaskRunRitual;
import xyz.brassgoggledcoders.bloodyquests.TaskRunRitualFactory;

@Mod(modid="bloodyquests", name="Bloody Quests", version="1.12.2-2.0.0.null", dependencies="required-after:bloodmagic; required-after:bq_standard", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class BloodyQuests {
    public static final String MODID = "bloodyquests";

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        TaskRegistry.INSTANCE.register((IFactoryData)new TaskRunRitualFactory());
    }

    @SubscribeEvent
    public static void onRitualRun(RitualEvent.RitualActivatedEvent event) {
        World world = event.getRitualStone().getWorldObj();
        EntityPlayer player = event.getPlayer();
        if (player == null || world.field_72995_K) {
            return;
        }
        QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc != null) {
            List activeQuests = QuestDatabase.INSTANCE.bulkLookup(qc.getActiveQuests());
            activeQuests.stream().map(entry -> (IQuest)entry.getValue()).filter(quest -> quest.isUnlocked(player.func_110124_au()) && quest.canSubmit(player)).forEach(quest -> quest.getTasks().getEntries().stream().filter(task -> task.getValue() instanceof TaskRunRitual).forEach(task -> ((TaskRunRitual)task.getValue()).onRitualRun(world, player, event.getRitual())));
        }
    }

    @SubscribeEvent
    public static void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        block4: {
            ParticipantInfo pInfo;
            TileEntity te;
            block5: {
                EntityPlayer player = event.getEntityPlayer();
                te = event.getWorld().func_175625_s(event.getPos());
                if (player == null || event.getWorld().field_72995_K || te == null) break block4;
                pInfo = new ParticipantInfo(player);
                if (!(te instanceof TileAltar)) break block5;
                TileAltar altar = (TileAltar)te;
                List actQuest = ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(pInfo.getSharedQuests());
                for (DBEntry entry : actQuest) {
                    for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                        if (!(task.getValue() instanceof TaskCrafting)) continue;
                        ((TaskCrafting)task.getValue()).onItemCraft(pInfo, entry, altar.func_70301_a(0));
                    }
                }
                break block4;
            }
            if (!(te instanceof TileAlchemyTable)) break block4;
            TileAlchemyTable table = (TileAlchemyTable)te;
            List actQuest = ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(pInfo.getSharedQuests());
            for (DBEntry entry : actQuest) {
                for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                    if (!(task.getValue() instanceof TaskCrafting)) continue;
                    ((TaskCrafting)task.getValue()).onItemCraft(pInfo, entry, table.func_70301_a(8));
                }
            }
        }
    }
}

