/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.api.data;

import codersafterdark.reskillable.api.ReskillableAPI;
import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.requirement.NoneRequirement;
import codersafterdark.reskillable.api.requirement.Requirement;
import codersafterdark.reskillable.api.requirement.RequirementComparision;
import codersafterdark.reskillable.api.requirement.logic.TrueRequirement;
import codersafterdark.reskillable.base.ConfigHandler;
import codersafterdark.reskillable.lib.LibObfuscation;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.AdvancementList;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RequirementHolder {
    private static AdvancementList advList;
    private final List<Requirement> requirements;
    private final boolean forcedEmpty;
    private boolean hasNone;

    public RequirementHolder() {
        this.requirements = Lists.newArrayList();
        this.forcedEmpty = true;
    }

    public RequirementHolder(List<Requirement> requirements) {
        this.requirements = requirements;
        this.forcedEmpty = false;
    }

    public RequirementHolder(RequirementHolder ... others) {
        this.requirements = Lists.newArrayList();
        this.forcedEmpty = false;
        for (RequirementHolder other : others) {
            if (other.hasNone) {
                this.requirements.addAll(other.requirements);
                this.hasNone = true;
                break;
            }
            other.requirements.forEach(otherRequirement -> RequirementHolder.addRequirement(this.requirements, otherRequirement));
        }
    }

    public static RequirementHolder noneHolder() {
        RequirementHolder requirementHolder = new RequirementHolder(new ArrayList<Requirement>());
        requirementHolder.hasNone = true;
        requirementHolder.requirements.add(new NoneRequirement());
        return requirementHolder;
    }

    public static RequirementHolder realEmpty() {
        return new RequirementHolder();
    }

    public static RequirementHolder fromStringList(String[] requirementStringList) {
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        for (String s : requirementStringList) {
            Requirement requirement = ReskillableAPI.getInstance().getRequirementRegistry().getRequirement(s);
            if (requirement instanceof NoneRequirement) {
                return RequirementHolder.noneHolder();
            }
            RequirementHolder.addRequirement(requirements, requirement);
        }
        return requirements.isEmpty() ? RequirementHolder.realEmpty() : new RequirementHolder(requirements);
    }

    public static RequirementHolder fromString(String s) {
        RequirementHolder requirementHolder = s.matches("(?i)^(null|nil)$") ? RequirementHolder.realEmpty() : RequirementHolder.fromStringList(s.split(","));
        return requirementHolder;
    }

    private static void addRequirement(List<Requirement> requirements, Requirement requirement) {
        if (requirement == null || requirement instanceof TrueRequirement) {
            return;
        }
        for (int i = 0; i < requirements.size(); ++i) {
            RequirementComparision match = requirements.get(i).matches(requirement);
            if (match.equals((Object)RequirementComparision.EQUAL_TO) || match.equals((Object)RequirementComparision.GREATER_THAN)) {
                return;
            }
            if (!match.equals((Object)RequirementComparision.LESS_THAN)) continue;
            requirements.remove(i);
            break;
        }
        requirements.add(requirement);
    }

    public static AdvancementList getAdvancementList() {
        if (advList == null) {
            advList = (AdvancementList)ReflectionHelper.getPrivateValue(AdvancementManager.class, null, (String[])LibObfuscation.ADVANCEMENT_LIST);
        }
        return advList;
    }

    public boolean isRealLock() {
        return this.getRestrictionLength() > 0 && !this.forcedEmpty;
    }

    public boolean isForcedEmpty() {
        return this.forcedEmpty;
    }

    public int getRestrictionLength() {
        return this.requirements.size();
    }

    @SideOnly(value=Side.CLIENT)
    public void addRequirementsToTooltip(PlayerData data, List<String> tooltip) {
        if (!this.isRealLock()) {
            return;
        }
        if (!ConfigHandler.hideRequirements || GuiScreen.func_146272_n()) {
            tooltip.add(TextFormatting.DARK_PURPLE + new TextComponentTranslation("reskillable.misc.requirements", new Object[0]).func_150261_e());
            this.addRequirementsIgnoreShift(data, tooltip);
        } else {
            tooltip.add(TextFormatting.DARK_PURPLE + new TextComponentTranslation("reskillable.misc.requirements_shift", new Object[0]).func_150261_e());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addRequirementsIgnoreShift(PlayerData data, List<String> tooltip) {
        if (this.isRealLock()) {
            this.requirements.stream().map(requirement -> requirement.getToolTip(data)).forEach(tooltip::add);
        }
    }

    public List<Requirement> getRequirements() {
        return this.requirements;
    }

    public boolean hasNone() {
        return this.hasNone;
    }
}

