/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.api.requirement.logic;

import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.requirement.Requirement;
import codersafterdark.reskillable.api.requirement.RequirementCache;
import codersafterdark.reskillable.api.requirement.logic.OuterRequirement;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;

public abstract class DoubleRequirement
extends Requirement
implements OuterRequirement {
    private final Requirement left;
    private final Requirement right;

    protected DoubleRequirement(Requirement left, Requirement right) {
        this.left = left;
        this.right = right;
    }

    public Requirement getLeft() {
        return this.left;
    }

    public Requirement getRight() {
        return this.right;
    }

    protected abstract String getFormat();

    protected boolean leftAchieved(EntityPlayer player) {
        return RequirementCache.requirementAchieved(player, this.getLeft());
    }

    protected boolean rightAchieved(EntityPlayer player) {
        return RequirementCache.requirementAchieved(player, this.getRight());
    }

    @Override
    public String getToolTip(PlayerData data) {
        TextFormatting color = data == null || !data.requirementAchieved(this) ? TextFormatting.RED : TextFormatting.GREEN;
        return TextFormatting.GRAY + " - " + this.getToolTipPart(data, this.getLeft()) + ' ' + color + this.getFormat() + ' ' + this.getToolTipPart(data, this.getRight());
    }

    private String getToolTipPart(PlayerData data, Requirement side) {
        String tooltip = side.getToolTip(data);
        if (tooltip != null && tooltip.startsWith(TextFormatting.GRAY + " - ")) {
            tooltip = tooltip.replaceFirst(TextFormatting.GRAY + " - ", "");
        }
        tooltip = side instanceof DoubleRequirement ? TextFormatting.GOLD + "(" + TextFormatting.RESET + tooltip + TextFormatting.GOLD + ')' : TextFormatting.RESET + tooltip;
        return tooltip;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DoubleRequirement) {
            DoubleRequirement dreq = (DoubleRequirement)o;
            return this.getRight().equals(dreq.getRight()) && this.getLeft().equals(dreq.getLeft()) || this.getRight().equals(dreq.getLeft()) && this.getLeft().equals(dreq.getRight());
        }
        return false;
    }

    public int hashCode() {
        long leftHash = this.getLeft().hashCode();
        long rightHash = this.getRight().hashCode();
        return (int)((leftHash + rightHash) / 2L);
    }

    @Override
    @Nonnull
    public List<Class<? extends Requirement>> getInternalTypes() {
        ArrayList<Class<? extends Requirement>> types = new ArrayList<Class<? extends Requirement>>();
        Requirement lReq = this.getLeft();
        Requirement rReq = this.getRight();
        if (lReq instanceof OuterRequirement) {
            types.addAll(((OuterRequirement)((Object)lReq)).getInternalTypes());
        } else {
            types.add(lReq.getClass());
        }
        if (rReq instanceof OuterRequirement) {
            types.addAll(((OuterRequirement)((Object)rReq)).getInternalTypes());
        } else {
            types.add(rReq.getClass());
        }
        return types;
    }

    @Override
    public boolean isCacheable() {
        return this.getLeft().isCacheable() && this.getRight().isCacheable();
    }
}

